# frozen_string_literal: true

class RemoveTmpIndexOnVulnerabilityReadsState < Gitlab::Database::Migration[2.2]
  milestone '17.6'
  disable_ddl_transaction!

  INDEX_NAME = 'tmp_index_vulnerability_reads_where_state_is_detected'
  TABLE_NAME = :vulnerability_reads

  def up
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end

  def down
    add_concurrent_index TABLE_NAME, :id, name: INDEX_NAME, where: "state = 1"
  end
end
