---
stage: Solutions Architecture
group: Solutions Architecture
info: This page is owned by the Solutions Architecture team.
title: ソリューションコンポーネント
---

このドキュメントのセクションでは、GitLabによって開発および提供されるさまざまなソリューションコンポーネントについて説明します。これらのソリューションコンポーネントをダウンロードして実行するには、招待コードについてアカウントチームにお問い合わせください。

ソリューションコンポーネントの使用には、[GitLabサブスクリプション契約](https://handbook.gitlab.com/handbook/legal/subscription-agreement/)（以下「契約」）が適用され、契約で定義されているFree Softwareを構成するものとします。

## DevSecOpsワークフロー {#devsecops-workflow}

エンドツーエンドのDevSecOpsワークフローを提供するGitLabソリューション。

[モバイルアプリ](workflow_mobileapps.md)

## 統合されたDevSecOps {#integrated-devsecops}

統合されたエンドツーエンドのDevSecOpsワークフローを提供するGitLabソリューション。

[セキュアソフトウェア開発ワークフロー: Snyk静的アプリケーションセキュリティテスト](integrated_snyk.md)

[変更管理ワークフロー: ServiceNow](integrated_servicenow.md)

## ユースケース別 {#by-use-cases}

標準およびアプリケーションセキュリティテストを強化するためのルールとポリシーを提供するGitLabソリューションパッケージ

[シークレット検出](secret_detection.md)

[OSSライセンスチェック](oss_license_check.md)

## KPIメトリクス {#metrics-and-kpis}

GitLabメトリクスおよびKPIダッシュボードとソリューション

[アプリケーションセキュリティKPIダッシュボードのKPIメトリクス](securitykpi.md)

DORAメトリクスの追跡を解除するために、JiraインシデントをGitLabに自動同期します。リアルタイムレプリケーションにより、変更失敗率およびサービス復旧時間の測定が可能になります。

[JiraからGitLab DORAメトリクスインテグレーション](jira_dora.md)

バリューストリーム分析メトリクスの追跡を解除するために、JiraイシューをGitLabに自動同期します。リアルタイムレプリケーションにより、リードタイム、イシュー作成、イシュークローズの測定が可能になります。

[JiraからGitLabバリューストリーム分析インテグレーション](jira_vsa.md)

## GenAIとデータサイエンス {#genai-and-data-science}

[エージェント型ワークフロー: コードスタイルガイドを適用](duo_workflow/duo_workflow_codestyle.md)

## コンプライアンスとベストプラクティス {#compliance-and-best-practices}

[職務分離に関するガイド](guide_on_sod.md)
