---
type: reference, howto
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 利用可能なCI/CD変数
---

<!--
  This documentation is auto generated by a script.
  Please do not edit this file directly.

  To edit the introductory text, modify `tooling/dast_variables/docs/templates/default.md.haml`.
  To edit information about the variables, modify `lib/gitlab/security/dast_variables.rb`.

  Run `bundle exec rake gitlab:dast_variables:compile_docs`
  or check the `compile_docs` task in `lib/tasks/gitlab/dast_variables.rake`.
-->

これらのCI/CD変数は、ブラウザーベースのDASTアナライザーに固有のものです。これらは、要件に合わせてDASTの動作をカスタマイズするために使用できます。

## スキャナーの動作 {#scanner-behavior}

これらの変数は、スキャンの実行方法と、その結果の保存場所を制御します。

| CI/CD変数 | 型 | 例 | 説明 |
| :------------- | :--- | ------- | :---------- |
| `DAST_CHECKS_TO_EXCLUDE` | 文字列 | `552.2,78.1` | スキャンから除外するチェック識別子のカンマ区切りリスト。識別子については、[vulnerability checks](../checks/_index.md)を参照してください。 |
| `DAST_CHECKS_TO_RUN` | 文字列のリスト | `16.1,16.2,16.3` | スキャンに使用するチェック識別子のカンマ区切りリスト。識別子については、[vulnerability checks](../checks/_index.md)を参照してください。 |
| `DAST_CRAWL_GRAPH` | ブール値 | `true` | スキャンのクロールフェーズ中にアクセスしたナビゲーションパスのSVGグラフを生成するには、`true`に設定します。生成されたグラフにアクセスするには、`gl-dast-crawl-graph.svg`をCIジョブのアーティファクトとして定義する必要があります。`false`がデフォルトです。 |
| `DAST_FULL_SCAN` | ブール値 | `true` | パッシブチェックとアクティブチェックの両方を実行するには、`true`に設定します。デフォルトは`false`です。 |
| `DAST_LOG_BROWSER_OUTPUT` | ブール値 | `true` | Chromium `STDOUT`と`STDERR`をログに記録するには、`true`に設定します。 |
| `DAST_LOG_CONFIG` | 文字列のリスト | `brows:debug,auth:debug` | コンソールログで使用する、モジュールとその目的とするログレベルのリスト。 |
| `DAST_LOG_DEVTOOLS_CONFIG` | 文字列 | `Default:messageAndBody,truncate:2000` | DASTとChromiumブラウザ間のプロトコルメッセージをログに記録するように設定します。 |
| `DAST_LOG_FILE_CONFIG` | 文字列のリスト | `brows:debug,auth:debug` | ファイルログで使用する、モジュールとその目的とするログレベルのリスト。 |
| `DAST_LOG_FILE_PATH` | 文字列 | `/output/browserker.log` | ファイルログのパスに設定します。デフォルトは`gl-dast-scan.log`です。 |
| `SECURE_ANALYZERS_PREFIX` | URL | `registry.organization.com` | アナライザーをダウンロードするDockerレジストリのベースアドレスを設定します。 |
| `SECURE_LOG_LEVEL` | 文字列 | `debug` | ファイルログのデフォルトレベルを設定します。[SECURE_LOG_LEVEL](../troubleshooting.md#secure_log_level)を参照してください。 |

## 要素、アクション、タイムアウト {#elements-actions-and-timeouts}

これらの変数は、特定要素の検索場所、実行するアクション、および操作完了までの待機時間をスキャナーに指示します。

| CI/CD変数 | 型 | 例 | 説明 |
| :------------- | :--- | ------- | :---------- |
| `DAST_ACTIVE_SCAN_TIMEOUT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `3h` | スキャンのアクティブスキャンフェーズが完了するまで待機する最大時間。デフォルトは3時間です。 |
| `DAST_ACTIVE_SCAN_WORKER_COUNT` | 数値 | `3` | 並行して実行するアクティブチェックの数。デフォルトは3です。 |
| `DAST_CRAWL_EXTRACT_ELEMENT_TIMEOUT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `5s` | ブラウザが新しく見つかった要素またはナビゲーションを抽出できるようにする最大時間。`5s`がデフォルトです。 |
| `DAST_CRAWL_MAX_ACTIONS` | 数値 | `10000` | クローラーが実行するアクションの最大数。アクションの例としては、リンクの選択やフォームへの入力などがあります。`10000`がデフォルトです。 |
| `DAST_CRAWL_MAX_DEPTH` | 数値 | `10` | クローラーが実行するチェーンアクションの最大数。たとえば、`Click, Form Fill, Click`は深さ3です。`10`がデフォルトです。 |
| `DAST_CRAWL_SEARCH_ELEMENT_TIMEOUT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `3s` | ブラウザが新しい要素またはユーザーアクションを検索できるようにする最大時間。`3s`がデフォルトです。 |
| `DAST_CRAWL_TIMEOUT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `5m` | スキャンのクロールフェーズが完了するまで待機する最大時間。`24h`がデフォルトです。 |
| `DAST_CRAWL_WORKER_COUNT` | 数値 | `3` | 使用する同時ブラウザインスタンスの最大数。GitLab.comのインスタンスRunnerの場合、最大3つを推奨します。より多くのリソースを持つプライベートRunnerは、より高い数からメリットを得られる可能性がありますが、5〜7つのインスタンスを超えるとほとんどメリットが得られません。デフォルト値は動的で、使用可能な論理CPUの数に等しくなります。 |
| `DAST_PAGE_DOM_READY_TIMEOUT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `7s` | ナビゲーションが完了した後、ブラウザがページをロード済みとみなし、分析の準備ができるまで待機する最大時間。`6s`がデフォルトです。 |
| `DAST_PAGE_DOM_STABLE_WAIT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `200ms` | ページが安定しているか確認する前に、DOMの更新を待機する時間を定義します。`500ms`がデフォルトです。 |
| `DAST_PAGE_ELEMENT_READY_TIMEOUT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `600ms` | 要素が分析の準備ができていると判断するまで待機する最大時間。`300ms`がデフォルトです。 |
| `DAST_PAGE_IS_LOADING_ELEMENT` | [セレクター](authentication.md#finding-an-elements-selector) | `css:#page-is-loading` | ページに表示されなくなった場合、ページがロードを完了し、スキャンを続行できることをアナライザーに示すセレクター。`DAST_PAGE_IS_READY_ELEMENT`とは併用できません。 |
| `DAST_PAGE_IS_READY_ELEMENT` | [セレクター](authentication.md#finding-an-elements-selector) | `css:#page-is-ready` | ページに表示されていることが検出された場合、ページがロードを完了し、スキャンを続行できることをアナライザーに示すセレクター。`DAST_PAGE_IS_LOADING_ELEMENT`とは併用できません。 |
| `DAST_PAGE_MAX_RESPONSE_SIZE_MB` | 数値 | `15` | HTTP応答本文の最大サイズ。これより大きい本文を含む応答は、ブラウザによってブロックされます。デフォルトは`10`MBです。 |
| `DAST_PAGE_READY_AFTER_ACTION_TIMEOUT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `7s` | ブラウザがページをロード済みとみなし、分析の準備ができるまで待機する最大時間。`7s`がデフォルトです。 |
| `DAST_PAGE_READY_AFTER_NAVIGATION_TIMEOUT` | [期間文字列](https://pkg.go.dev/time#ParseDuration) | `15s` | ブラウザがページ間を移動するまで待機する最大時間。`15s`がデフォルトです。 |
| `DAST_PASSIVE_SCAN_WORKER_COUNT` | int | `5` | パッシブスキャンを並行して行うワーカーの数。デフォルトは、使用可能なCPUの数です。 |
| `DAST_PKCS12_CERTIFICATE_BASE64` | 文字列 | `ZGZkZ2p5NGd...` | 相互TLSを必要とするサイトで使用されるPKCS12証明書。base64テキストとしてエンコードする必要があります。 |
| `DAST_PKCS12_PASSWORD` | 文字列 | `password` | `DAST_PKCS12_CERTIFICATE_BASE64`で使用される証明書のパスワード。GitLab UIを使用して、機密性の高い[custom CI/CI variables](../../../../../ci/variables/_index.md#define-a-cicd-variable-in-the-ui)を作成します。 |
| `DAST_REQUEST_ADVERTISE_SCAN` | ブール値 | `true` | 送信されるすべてのリクエストに`Via: GitLab DAST <version>`ヘッダーを追加し、そのリクエストがGitLab DASTスキャンの一部として送信されたことを通知するには、`true`に設定します。デフォルトは`false`です。 |
| `DAST_REQUEST_COOKIES` | dictionary | `abtesting_group:3,region:locked` | すべてのリクエストに追加されるCookie名と値。 |
| `DAST_REQUEST_HEADERS` | 文字列 | `Cache-control:no-cache` | カンマ区切りのリクエストヘッダー名と値のリストに設定します。次のヘッダーはサポートされていません: `content-length`、`cookie2`、`keep-alive`、`hosts`、`trailer`、`transfer-encoding`、および`proxy-`プレフィックスが付いたすべてのヘッダー。 |
| `DAST_SCOPE_ALLOW_HOSTS` | 文字列のリスト | `site.com,another.com` | この変数に含まれるホスト名は、クロール時にスコープ内と見なされます。デフォルトでは、`DAST_TARGET_URL`識別子は許可されたホストのリストに含まれています。`DAST_REQUEST_HEADERS`を使用して設定されたヘッダーは、これらのホスト名に対するすべてのリクエストに追加されます。 |
| `DAST_SCOPE_EXCLUDE_ELEMENTS` | [セレクター](authentication.md#finding-an-elements-selector) | `a[href='2.html'],css:.no-follow` | スキャン時に無視されるセレクターのカンマ区切りリスト。 |
| `DAST_SCOPE_EXCLUDE_HOSTS` | 文字列のリスト | `site.com,another.com` | この変数に含まれるホスト名は除外と見なされ、接続は強制的にドロップされます。 |
| `DAST_SCOPE_IGNORE_HOSTS` | 文字列のリスト | `site.com,another.com` | この変数に含まれるホスト名はアクセスされますが、攻撃されず、報告されません。 |
| `DAST_TARGET_CHECK_SKIP` | ブール値 | `true` | DASTがスキャン前にターゲットが利用可能かどうかをチェックしないようにするには、`true`に設定します。デフォルトは`false`です。 |
| `DAST_TARGET_CHECK_TIMEOUT` | 数値 | `60` | ターゲットの可用性を待機するタイムアウト（秒単位）。デフォルトは`60s`です。 |
| `DAST_TARGET_PATHS_FILE` | 文字列 | `/builds/project/urls.txt` | サイト全体をクロールする代わりに、これらのパスのみをスキャンします。`DAST_TARGET_URL`に対する相対的なURLパスのリストを含むファイルパスに設定します。ファイルは、1行に1つのパスを含むプレーンテキストである必要があります。これが設定されている場合、`DAST_CRAWL_MAX_DEPTH`はデフォルトで1になります。これを防ぐには、`DAST_OVERRIDE_MAX_DEPTH: false`を設定します。 |
| `DAST_TARGET_PATHS` | 文字列 | `/page1.html,/category1/page3.html` | サイト全体をクロールする代わりに、これらのパスのみをスキャンします。`DAST_TARGET_URL`に対する相対的なURLパスのカンマ区切りリストに設定します。これが設定されている場合、`DAST_CRAWL_MAX_DEPTH`はデフォルトで1になります。これを防ぐには、`DAST_OVERRIDE_MAX_DEPTH: false`を設定します。 |
| `DAST_TARGET_URL` | URL | `https://site.com` | スキャンするWebサイトのURL。 |
| `DAST_USE_CACHE` | ブール値 | `true` | キャッシュを無効にするには、`false`に設定します。デフォルトは`true`です。**メモ**: キャッシュを無効にすると、OOMイベントまたはDASTジョブのタイムアウトが発生する可能性があります。 |
| `DAST_CRAWL_GROUPED_URLS` | 文字列 | `https://example.com/hello/*,https://example.com/world/*/details` | （試験的）少なくとも1つの`*`を含む、ワイルドカードURLパターンのカンマ区切りリストに設定します。スキャン時間を短縮するために、スキャナーはパターンごとに1つの一致したURLのみをグループ化して分析します。 |

### 認証 {#authentication}

これらの変数は、アプリケーションで認証する方法をスキャナーに指示します。

| CI/CD変数 | 型 | 例 | 説明 |
| :------------- | :--- | ------- | :---------- |
| `DAST_AUTH_AFTER_LOGIN_ACTIONS` | 文字列 | `select(option=id:accept-yes),click(on=css:.continue)` | ログイン後、ログイン検証前に実行するアクションのカンマ区切りリスト。`click`アクションと`select`アクションをサポートします。[Taking additional actions after submitting the login form](authentication.md#taking-additional-actions-after-submitting-the-login-form)を参照してください。 |
| `DAST_AUTH_BEFORE_LOGIN_ACTIONS` | [セレクター](authentication.md#finding-an-elements-selector) | `css:.user,id:show-login-form` | ログインフォームにDAST_AUTH_USERNAMEとDAST_AUTH_PASSWORDを入力する前にクリックする要素を表す、セレクターのカンマ区切りリスト。 |
| `DAST_AUTH_CLEAR_INPUT_FIELDS` | ブール値 | `true` | 手動ログインを試行する前に、ユーザー名とパスワードフィールドのクリアを無効にします。デフォルトではfalseに設定されます。 |
| `DAST_AUTH_COOKIE_NAMES` | 文字列 | `sessionID,groupName` | 使用するCookieを認証用に指定するCookie名のカンマ区切りリストに設定します。 |
| `DAST_AUTH_FIRST_SUBMIT_FIELD` | [セレクター](authentication.md#finding-an-elements-selector) | `css:input[type=submit]` | 複数ページのログインプロセスのユーザー名フォームを送信するためにクリックされる要素を記述するセレクター。 |
| `DAST_AUTH_NEGOTIATE_DELEGATION` | 文字列 | `*.example.com,example.com,*.EXAMPLE.COM,EXAMPLE.COM` | 統合認証と委任に許可されるサーバー。このプロパティは、2つのChromiumポリシーを設定します: [AuthServerAllowlist](https://chromeenterprise.google/policies/#AuthServerAllowlist)と[AuthNegotiateDelegateAllowlist](https://chromeenterprise.google/policies/#AuthNegotiateDelegateAllowlist)。GitLab 17.6で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/502476)されました。 |
| `DAST_AUTH_OTP_FIELD` | [セレクター](authentication.md#finding-an-elements-selector) | `name:otp` | ログインフォームにワンタイムパスワードを入力するために使用される要素を記述するセレクター。 |
| `DAST_AUTH_OTP_KEY` | 文字列 | `I5UXITDBMIQEIQKTKQFA====` | Webサイトへの認証時にワンタイムパスワードを生成するために使用する、Base32エンコードされたシークレットキー。 |
| `DAST_AUTH_OTP_SUBMIT_FIELD` | [セレクター](authentication.md#finding-an-elements-selector) | `css:input[type=submit]` | ユーザー名とは別のOTPフォームを送信するためにクリックされる要素を記述するセレクター。 |
| `DAST_AUTH_PASSWORD` | 文字列 | `P@55w0rd!` | Webサイトで認証するためのパスワード。 |
| `DAST_AUTH_PASSWORD_FIELD` | [セレクター](authentication.md#finding-an-elements-selector) | `name:password` | ログインフォームにパスワードを入力するために使用される要素を記述するセレクター。 |
| `DAST_AUTH_SUBMIT_FIELD` | [セレクター](authentication.md#finding-an-elements-selector) | `css:input[type=submit]` | シングルページのログインフォームの場合はログインフォームを送信するために、またはマルチページのログインフォームの場合はパスワードフォームを送信するためにクリックされる要素を記述するセレクター。 |
| `DAST_AUTH_SUCCESS_IF_AT_URL` | URL | `https://www.site.com/welcome*` | ログインフォームが送信された後、認証が成功したかどうかを判断するためにブラウザのURLと比較されるURL。ワイルドカード`*`を使用して、動的なURLを照合できます。 |
| `DAST_AUTH_SUCCESS_IF_ELEMENT_FOUND` | [セレクター](authentication.md#finding-an-elements-selector) | `css:.user-avatar` | ログインフォームが送信された後、認証が成功したかどうかを判断するために、その存在が使用される要素を記述するセレクター。 |
| `DAST_AUTH_SUCCESS_IF_NO_LOGIN_FORM` | ブール値 | `true` | ログインフォームが送信された後、ログインフォームがないことを確認して、成功した認証を確認します。この成功チェックはデフォルトで有効になっています。 |
| `DAST_AUTH_TYPE` | 文字列 | `basic-digest` | 使用する認証の種類。 |
| `DAST_AUTH_URL` | URL | `https://www.site.com/login` | ターゲットWebサイト上のログインフォームがあるページのURL。認証されたスキャンを作成するために、DAST_AUTH_USERNAMEとDAST_AUTH_PASSWORDがログインフォームとともに送信されます。 |
| `DAST_AUTH_USERNAME` | 文字列 | `user@email.com` | Webサイトで認証するユーザー名。 |
| `DAST_AUTH_USERNAME_FIELD` | [セレクター](authentication.md#finding-an-elements-selector) | `name:username` | ログインフォームにユーザー名を入力するために使用される要素を記述するセレクター。 |
| `DAST_SCOPE_EXCLUDE_URLS` | URL | `https://site.com/.*/sign-out` | 認証されたスキャン中にスキップするURL（カンマ区切り）。正規表現構文を使用して、複数のURLを照合できます。たとえば、`.*`は任意の文字シーケンスと一致します。 |
| `DAST_AUTH_REPORT` | ブール値 | `true` | 認証プロセス中に実行された手順を詳述するレポートを生成するには、`true`に設定します。生成されたレポートにアクセスするには、`gl-dast-debug-auth-report.html`をCIジョブアーティファクトとして定義する必要もあります。レポートの内容は、認証の失敗をデバッグする際に役立ちます。`false`がデフォルトです。 |
