---
stage: Software Supply Chain Security
group: Compliance
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: コンプライアンス標準
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 17.11で[導入](https://gitlab.com/groups/gitlab-org/-/epics/16620)されました。

{{< /history >}}

多くのコンプライアンス標準の要件を満たすために、[GitLabのコンプライアンスコントロール](_index.md#gitlab-compliance-controls)を使用できます。

[コンプライアンス遵守テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates)プロジェクトには、JSONテンプレートのライブラリが含まれています。これらのテンプレートを使用して、定義済みのコンプライアンスフレームワークを迅速に採用します。

<!-- Content for tables is sourced from https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates -->

## CIS CSCのコンプライアンス要件 {#cis-csc-compliance-requirements}

CIS CSCは、Center for Internet Securityのクリティカルセキュリティコントロールです。

次の表に、GitLabがサポートするCIS CSC v8.1の要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`cis_csc_v8-1.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/cis_csc_v8-1.json?ref_type=heads)を使用します。

| CIS CSC v8.1の要件                                                          | 説明                                                                                                                                                        | サポートされているコントロール |
|:----------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 6.7アクセス制御の一元化                                                     | サポートされている場合、ディレクトリサービスまたはSSOプロバイダーを介して、すべてのエンタープライズアセットのアクセス制御を一元化します。                                                  | <ul><li>認証SSOが有効</li></ul> |
| 7.5内部エンタープライズアセットの自動脆弱性スキャンを実行する           | 四半期ごと、またはより頻繁に、内部エンタープライズアセットの自動脆弱性スキャンを実行します。認証済みスキャンと未認証スキャンの両方を実施します。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| 7.6外部公開されているエンタープライズアセットの自動脆弱性スキャンを実行する | 外部公開されているエンタープライズアセットの自動脆弱性スキャンを実行します。月単位、またはより頻繁にスキャンを実行します。                                | <ul><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| 16.12コードレベルのセキュリティチェックを実装する                                        | アプリケーションセキュリティライフサイクル内で静的解析ツールと動的解析ツールを適用して、安全なコーディングプラクティスが守られていることを確認します。                                | <ul><li>SASTを実行中</li><li>DASTを実行中</li><li>シークレット検出を実行中</li></ul> |

## CSA CCMのコンプライアンス要件 {#csa-ccm-compliance-requirements}

CSA CCMは、Cloud Security Alliance（CSA）のCloud Controls Matrix（CCM）です。

次の表に、GitLabがサポートするCSA CCM v4の要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`csa_ccm_v4.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/csa_ccm_v4.json?ref_type=heads)を使用します。

| CSA CCM v4の要件                  | 説明                                                                                                                                                                                                                      | サポートされているコントロール |
|:----------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| CCC-02品質テスト                  | 確立されたベースライン、テスト、およびリリース標準を使用して、定義された品質の変更管理、承認、およびテストプロセスに従います。                                                                                                | <ul><li>デフォルトブランチの保護</li><li>コード品質の実行</li></ul> |
| CCC-04不正な変更の保護   | 組織のアセットに対する不正な追加、削除、更新、および管理を制限します。                                                                                                                                      | <ul><li>デフォルトブランチの保護</li></ul> |
| IAM-04職務分離             | 情報システムへのアクセスを実装する際に、職務分離の原則を採用します。                                                                                                                                           | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| IAM-15パスワード管理             | パスワードの安全な管理のためのプロセス、手順、および技術的対策を定義、実装、および評価します。                                                                                                              | <ul><li>シークレット検出を実行中</li></ul> |
| TVM-05外部ライブラリの脆弱性 | 組織の脆弱性管理ポリシーに従って、サードパーティまたはオープンソースライブラリを使用するアプリケーションの更新を識別するためのプロセス、手順、および技術的対策を定義、実装、および評価します。 | <ul><li>コンテナスキャンを実行中</li></ul> |
| TVM-07脆弱性の特定     | 少なくとも月1回、組織的に管理されているアセットの脆弱性を検出するためのプロセス、手順、および技術的対策を定義、実装、および評価します。                                                            | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |

## Cyber Essentialsのコンプライアンス要件 {#cyber-essentials-compliance-requirements}

次の表に、GitLabがサポートするCyber Essentialsの要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`cyber_essentials.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/cyber_essentials.json?ref_type=heads)を使用します。

| Cyber Essentialsの要件 | 説明                                                                                                                                                                                                                                                                                                                                                        | サポートされているコントロール |
|:-----------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| A6.2サポートされているソフトウェア      | デバイス上のすべてのソフトウェアは、セキュリティ上の問題に対する定期的な修正を提供するサプライヤーによってサポートされていますか？組織で使用されるすべてのソフトウェアは、定期的なセキュリティアップデートを提供するサプライヤーによってサポートされている必要があります。サポートされていないソフトウェアは、デバイスから削除する必要があります。これには、Java、Adobe Reader、.NETなどのフレームワークとプラグインが含まれます。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| A6.3ソフトウェアライセンス      | すべてのソフトウェアは、発行元の推奨事項に従ってライセンスされていますか？すべてのソフトウェアはライセンスされている必要があります。ライセンス要件に準拠している限り、Freeおよびオープンソースのソフトウェアを使用することは許容されます。                                                                                                                                           | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |

## DORAのコンプライアンス要件 {#dora-compliance-requirements}

DORAは、DevOps Research and Assessmentです。

次の表に、GitLabがサポートするDORAの要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`dora.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/dora.json?ref_type=heads)を使用します。

| DORAの要件                            | 説明                                                                                                                                                                                                                                                                                                                                                                                                     | サポートされているコントロール |
|:--------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 第8条識別                    | 2\.金融機関は、継続的に、ICTリスクのすべてのソース、特に他の金融機関からの、および他の金融機関へのリスクエクスポージャーを特定し、ICTがサポートするビジネス機能、情報資産、およびICT資産に関連するサイバー脅威とICTの脆弱性を評価するものとします。金融機関は、定期的に、少なくとも年に1回、それらに影響を与えるリスクシナリオをレビューするものとします。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| 第9条保護と予防         | 4\.金融機関は、ICTリスク管理フレームワークの一部として、文書化されたポリシー、手順、およびICT変更管理のコントロールを実装するものとします。これらの変更には、ソフトウェア、ハードウェア、ファームウェア、システム、またはセキュリティパラメータが含まれ、全体的な変更管理プロセスの一部として、リスク評価アプローチに基づく必要があります。                                                               | <ul><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| 第25条ICTツールおよびシステムのテスト | 1\.デジタル運用回復性テストプログラムには、脆弱性の評価、スキャン、オープンソース分析、ネットワークセキュリティ評価、ギャップ分析、コードレビュー、シナリオベースのテスト、互換性テスト、パフォーマンステスト、およびペネトレーションテストが含まれるものとします。テストは、重要な機能をサポートするアプリケーションとインフラストラクチャのデプロイ前に必要です。                    | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |

## FedRAMPのコンプライアンス要件 {#fedramp-compliance-requirements}

FedRAMP（米国連邦情報セキュリティ管理プログラム）は、政府機関の運営、資産、または個人に対するデータ漏洩の潜在的な影響に基づいて、クラウドサービスを低、中、高の3つの影響レベルに分類します: 低、中、高は、政府機関の運営、資産、または個人に対するデータ漏洩の潜在的な影響に基づいています。

これらのレベルは、クラウドサービスプロバイダー（CSP）がFedRAMP認可を取得するために満たす必要のある、さまざまなセキュリティコントロールと要件のセットに対応しています。コントロールは、FedRAMP低、FedRAMP中、およびFedRAMP高コンプライアンスで使用できます。

### FedRAMP低コンプライアンス要件 {#fedramp-low-compliance-requirements}

次の表に、GitLabがサポートするFedRAMP低の要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`fedramp_low_r5.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/fedramp_low_r5.json?ref_type=heads)を使用します。

| FedRAMP低要件                                    | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                       | サポートされているコントロール |
|:-----------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| CM-5: 変更のアクセス制御                       | システムへの変更に関連する物理的および論理的なアクセス制御を定義、ドキュメント化、承認、および実施します。                                                                                                                                                                                                                                                                                                                            | <ul><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li></ul> |
| CM-6: 設定                               | システムコンポーネントの安全な設定を確立およびドキュメント化します。これらの設定を実装します。運用要件に基づいて逸脱を特定、ドキュメント化、および承認します。組織のポリシーに従って、設定の変更をモニタリングおよび制御します。                                                                                                                                                                       | <ul><li>作成者が承認したマージリクエストは禁止されています</li></ul> |
| CM-7: 最小限の機能                                  | 組織で定義されたミッションに不可欠な機能のみを提供するようにシステムを設定します。組織で定義された禁止または制限された機能、システムポート、プロトコル、ソフトウェア、および/またはサービスである、次の機能、ポート、プロトコル、ソフトウェア、および/またはサービスの使用を禁止または制限します。                                                                                                                                  | <ul><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-10: ソフトウェアの使用制限                         | 契約合意および著作権法に従ってソフトウェアおよび関連ドキュメントを使用します。数量ライセンスによって保護されているソフトウェアおよび関連ドキュメントの使用状況を追跡して、コピーと配布を制御します。ピアツーピアのファイル共有テクノロジーの使用を制御およびドキュメント化して、この機能が著作権で保護された作品の不正な配布、表示、パフォーマンス、または複製に使用されないようにします。 | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |
| IA-2(12): PIV認証情報の受け入れ                    | Personal Identity Verification（PIV）認証情報を受け入れて電子的に検証します。                                                                                                                                                                                                                                                                                                                                                                | <ul><li>認証SSOが有効</li></ul> |
| IA-8(1): 他の機関からのPIV認証情報の受け入れ | 他の連邦政府機関からのPersonal Identity Verification（PIV）認証情報を受け入れて電子的に検証します。                                                                                                                                                                                                                                                                                                                                    | <ul><li>認証SSOが有効</li></ul> |
| RA-5: 脆弱性のモニタリングとスキャン                | システムとホストされているアプリケーションの脆弱性をスキャンします。脆弱性スキャンツールと手法を使用します。脆弱性スキャンのレポートと結果を分析します。正当な脆弱性を修正します。脆弱性情報を共有します。                                                                                                                                                                                                    | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |

### FedRAMP中コンプライアンス要件 {#fedramp-moderate-compliance-requirements}

次の表に、GitLabがサポートするFedRAMP中の要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`fedramp_moderate_r5.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/fedramp_moderate_r5.json?ref_type=heads)を使用します。

| FedRAMP中要件                               | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                       | サポートされているコントロール |
|:-----------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| AC-5: 職務分離                                 | 個人間の職務を分離して、共謀のない悪意のある活動を防ぎます。職務分離をドキュメント化します。職務分離をサポートするために、システムアクセス制御を定義します。                                                                                                                                                                                                                                                          | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-3: 設定変更コントロール                         | 設定制御された変更のタイプを決定します。セキュリティ/プライバシーへの影響分析で変更をレビューおよび承認します。決定をドキュメント化します。承認された変更を実装します。レコードを保持します。変更に関連するアクティビティーをモニタリングします。指定された要素を通じて変更管理の監視を調整します。                                                                                                                                           | <ul><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-5: 変更のアクセス制御                       | システムへの変更に関連する物理的および論理的なアクセス制御を定義、ドキュメント化、承認、および実施します。                                                                                                                                                                                                                                                                                                                            | <ul><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li></ul> |
| CM-6: 設定                               | システムコンポーネントの安全な設定を確立およびドキュメント化します。これらの設定を実装します。運用要件に基づいて逸脱を特定、ドキュメント化、および承認します。組織のポリシーに従って、設定の変更をモニタリングおよび制御します。                                                                                                                                                                       | <ul><li>作成者が承認したマージリクエストは禁止されています</li></ul> |
| CM-7: 最小限の機能                                  | 組織で定義されたミッションに不可欠な機能のみを提供するようにシステムを設定します。組織で定義された禁止または制限された機能、システムポート、プロトコル、ソフトウェア、および/またはサービスである、次の機能、ポート、プロトコル、ソフトウェア、および/またはサービスの使用を禁止または制限します。                                                                                                                                  | <ul><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-10: ソフトウェアの使用制限                         | 契約合意および著作権法に従ってソフトウェアおよび関連ドキュメントを使用します。数量ライセンスによって保護されているソフトウェアおよび関連ドキュメントの使用状況を追跡して、コピーと配布を制御します。ピアツーピアのファイル共有テクノロジーの使用を制御およびドキュメント化して、この機能が著作権で保護された作品の不正な配布、表示、パフォーマンス、または複製に使用されないようにします。 | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |
| IA-2(12): PIV認証情報の受け入れ                    | Personal Identity Verification（PIV）認証情報を受け入れて電子的に検証します。                                                                                                                                                                                                                                                                                                                                                                | <ul><li>認証SSOが有効</li></ul> |
| IA-5(7): 埋め込み非暗号化静的認証情報     | 暗号化されていない静的な認証情報が、アプリケーションまたはその他の形式の静的ストレージに埋め込まれていないことを確認します。                                                                                                                                                                                                                                                                                                                                  | <ul><li>シークレット検出を実行中</li></ul> |
| IA-8(1): 他の機関からのPIV認証情報の受け入れ | 他の連邦政府機関からのPersonal Identity Verification（PIV）認証情報を受け入れて電子的に検証します。                                                                                                                                                                                                                                                                                                                                    | <ul><li>認証SSOが有効</li></ul> |
| RA-5: 脆弱性のモニタリングとスキャン                | システムとホストされているアプリケーションの脆弱性をスキャンします。脆弱性スキャンツールと手法を使用します。脆弱性スキャンのレポートと結果を分析します。正当な脆弱性を修正します。脆弱性情報を共有します。                                                                                                                                                                                                    | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| SA-11(1): 静的コード解析                             | システム、システムコンポーネント、またはシステムサービスのデベロッパーに対し、一般的な欠陥を特定し、分析結果をドキュメント化するために、静的コード解析ツールを使用することを要求します。                                                                                                                                                                                                                                                                  | <ul><li>SASTを実行中</li></ul> |
| SA-11(8): 動的コード解析                            | システム、システムコンポーネント、またはシステムサービスのデベロッパーに対し、一般的な欠陥を特定し、分析結果をドキュメント化するために、動的コード解析ツールを使用することを要求します。                                                                                                                                                                                                                                                                 | <ul><li>DASTを実行中</li></ul> |

### FedRAMP Highのコンプライアンス要件 {#fedramp-high-compliance-requirements}

次の表に、GitLabがサポートするFedRAMP Highの要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`fedramp_high_r5.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/fedramp_high_r5.json?ref_type=heads)を使用します。

| FedRAMP Highの要件                                                   | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                       | サポートされているコントロール |
|:---------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| AC-5: 職務分離                                                 | 個人間の職務を分離して、共謀のない悪意のある活動を防ぎます。職務分離をドキュメント化します。職務分離をサポートするために、システムアクセス制御を定義します。                                                                                                                                                                                                                                                          | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-3: 設定変更コントロール                                         | 設定制御された変更のタイプを決定します。セキュリティ/プライバシーへの影響分析で変更をレビューおよび承認します。決定をドキュメント化します。承認された変更を実装します。レコードを保持します。変更に関連するアクティビティーをモニタリングします。指定された要素を通じて変更管理の監視を調整します。                                                                                                                                           | <ul><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-3(1): 変更の自動ドキュメント化、通知、および禁止 | 自動化されたメカニズムを使用して、システムに対する提案された変更をドキュメント化します。組織で定義された承認権限者に通知します。組織で定義された期間までに受信されなかった変更承認を強調表示します。指定された承認を受信するまで、システムへの変更を禁止します。システムへのすべての変更をドキュメント化します。                                                                                                                | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-5: 変更のアクセス制御                                       | システムへの変更に関連する物理的および論理的なアクセス制御を定義、ドキュメント化、承認、および実施します。                                                                                                                                                                                                                                                                                                                            | <ul><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li></ul> |
| CM-6: 設定                                               | システムコンポーネントの安全な設定を確立およびドキュメント化します。これらの設定を実装します。運用要件に基づいて逸脱を特定、ドキュメント化、および承認します。組織のポリシーに従って、設定の変更をモニタリングおよび制御します。                                                                                                                                                                       | <ul><li>作成者が承認したマージリクエストは禁止されています</li></ul> |
| CM-7: 最小限の機能                                                  | 組織で定義されたミッションに不可欠な機能のみを提供するようにシステムを設定します。組織で定義された禁止または制限された機能、システムポート、プロトコル、ソフトウェア、および/またはサービスである、次の機能、ポート、プロトコル、ソフトウェア、および/またはサービスの使用を禁止または制限します。                                                                                                                                  | <ul><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-10: ソフトウェアの使用制限                                         | 契約合意および著作権法に従ってソフトウェアおよび関連ドキュメントを使用します。数量ライセンスによって保護されているソフトウェアおよび関連ドキュメントの使用状況を追跡して、コピーと配布を制御します。ピアツーピアのファイル共有テクノロジーの使用を制御およびドキュメント化して、この機能が著作権で保護された作品の不正な配布、表示、パフォーマンス、または複製に使用されないようにします。 | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |
| IA-2(12): PIV認証情報の受け入れ                                    | Personal Identity Verification（PIV）認証情報を受け入れて電子的に検証します。                                                                                                                                                                                                                                                                                                                                                                | <ul><li>認証SSOが有効</li></ul> |
| IA-5(7): 埋め込み非暗号化静的認証情報                     | 暗号化されていない静的な認証情報が、アプリケーションまたはその他の形式の静的ストレージに埋め込まれていないことを確認します。                                                                                                                                                                                                                                                                                                                                  | <ul><li>シークレット検出を実行中</li></ul> |
| IA-8(1): 他の機関からのPIV認証情報の受け入れ                 | 他の連邦政府機関からのPersonal Identity Verification（PIV）認証情報を受け入れて電子的に検証します。                                                                                                                                                                                                                                                                                                                                    | <ul><li>認証SSOが有効</li></ul> |
| RA-5: 脆弱性のモニタリングとスキャン                                | システムとホストされているアプリケーションの脆弱性をスキャンします。脆弱性スキャンツールと手法を使用します。脆弱性スキャンのレポートと結果を分析します。正当な脆弱性を修正します。脆弱性情報を共有します。                                                                                                                                                                                                    | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| SA-11(1): 静的コード解析                                             | システム、システムコンポーネント、またはシステムサービスのデベロッパーに対し、一般的な欠陥を特定し、分析結果をドキュメント化するために、静的コード解析ツールを使用することを要求します。                                                                                                                                                                                                                                                                  | <ul><li>SASTを実行中</li></ul> |
| SA-11(8): 動的コード解析                                            | システム、システムコンポーネント、またはシステムサービスのデベロッパーに対し、一般的な欠陥を特定し、分析結果をドキュメント化するために、動的コード解析ツールを使用することを要求します。                                                                                                                                                                                                                                                                 | <ul><li>DASTを実行中</li></ul> |

## IRAPコンプライアンス要件 {#irap-compliance-requirements}

IRAPは、インフォセック登録査定者プログラムです。コントロールは、IRAPオフィシャル、IRAPプロテクト、IRAPシークレット、およびIRAPトップシークレットで利用できます。

### IRAPオフィシャル {#irap-official}

次の表に、GitLabがサポートするIRAPオフィシャルの要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`irap_official.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/irap_official.json?ref_type=heads)を使用します。

| IRAPオフィシャルの要件                                 | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                                 | サポートされているコントロール |
|:----------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ISM-0402 アプリケーションセキュリティテスト                     | アプリケーションは、最初のリリースおよびその後のリリースの前に、静的アプリケーションセキュリティテストと動的アプリケーションセキュリティテストを使用して、脆弱性について包括的にテストされます。                                                                                                                                                                                                                                                | <ul><li>SASTを実行中</li><li>DASTを実行中</li></ul> |
| ISM-1163継続的なモニタリング計画                       | システムには、少なくとも2週間ごとにシステムの脆弱性スキャンを実施し、デプロイ前にシステムに対して脆弱性評価と侵入テストを実施し、重大な変更のデプロイ前、およびその後少なくとも年11回、特定された脆弱性を分析して潜在的な影響を判断し、リスク、有効性、およびコストに基づいて軽減策を実施することを含む、継続的なモニタリング計画があります。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1422開発、テスト、本番環境 | ソフトウェアの信頼できるソースへの不正なアクセスは防止されます。                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>デフォルトブランチの保護</li></ul> |
| ISM-1698軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、オンラインサービスの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも毎日使用されます。                                                                                                                                                                                                                                                                                                                               | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1700軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、オフィス生産性スイート、Webブラウザーおよびそれらの拡張機能、メールクライアント、PDFソフトウェア、およびセキュリティ製品以外のアプリケーションの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも2週間ごとに使用されます。                                                                                                                                                                                               | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1701軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、インターネットに接続されたサーバーおよびインターネットに接続されたネットワークデバイスのオペレーティングシステムの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも毎日使用されます。                                                                                                                                                                                                                                                              | <ul><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1702軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、ワークステーション、インターネットに接続されていないサーバー、およびインターネットに接続されていないネットワークデバイスのオペレーティングシステムの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも2週間ごとに使用されます。                                                                                                                                                                                                                                  | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1808軽減されていない脆弱性のスキャン         | 最新の脆弱性データベースを備えた脆弱性スキャナーは、脆弱性スキャンアクティビティーに使用されます。                                                                                                                                                                                                                                                                                                                                            | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1816開発、テスト、本番環境 | ソフトウェアの信頼できるソースの不正な変更は防止されます。                                                                                                                                                                                                                                                                                                                                                                            | <ul><li>デフォルトブランチの保護</li></ul> |
| ISM-1875認証情報の保護                           | 認証情報がクリアに保存されているかどうかを特定するために、ネットワークは少なくとも月1回スキャンされます。                                                                                                                                                                                                                                                                                                                                                       | <ul><li>シークレット検出を実行中</li></ul> |

### IRAPプロテクト {#irap-protected}

次の表に、GitLabがサポートするIRAPプロテクトの要件と、要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`irap_protected.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/irap_protected.json?ref_type=heads)を使用します。

| IRAPプロテクトの要件                                | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                                 | サポートされているコントロール |
|:----------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ISM-0402 アプリケーションセキュリティテスト                     | アプリケーションは、最初のリリースおよびその後のリリースの前に、静的アプリケーションセキュリティテストと動的アプリケーションセキュリティテストを使用して、脆弱性について包括的にテストされます。                                                                                                                                                                                                                                                | <ul><li>SASTを実行中</li><li>DASTを実行中</li></ul> |
| ISM-1163継続的なモニタリング計画                       | システムには、少なくとも2週間ごとにシステムの脆弱性スキャンを実施し、デプロイ前にシステムに対して脆弱性評価と侵入テストを実施し、重大な変更のデプロイ前、およびその後少なくとも年11回、特定された脆弱性を分析して潜在的な影響を判断し、リスク、有効性、およびコストに基づいて軽減策を実施することを含む、継続的なモニタリング計画があります。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1422開発、テスト、本番環境 | ソフトウェアの信頼できるソースへの不正なアクセスは防止されます。                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>デフォルトブランチの保護</li></ul> |
| ISM-1698軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、オンラインサービスの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも毎日使用されます。                                                                                                                                                                                                                                                                                                                               | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1700軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、オフィス生産性スイート、Webブラウザーおよびそれらの拡張機能、メールクライアント、PDFソフトウェア、およびセキュリティ製品以外のアプリケーションの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも2週間ごとに使用されます。                                                                                                                                                                                               | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1701軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、インターネットに接続されたサーバーおよびインターネットに接続されたネットワークデバイスのオペレーティングシステムの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも毎日使用されます。                                                                                                                                                                                                                                                              | <ul><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1702軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、ワークステーション、インターネットに接続されていないサーバー、およびインターネットに接続されていないネットワークデバイスのオペレーティングシステムの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも2週間ごとに使用されます。                                                                                                                                                                                                                                  | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1808軽減されていない脆弱性のスキャン         | 最新の脆弱性データベースを備えた脆弱性スキャナーは、脆弱性スキャンアクティビティーに使用されます。                                                                                                                                                                                                                                                                                                                                            | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1816開発、テスト、本番環境 | ソフトウェアの信頼できるソースの不正な変更は防止されます。                                                                                                                                                                                                                                                                                                                                                                            | <ul><li>デフォルトブランチの保護</li></ul> |
| ISM-1875認証情報の保護                           | 認証情報がクリアに保存されているかどうかを特定するために、ネットワークは少なくとも月1回スキャンされます。                                                                                                                                                                                                                                                                                                                                                       | <ul><li>シークレット検出を実行中</li></ul> |

### IRAPシークレット {#irap-secret}

次の表に、GitLabがサポートするIRAPシークレットの要件と、その要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`irap_secret.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/irap_secret.json?ref_type=heads)を使用します。

| IRAPシークレット要件                                   | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                                 | サポートされているコントロール |
|:----------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ISM-0402 アプリケーションセキュリティテスト                     | アプリケーションは、最初のリリースおよびその後のリリースの前に、静的アプリケーションセキュリティテストと動的アプリケーションセキュリティテストを使用して、脆弱性について包括的にテストされます。                                                                                                                                                                                                                                                | <ul><li>SASTを実行中</li><li>DASTを実行中</li></ul> |
| ISM-1163継続的なモニタリング計画                       | システムには、少なくとも2週間ごとにシステムの脆弱性スキャンを実施し、デプロイ前にシステムに対して脆弱性評価と侵入テストを実施し、重大な変更のデプロイ前、およびその後少なくとも年11回、特定された脆弱性を分析して潜在的な影響を判断し、リスク、有効性、およびコストに基づいて軽減策を実施することを含む、継続的なモニタリング計画があります。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1422開発、テスト、本番環境 | ソフトウェアの信頼できるソースへの不正なアクセスは防止されます。                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>デフォルトブランチの保護</li></ul> |
| ISM-1698軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、オンラインサービスの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも毎日使用されます。                                                                                                                                                                                                                                                                                                                               | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1700軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、オフィス生産性スイート、Webブラウザーおよびそれらの拡張機能、メールクライアント、PDFソフトウェア、およびセキュリティ製品以外のアプリケーションの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも2週間ごとに使用されます。                                                                                                                                                                                               | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1701軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、インターネットに接続されたサーバーおよびインターネットに接続されたネットワークデバイスのオペレーティングシステムの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも毎日使用されます。                                                                                                                                                                                                                                                              | <ul><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1702軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、ワークステーション、インターネットに接続されていないサーバー、およびインターネットに接続されていないネットワークデバイスのオペレーティングシステムの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも2週間ごとに使用されます。                                                                                                                                                                                                                                  | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1808軽減されていない脆弱性のスキャン         | 最新の脆弱性データベースを備えた脆弱性スキャナーは、脆弱性スキャンアクティビティーに使用されます。                                                                                                                                                                                                                                                                                                                                            | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1816開発、テスト、本番環境 | ソフトウェアの信頼できるソースの不正な変更は防止されます。                                                                                                                                                                                                                                                                                                                                                                            | <ul><li>デフォルトブランチの保護</li></ul> |
| ISM-1875認証情報の保護                           | 認証情報がクリアに保存されているかどうかを特定するために、ネットワークは少なくとも月1回スキャンされます。                                                                                                                                                                                                                                                                                                                                                       | <ul><li>シークレット検出を実行中</li></ul> |

### IRAP最高機密 {#irap-top-secret}

次の表に、GitLabがサポートするIRAP最高機密の要件と、その要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`irap_top_secret.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/irap_top_secret.json?ref_type=heads)を使用します。

| IRAP最高機密要件                               | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                                 | サポートされているコントロール |
|:----------------------------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ISM-0402 アプリケーションセキュリティテスト                     | アプリケーションは、最初のリリースおよびその後のリリースの前に、静的アプリケーションセキュリティテストと動的アプリケーションセキュリティテストを使用して、脆弱性について包括的にテストされます。                                                                                                                                                                                                                                                | <ul><li>SASTを実行中</li><li>DASTを実行中</li></ul> |
| ISM-1163継続的なモニタリング計画                       | システムには、少なくとも2週間ごとにシステムの脆弱性スキャンを実施し、デプロイ前にシステムに対して脆弱性評価と侵入テストを実施し、重大な変更のデプロイ前、およびその後少なくとも年11回、特定された脆弱性を分析して潜在的な影響を判断し、リスク、有効性、およびコストに基づいて軽減策を実施することを含む、継続的なモニタリング計画があります。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1422開発、テスト、本番環境 | ソフトウェアの信頼できるソースへの不正なアクセスは防止されます。                                                                                                                                                                                                                                                                                                                                                                                  | <ul><li>デフォルトブランチの保護</li></ul> |
| ISM-1698軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、オンラインサービスの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも毎日使用されます。                                                                                                                                                                                                                                                                                                                               | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1700軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、オフィス生産性スイート、Webブラウザーおよびそれらの拡張機能、メールクライアント、PDFソフトウェア、およびセキュリティ製品以外のアプリケーションの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも2週間ごとに使用されます。                                                                                                                                                                                               | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1701軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、インターネットに接続されたサーバーおよびインターネットに接続されたネットワークデバイスのオペレーティングシステムの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも毎日使用されます。                                                                                                                                                                                                                                                              | <ul><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| ISM-1702軽減されていない脆弱性のスキャン         | 脆弱性スキャナーは、ワークステーション、インターネットに接続されていないサーバー、およびインターネットに接続されていないネットワークデバイスのオペレーティングシステムの脆弱性に対する不足しているパッチまたは更新を特定するために、少なくとも2週間ごとに使用されます。                                                                                                                                                                                                                                  | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1808軽減されていない脆弱性のスキャン         | 最新の脆弱性データベースを備えた脆弱性スキャナーは、脆弱性スキャンアクティビティーに使用されます。                                                                                                                                                                                                                                                                                                                                            | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ISM-1816開発、テスト、本番環境 | ソフトウェアの信頼できるソースの不正な変更は防止されます。                                                                                                                                                                                                                                                                                                                                                                            | <ul><li>デフォルトブランチの保護</li></ul> |
| ISM-1875認証情報の保護                           | 認証情報がクリアに保存されているかどうかを特定するために、ネットワークは少なくとも月1回スキャンされます。                                                                                                                                                                                                                                                                                                                                                       | <ul><li>シークレット検出を実行中</li></ul> |

## ISMAPコンプライアンス要件 {#ismap-compliance-requirements}

情報システムセキュリティ管理および評価プログラム（ISMAP）は、政府のクラウドサービスの調達のセキュリティレベルを確保することを目的としており、政府のセキュリティ要件を事前に満たすクラウドサービスを評価および登録することにより、クラウドサービスの円滑な導入に貢献します。

次の表に、GitLabがサポートするISMAPの要件と、その要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`ismap.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/ismap.json?ref_type=heads)を使用します。

| ISMAP要件                              | 説明                                                                                                                                                                                                                                        | サポートされているコントロール |
|:-----------------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 6.1.2職務分掌                    | 組織の資産の不正または意図しない変更または誤用が発生する機会を減らすために、競合する職務と責任領域を分離する必要があります。                                                                 | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| 9.3.1秘密認証情報の使用 | ユーザーは、秘密認証情報の使用において、組織のプラクティスに従う必要があります。                                                                                                                                   | <ul><li>シークレット検出を実行中</li></ul> |
| 9.4.5プログラムソースコードへのアクセス制御    | プログラムソースコードへのアクセスは制限する必要があります。                                                                                                                                                                                                | <ul><li>デフォルトブランチの保護</li></ul> |
| 12.1.2変更管理                       | 情報セキュリティに影響を与える組織、ビジネスプロセス、情報処理施設、およびシステムへの変更は、制御する必要があります。                                                                                              | <ul><li>デフォルトブランチの保護</li></ul> |
| 12.6.1技術的な脆弱性の管理 | 使用されている情報システムの技術的な脆弱性に関する情報をタイムリーに入手し、そのような脆弱性に対する組織のエクスポージャーを評価し、関連するリスクに対処するための適切な措置を講じる必要があります。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| 14.2.1安全な開発ポリシー               | ソフトウェアとシステムの開発に関するルールを確立し、組織内の開発に適用する必要があります。                                                                                                                       | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li><li>シークレット検出を実行中</li></ul> |
| 14.2.8システムセキュリティテスト                 | 開発中にセキュリティ機能のテストを実施する必要があります。                                                                                                                                                                        | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li><li>シークレット検出を実行中</li></ul> |
| 18.1.2知的財産権            | 知的財産権およびプロプライエタリソフトウェア製品の使用に関連する、法律、規制、および契約上の要件のコンプライアンスを保証するために、適切な手順を実装する必要があります。                                      | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |

## ISO 27001コンプライアンス要件 {#iso-27001-compliance-requirements}

ISO 27001は、情報セキュリティ管理システム（ISMS）を実装および管理するためのフレームワークを提供する、国際的に認められた規格です。

次の表に、GitLabがサポートするISO 27001の要件と、その要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`iso_27001:2022.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/iso_27001:2022.json?ref_type=heads)を使用します。

| ISO 27001要件                               | 説明                                                                                                                                                                                                  | サポートされているコントロール |
|:----------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 5.3職務分掌                           | 競合する職務と競合する責任領域は、分離する必要があります。                                                                                                                              | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| 5.17認証情報                     | 認証情報の割り当てと管理は、認証情報の適切な取り扱いについて担当者に助言することを含め、管理プロセスによって制御する必要があります。                | <ul><li>シークレット検出を実行中</li></ul> |
| 5.18アクセス権                                  | 情報およびその他の関連資産へのアクセス権は、アクセス制御に関する組織のトピック固有のポリシーおよびルールに従って、プロビジョニング、レビュー、変更、および削除を行う必要があります。  | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| 5.32知的財産権                   | 組織は、知的財産権を保護するための適切な手順を実装する必要があります。                                                                                                            | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |
| 8.4ソースコードへのアクセス                           | ソースコード、開発ツール、およびソフトウェアライブラリへの読み取りおよび書き込みアクセスは、適切に管理する必要があります。                                                                                               | <ul><li>デフォルトブランチの保護</li></ul> |
| 8.8技術的な脆弱性の管理         | 使用中の情報システムの技術的な脆弱性に関する情報を入手し、そのような脆弱性に対する組織のエクスポージャーを評価し、適切な措置を講じる必要があります。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| 8.28安全なコード作成                                  | 安全なコード作成の原則は、に適用されるものとします。                                                                                                                                           | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li><li>シークレット検出を実行中</li></ul> |
| 8.29開発および受け入れにおけるセキュリティテスト | ソフトウェア開発ライフサイクルにおいて、セキュリティテストプロセスを定義し、実装するものとします。                                                                                                                    | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li><li>シークレット検出を実行中</li></ul> |
| 8.32変更管理                              | 情報処理施設および情報システムへの変更には、変更管理手順を適用するものとします。                                                                                       | <ul><li>デフォルトブランチの保護</li></ul> |

## NIS 2コンプライアンス要件 {#nis-2-compliance-requirements}

次の表に、NIS 2に関してGitLabがサポートする要件と、その要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`nis_2.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nis_2.json?ref_type=heads)を使用します。

| NIS 2の要件                                                   | 説明                                                                                                                                                                                                                                                                                                               | サポートされているコントロール |
|:--------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 第11条CSIRTの要件、技術的能力およびタスク | 3\.CSIRTは、次のタスクを実行するものとします。(a) 国内レベルでのサイバー脅威、脆弱性、およびインシデントのモニタリングと分析、および要請に応じて、ネットワークおよび情報システムのリアルタイムまたはニアリアルタイムのモニタリングに関する重要なエンティティおよび関係するエンティティへの支援の提供。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| 第21条サイバーセキュリティリスク評価対策                   | インシデントからシステムを保護するための全ハザード型アプローチに基づくサイバーセキュリティ対策を実装します。これには、直接のサプライヤーおよびサービスプロバイダー全体でのサプライチェーンセキュリティ、ならびにネットワーク/情報システムの取得、開発、メンテナンス、および脆弱性処理が含まれます。                           | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |

## NISTコンプライアンス要件 {#nist-compliance-requirements}

米国立標準技術研究所(NIST)情報技術研究所（ITL）は、情報システムの標準、測定、およびテストを提供し、相互運用性、セキュリティ、ユーザービリティ、および信頼性に重点を置いています。これらのコンプライアンス標準には、次のようなさまざまな分野にわたるセキュリティとプライバシーのコントロールの実装が含まれます:

- リスク評価
- 識別と認証
- インシデント対応
- システムと通信の保護

コントロールは、NIST 800-53、NIST 800-171、NIST SP 800-218、およびNIST CSF 2.0コンプライアンス標準で利用できます。

### NIST 800-53コンプライアンス要件 {#nist-800-53-compliance-requirements}

次の表に、NIST 800-53 Revision 5に関してGitLabがサポートする要件と、その要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`nist_800-53_r5`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nist_800-53_r5.json?ref_type=heads)を使用します。

| NIST 800-53の要件                                                    | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                       | サポートされているコントロール |
|:---------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| AC-3(2): 二重認可                                                | 組織定義の特権コマンドやその他の組織定義のアクションに対して、二重認可を適用します。                                                                                                                                                                                                                                                                                                                                | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| AC-5: 職務分離                                                 | 個人間の職務を分離して、共謀のない悪意のある活動を防ぎます。職務分離をドキュメント化します。職務分離をサポートするために、システムアクセス制御を定義します。                                                                                                                                                                                                                                                          | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| AU-9(5): 二重認可                                                | 組織定義の監査情報の削除または変更に対して、二重認可を適用します。                                                                                                                                                                                                                                                                                                                                            | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-3: 設定変更コントロール                                         | 設定制御された変更のタイプを決定します。セキュリティ/プライバシーへの影響分析で変更をレビューおよび承認します。決定をドキュメント化します。承認された変更を実装します。レコードを保持します。変更に関連するアクティビティーをモニタリングします。指定された要素を通じて変更管理の監視を調整します。                                                                                                                                           | <ul><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-3(1): 変更の自動ドキュメント化、通知、および禁止 | 自動化されたメカニズムを使用して、システムに対する提案された変更をドキュメント化します。組織で定義された承認権限者に通知します。組織で定義された期間までに受信されなかった変更承認を強調表示します。指定された承認を受信するまで、システムへの変更を禁止します。システムへのすべての変更をドキュメント化します。                                                                                                                | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-5: 変更のアクセス制御                                       | システムへの変更に関連する物理的および論理的なアクセス制御を定義、ドキュメント化、承認、および実施します。                                                                                                                                                                                                                                                                                                                            | <ul><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-5(4): 二重認可                                                | 組織定義のシステムコンポーネントおよびシステムレベルの情報への変更の実装に対して、二重認可を適用します。                                                                                                                                                                                                                                                                                                                       | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-6: 設定                                               | システムコンポーネントの安全な設定を確立およびドキュメント化します。これらの設定を実装します。運用要件に基づいて逸脱を特定、ドキュメント化、および承認します。組織のポリシーに従って、設定の変更をモニタリングおよび制御します。                                                                                                                                                                       | <ul><li>作成者が承認したマージリクエストは禁止されています</li></ul> |
| CM-7: 最小限の機能                                                  | 組織で定義されたミッションに不可欠な機能のみを提供するようにシステムを設定します。組織で定義された禁止または制限された機能、システムポート、プロトコル、ソフトウェア、および/またはサービスである、次の機能、ポート、プロトコル、ソフトウェア、および/またはサービスの使用を禁止または制限します。                                                                                                                                  | <ul><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CM-9(1): 責任の割り当て                                      | システム開発に直接関与していない組織の担当者に、構成管理プロセスの開発の責任を割り当てます。                                                                                                                                                                                                                                                                                       | <ul><li>デフォルトブランチの保護</li></ul> |
| CM-10: ソフトウェアの使用制限                                         | 契約合意および著作権法に従ってソフトウェアおよび関連ドキュメントを使用します。数量ライセンスによって保護されているソフトウェアおよび関連ドキュメントの使用状況を追跡して、コピーと配布を制御します。ピアツーピアのファイル共有テクノロジーの使用を制御およびドキュメント化して、この機能が著作権で保護された作品の不正な配布、表示、パフォーマンス、または複製に使用されないようにします。 | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |
| CP-9(7): 二重認可                                                | 組織定義のバックアップ情報の削除または破棄に対して、二重認可を適用します。                                                                                                                                                                                                                                                                                                                                            | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| IA-2(10): シングルサインオン（SSO）                                                   | 組織定義のシステムアカウントおよびサービスに対して、シングルサインオン機能を提供します。                                                                                                                                                                                                                                                                                                                                                        | <ul><li>認証SSOが有効</li></ul> |
| IA-2(12): PIV認証情報の受け入れ                                    | Personal Identity Verification（PIV）認証情報を受け入れて電子的に検証します。                                                                                                                                                                                                                                                                                                                                                                | <ul><li>認証SSOが有効</li></ul> |
| IA-5(7): 埋め込み非暗号化静的認証情報                     | 暗号化されていない静的な認証情報が、アプリケーションまたはその他の形式の静的ストレージに埋め込まれていないことを確認します。                                                                                                                                                                                                                                                                                                                                  | <ul><li>シークレット検出を実行中</li></ul> |
| IA-5(9): フェデレーションされた認証情報管理                                   | 組織定義の外部組織を使用して、認証情報をフェデレーションします。                                                                                                                                                                                                                                                                                                                                                                          | <ul><li>認証SSOが有効</li></ul> |
| IA-8(1): 他の機関からのPIV認証情報の受け入れ                 | 他の連邦政府機関からのPersonal Identity Verification（PIV）認証情報を受け入れて電子的に検証します。                                                                                                                                                                                                                                                                                                                                    | <ul><li>認証SSOが有効</li></ul> |
| IA-8(5): PIV-I認証情報の受け入れ                                   | 個人アイデンティティ管理検証-I（PIV-I）認証情報を受け入れて検証します。                                                                                                                                                                                                                                                                                                                                                                           | <ul><li>認証SSOが有効</li></ul> |
| RA-5: 脆弱性のモニタリングとスキャン                                | システムとホストされているアプリケーションの脆弱性をスキャンします。脆弱性スキャンツールと手法を使用します。脆弱性スキャンのレポートと結果を分析します。正当な脆弱性を修正します。脆弱性情報を共有します。                                                                                                                                                                                                    | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| SA-11(1): 静的コード解析                                             | システム、システムコンポーネント、またはシステムサービスのデベロッパーに対し、一般的な欠陥を特定し、分析結果をドキュメント化するために、静的コード解析ツールを使用することを要求します。                                                                                                                                                                                                                                                                  | <ul><li>SASTを実行中</li></ul> |
| SA-11(8): 動的コード解析                                            | システム、システムコンポーネント、またはシステムサービスのデベロッパーに対し、一般的な欠陥を特定し、分析結果をドキュメント化するために、動的コード解析ツールを使用することを要求します。                                                                                                                                                                                                                                                                 | <ul><li>DASTを実行中</li></ul> |

### NIST 800-171コンプライアンス要件 {#nist-800-171-compliance-requirements}

次の表に、NIST 800-171リビジョン3 CMMCに関してGitLabがサポートする要件と、その要件のアクセス制御を示します。この標準のコンプライアンスフレームワークを作成するには、[`nist_800-171_r3_cmmc.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nist_800-171_r3_cmmc.json?ref_type=heads)を使用します。

| NIST 800-171要件                       | 説明                                                                                                                                                                                                                                                                                                                             | サポートされているコントロール |
|:-----------------------------------------------|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 03.01.04 職務分離                  | a）職務分離を必要とする個人の職務を特定します。b）職務分離をサポートするために、システムアクセス制御の認可を定義します。                                                                                                                                                                                                     | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| 03.04.04影響分析                       | a）変更を実装する前に、システムへの変更を分析して、潜在的なセキュリティイベントへの影響を特定します。b）システムの変更が実装された後も、システムのセキュリティ要件が引き続き満たされていることを確認します。                                                                                               | <ul><li>デフォルトブランチの保護</li></ul> |
| 03.04.05変更のアクセス制御        | a）システムへの変更に関連する物理的および論理的なアクセス制御を定義、ドキュメント化、承認、および実施します。                                                                                                                                                                                                               | <ul><li>デフォルトブランチの保護</li></ul> |
| 03.04.10システムコンポーネントインベントリ            | a）システムコンポーネントのインベントリを開発およびドキュメント化します。b）システムコンポーネントのインベントリをレビューおよび更新します（組織が定義した頻度）。c）インストール、削除、およびシステムアップデートの一部として、システムコンポーネントのインベントリを更新します。                                                                                       | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |
| 03.05.07パスワード管理                   | <!-- List intentionally starts at b) --> b）ユーザーがパスワードを作成または更新するときに、一般的に使用されるパスワード、予測されるパスワード、または侵害されたパスワードのリストにパスワードが見つからないことを確認します。c）パスワードは暗号で保護されたチャンネル上でのみ送信します。d）パスワードを暗号で保護された形式で保存します。                 | <ul><li>シークレット検出を実行中</li></ul> |
| 03.11.02脆弱性のモニタリングとスキャン | a）システムに対する脆弱性を（組織が定義した頻度で）、およびシステムに影響を与える新しい脆弱性が特定された場合に、モニタリングおよびスキャンします。c）スキャンするシステムの脆弱性を（組織が定義した頻度で）、および新しい脆弱性が特定およびレポートされた場合に更新します。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |

### NIST CSF 2.0コンプライアンス要件 {#nist-csf-20-compliance-requirements}

次の表に、NIST CSFに関してGitLabがサポートする要件と、その要件のアクセス制御を示します。この標準のコンプライアンスフレームワークを作成するには、[`nist_csf_2.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nist_csf_2.json?ref_type=heads)を使用します。

| NIST CSF 2.0要件                                                                                                                                                                                                                            | 説明                                                                                                                                                                                | サポートされているコントロール |
|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| ID.RA-01 - アイデンティティ - リスク評価: 組織、資産、および個人に対するサイバーセキュリティのリスク評価は、組織によって理解されています。                                                                                                       | 資産の脆弱性が特定、検証、記録されています。                                                                                                                         | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| ID.RA-07 - アイデンティティ - リスク評価: 組織、資産、および個人に対するサイバーセキュリティのリスク評価は、組織によって理解されています。                                                                                                       | 変更と例外は管理、リスク評価の影響について評価、記録、追跡されます。                                                                                                       | <ul><li>デフォルトブランチの保護</li></ul> |
| PR.AA-05 - 保護 - アイデンティティ管理、認証、およびアクセス制御 - 物理的および論理的な資産へのアクセスは、認可されたユーザー、サービス、およびハードウェアに限定され、認可されていないアクセスのリスクに応じて管理されます。 | アクセス許可、エンタイトルメント、および認可は、ポリシーで定義、管理、適用、およびレビューされ、最小特権と職務分掌の原則が組み込まれています。 | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| PR.PS-06 - 保護 - プラットフォームセキュリティ - リスク戦略に沿ったハードウェア、ソフトウェア、およびサービスの管理。                                                                                                                                 | 安全なソフトウェア開発プラクティスが統合され、そのパフォーマンスがソフトウェア開発ライフサイクル全体でモニタリングされます。                                                    | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li><li>シークレット検出を実行中</li></ul> |

### NIST SP 800-218コンプライアンス要件 {#nist-sp-800-218-compliance-requirements}

次の表に、NIST SP 800-218に関してGitLabがサポートする要件と、その要件のアクセス制御を示します。この標準のコンプライアンスフレームワークを作成するには、[`nist_800-218_v1-1.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/nist_800-218_v1-1.json?ref_type=heads)を使用します。

| NIST SP 800-218要件                                                                                                 | 説明                                                                                                                                                                                                                                                                                                                                                                                                                      | サポートされているコントロール |
|:----------------------------------------------------------------------------------------------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| PO.1.1ソフトウェア開発のセキュリティ要件を定義する                                                                | PO.1.1: 組織のソフトウェア開発インフラストラクチャおよびプロセスのすべてのセキュリティ要件を特定して文書化し、それらの要件を長期にわたって維持します。                                                                                                                                                                                                                                                      | <ul><li>デフォルトブランチの保護</li></ul> |
| PW.4機能を複製する代わりに、既存の安全なソフトウェアを再利用する                               | PW.4.1: 組織のソフトウェアで使用するために、適切に保護されたソフトウェアコンポーネント（ソフトウェアライブラリ、モジュール、ミドルウェア、フレームワークなど）を商用、オープンソース、およびその他のサードパーティデベロッパーから取得して維持します。PW.4.4: 取得した商用、オープンソース、およびその他すべてのサードパーティソフトウェアコンポーネントが、組織によって定義された要件をライフサイクル全体にわたって遵守していることを確認します。 | <ul><li>ライセンスコンプライアンスを実行中</li><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| PW.5.1安全なコードレビュープラクティスを遵守してソースコードレビューを作成する                                                            | PW.5.1: 組織の要件を満たすために、開発言語と環境に適したすべての安全なコーディングプラクティスに従ってください。                                                                                                                                                                                                                                                                            | <ul><li>コード品質の実行</li></ul> |
| PW.7脆弱性を特定し、セキュリティ要件へのコンプライアンスを検証するために、人間が判読できるコードレビューをレビューおよび／または分析する | PW.7.1: 組織のニーズに応じて、コードレビュー（手動検査）および／またはコードレビュー分析（ツールベースのスキャン）を実装します。これらのレビューを安全なコーディング標準に基づいて実行し、開発ワークフローシステムで検出されたすべてのイシューを追跡します。                                                                                                                                                                       | <ul><li>SASTを実行中</li><li>DASTを実行中</li><li>シークレット検出を実行中</li></ul> |
| PW.8脆弱性を特定し、セキュリティ要件へのコンプライアンスを検証するために、実行可能コードレビューをテストする                      | PW.8.2: テストの範囲を設定し、テストを設計し、テストを実行し、開発チームのワークフローまたはイシュートラッキングシステムで検出されたすべてのイシューと推奨される修正を記録およびトリアージするなど、結果を文書化します。                                                                                                                                                                                     | <ul><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| RV.1継続的に脆弱性を特定および確認する                                                               | RV.1.1: ソフトウェアの取得者、ユーザー、および公開ソースから、ソフトウェアとソフトウェアが使用するサードパーティコンポーネントの潜在的な脆弱性に関する情報を収集し、信頼できるすべてのレポートを調査します。                                                                                                                                                                                                              | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |

## PCI DSS v4.0.1コンプライアンス要件 {#pci-dss-v401-compliance-requirements}

PCI DSSは、PCI Data Security Standardです。

次の表に、PCI DSS v4.0.1に関してGitLabがサポートする要件と、その要件のアクセス制御を示します。この標準のコンプライアンスフレームワークを作成するには、[`pci_dss_v4-0-1.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/pci_dss_v4-0-1.json?ref_type=heads)を使用します。

| PCI DSS v4.0.1要件                                                                            | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | サポートされているコントロール                                                                                                                                                                                                                                                                                                  |
|:------------------------------------------------------------------------------------------------------|:---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| 6.2オーダーメイドおよびカスタムソフトウェアは安全に開発されています。                                               | 6.2.3リリース前にオーダーメイドおよびカスタムソフトウェアをレビューして、コーディングの脆弱性を特定して修正します。コードレビューが安全なコーディングガイドラインに従い、新たな脆弱性に対処していることを確認します。一般的なソフトウェア攻撃を防ぐために、ソフトウェアエンジニアリング手法を実装します。                                                                                                                                                                                                                                                                                                                                         | <ul><li>APIセキュリティを実行中</li><li>DASTを実行中</li><li>SASTを実行中</li><li>シークレット検出を実行中</li></ul>                                                                                                                                                                      |
| 6.5すべてのシステムコンポーネントへの変更は安全に管理されます。                                            | 6.5.1確立された手順に従ってシステムコンポーネントへの変更を実装します。これには、理由と説明の文書化、セキュリティイベントの影響分析、認可された当事者による承認、およびセキュリティイベントの影響のテストが含まれます。本番環境と本番前の環境を分離します。<br/><br/>6.5.3本番前の環境は本番環境から分離されており、その分離はアクセス制御によって適用されます。<br/><br/>6.5.4役割と機能は、レビューおよび承認された変更のみがデプロイされるように、アカウンタビリティを提供するために、本番環境と本番前の環境の間で分離されます。 | <ul><li>コードの変更にはコードオーナーが必要</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>少なくとも2件の承認</li><li>プッシュ時に承認をリセット</li><li>デフォルトブランチの保護</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| 7.2システムコンポーネントとデータへのアクセスは適切に定義および割り当てられています。                       | 7.2.5すべてのアプリケーションアカウントとシステムアカウント、および関連するアクセス権限は、次のように割り当ておよび管理されます: システムまたはアプリケーションの操作に必要な最小限の特権に基づきます。アクセスは、それらの使用を特に必要とするシステム、アプリケーション、またはプロセスに限定されます。                                                                                                                                                                                                                                                                                                             | <ul><li>CI/CDジョブトークンのスコープが有効</li><li>ユーザー定義のCI/CD変数はメンテナーに制限</li><li>プロジェクトの表示レベルは公開されていません</li><li>ビルドへのアクセス制限</li><li>リポジトリに対する厳密なアクセス許可</li></ul>                                                                                       |
| 7.3システムコンポーネントとデータへのアクセスは、アクセス制御システムを介して管理されます。                  | 7.3.1ユーザーの知る必要性に基づいてアクセスを制限し、すべてのシステムコンポーネントをカバーするアクセス制御システムが導入されています。<br/><br/>7.3.2アクセス制御システムは、ジョブの分類と機能に基づいて、個人、アプリケーション、およびシステムに割り当てられた権限を適用するように構成されています。                                                                                                                                                                                                                                                                                                   | <ul><li>CI/CDジョブトークンのスコープが有効</li><li>ユーザー定義のCI/CD変数はメンテナーに制限</li><li>プロジェクトの表示レベルは公開されていません</li><li>ビルドへのアクセス制限</li><li>リポジトリに対する厳密なアクセス許可</li></ul>                                                                                       |
| 8.3ユーザーと管理者に対する強力な認証が確立および管理されています。                    | 8.3.1ユーザーと管理者のシステムコンポーネントへのすべてのユーザーアクセスは、次の少なくとも1つの認証要素を介して認証されます: パスワードやパスフレーズなど、知っていること。トークンデバイスやスマートカードなど、持っているもの。生体認証要素など、あなた自身であるもの。                                                                                                                                                                                                                                                                                                   | <ul><li>認証SSOが有効</li><li>組織レベルでMFAが必要</li><li>コントリビューターにMFAが必要</li></ul>                                                                                                                                                                                                   |
| 8.4多要素認証（MFA）は、CDEへのアクセスを保護するために実装されています。                   | 8.4.1 MFAは、管理者権限を持つ担当者のCDEへのすべての非コンソールアクセスに対して実装されています。<br/><br/>8.4.2 MFAは、CDEへのすべての非コンソールアクセスに対して実装されています。                                                                                                                                                                                                                                                                                                                                                                                                                                | <ul><li>認証SSOが有効</li><li>組織レベルでMFAが必要</li><li>コントリビューターにMFAが必要</li></ul>                                                                                                                                                                                                   |
| 8.6アプリケーションアカウントとシステムアカウント、および関連する認証要素の使用は厳密に管理されています。 | 8.6.2インタラクティブログインに使用できるアプリケーションアカウントおよびシステムアカウントのパスワード／パスフレーズは、スクリプト、設定／プロパティファイル、またはオーダーメイドおよびカスタムのソースコードレビューにハードコードされていません。                                                                                                                                                                                                                                                                                                                                                                                                           | <ul><li>シークレット検出を実行中</li></ul>                                                                                                                                                                                                                                                                          |
| 11.3外部および内部の脆弱性は定期的に特定、優先順位付け、および対処されています。      | 11.3.1認証されたスキャン方法を使用して、内部脆弱性のスキャンを実行します。リスクの高い／重大な脆弱性に迅速に対処し、リスク評価に基づいて他の脆弱性を管理します。システムへの大幅な変更後、スキャンを実行します。<br/><br/>11.3.2資格のある担当者を介して外部脆弱性のスキャンを実行します。リスクの高い／重大な脆弱性に迅速に対処し、リスク評価に基づいて他の脆弱性を管理します。システムへの大幅な変更後、スキャンを実行します。                                                                                                                | <ul><li>コンテナスキャンを実行中</li><li>依存関係スキャンの実行</li><li>DASTを実行中</li><li>IaCスキャンの実行</li></ul>                                                                                                                                                     |

## SOC 2コンプライアンス要件 {#soc-2-compliance-requirements}

SOCとは、システムと組織の統制のことです。

次の表に、GitLabがサポートするSOC 2の要件と、その要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`soc2.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/soc2.json?ref_type=heads)を使用します。

| SOC 2の要件                                                                                                                                                                                                                                   | 説明                                                                                                                                                                                                                                                                                                                                                                                 | サポートされているコントロール |
|:----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| CC3.2 - COSO原則7: エンティティは、エンティティ全体の目的の達成に対するリスクを特定し、リスクをどのように管理すべきかを判断するための基礎としてリスクを分析します。                                                         | POF 7: システムコンポーネントの脆弱性を特定します — エンティティは、システムプロセス、インフラストラクチャ、ソフトウェア、およびその他の情報資産を含む、システムコンポーネントの脆弱性を特定します。                                                                                                                                                                                  | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| CC3.4 - COSO原則9: エンティティは、内部統制システムに大きな影響を与える可能性のある変更を特定および評価します。                                                                                                                | POF 4: システム、テクノロジー環境、および進化する脅威/脆弱性からの変更を評価します。内部統制およびセキュリティ対策状況への影響を評価して、結果として生じるリスクを特定し、対処します。                                                                                                                                                                                        | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li><li>デフォルトブランチの保護</li></ul> |
| CC5.1 - COSO原則10: エンティティは、目標の達成に対するリスクを許容可能なレベルに軽減するのに役立つ制御アクティビティーを選択および開発します。                                                                     | POF 6: 職務の分離への対応 — 管理職は、両立しない職務を分離し、そのような分離が現実的でない場合、管理職は代替制御アクティビティーを選択および開発します。                                                                                                                                                                                            | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| CC6.6 - エンティティは、システム境界外からの脅威から保護するために、論理アクセスセキュリティイベント対策を実装します。                                                                                                               | POF 2: 認証情報の保護 — 識別および認証情報は、システム境界外への送信中に保護されます。                                                                                                                                                                                                              | <ul><li>シークレット検出を実行中</li></ul> |
| CC6.8 - エンティティは、エンティティの目的を達成するために、不正または悪意のあるソフトウェアの導入を防止または検出し、それに対処するためのコントロールを実装します。                                                                                    | POF 2: ソフトウェアおよび設定パラメータへの不正な変更の検出 — 不正または悪意のあるソフトウェアを示している可能性のあるソフトウェアおよび設定パラメータへの変更を検出するためのプロセスが整備されています。                                                                                                                                                              | <ul><li>デフォルトブランチの保護</li></ul> |
| CC7.1 - 目標を達成するために、エンティティは検出およびモニタリング手順を使用して、（1）新しい脆弱性の導入につながる設定の変更、および（2）新しく発見された脆弱性に対する感受性を特定します。 | POF 5: Vulnerabilityスキャンの実施 — エンティティは、環境に重要な変更が加えられた後、定期的に、潜在的な脆弱性または設定ミスを特定するように設計されたインフラストラクチャおよびソフトウェアの脆弱性スキャンを実施します。エンティティの目標の達成をサポートするために、特定された欠陥をタイムリーに修正するための措置が講じられます。 | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li></ul> |
| CC7.2 - アノマリおよびセキュリティイベント分析のためのシステムモニタリング。                                                                                                                                                                                | POF 1: インフラストラクチャおよびソフトウェアに検出ポリシー、手順、ツールを実装して、潜在的な侵入、不正アクセス、および異常なシステムアクティビティーを特定します。インテリジェンスソースを使用して、新しい脅威と脆弱性を特定します。                                                                                                                                         | <ul><li>シークレット検出を実行中</li></ul> |
| CC8.1 - エンティティは、インフラストラクチャ、データ、ソフトウェア、および手順の変更を承認、設計、開発または取得、構成、ドキュメント化、テスト、承認、および実装して、その目的を達成します。                                              | POF 2: 設計または取得前にシステム変更を承認し、本番環境デプロイ前に変更をテストし、システム変更の正式な承認を要求し、開発および変更プロセス中に機密情報を保護するためのプロセスを実装します。                                                                                                                                  | <ul><li>SASTを実行中</li><li>DASTを実行中</li><li>シークレット検出を実行中</li><li>デフォルトブランチの保護</li><li>少なくとも2件の承認</li></ul> |

## TISAXコンプライアンス要件 {#tisax-compliance-requirements}

TISAXは、Trusted Information Security Assessment Exchangeです。

次の表に、GitLabがサポートするTISAXの要件と、その要件のコントロールを示します。この標準のコンプライアンスフレームワークを作成するには、[`tisax.json`テンプレート](https://gitlab.com/gitlab-org/software-supply-chain-security/compliance/engineering/compliance-adherence-templates/-/blob/main/tisax.json?ref_type=heads)を使用します。

| TISAXの要件                                                                                                                          | 説明                                                                                                                                                                                                                                                                                                                                                                                                                                                         | サポートされているコントロール |
|:-------------------------------------------------------------------------------------------------------------------------------------------|:--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|:-------------------|
| 1.2.2情報セキュリティイベントの責任はどの程度組織化されていますか？                                                                  | ISMSを成功させるには、組織内での明確な責任が必要です。利害の衝突（職務の分離）を避けるために、責任の適切な組織上の分離を確立する必要があります。(C、I、A)                                                                                                                                                                                                                             | <ul><li>少なくとも2件の承認</li><li>作成者が承認したマージリクエストは禁止されています</li><li>コミッターが承認したマージリクエストは禁止されています</li><li>マージリクエストの承認ルールでは編集を禁止</li></ul> |
| 1.3.4評価および承認されたソフトウェアのみが組織の情報資産の処理に使用されることをどの程度保証しますか？ | 情報の処理は、主に特定のソフトウェアを使用して行われます。ソフトウェアのセキュリティイベントに関するイシューは、処理される情報にリスクを簡単に及ぼします。したがって、ソフトウェアは適切に管理する必要があります。ソフトウェアは、インストールまたは使用前に承認されます。ソフトウェアリポジトリは、不正な操作から保護されています。ソフトウェアの承認は定期的にレビューされます。ソフトウェアバージョンとパッチレベルは既知です。                                   | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>ライセンスコンプライアンスを実行中</li></ul> |
| 5.2.1変更はどの程度管理されていますか？                                                                                                  | 目標は、組織、ビジネスプロセス、およびITシステム（変更管理）への変更の場合に情報セキュリティイベントの側面が考慮されるようにして、これらの変更が情報セキュリティイベントレベルの制御されていない低下を引き起こすのを防ぐことです。組織、ビジネスプロセス、ITシステムへの変更に関する情報セキュリティイベント要件が決定され、適用されます。正式な承認手順が確立されています。 | <ul><li>デフォルトブランチの保護</li></ul> |
| 5.2.5脆弱性はどの程度特定され、対処されていますか？                                                                         | ITシステムに影響を与える技術的な脆弱性に関する情報を収集および評価します。潜在的に影響を受けるシステムとソフトウェアを特定および評価し、攻撃者による悪用を防ぐために、リスク評価に基づいて脆弱性に対処します。                                                                                                                                                                                                                       | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li></ul> |
| 5.3.1新規またはさらに開発されたITシステムでは、情報セキュリティイベントはどの程度考慮されていますか？                                            | ITシステムのライフサイクル全体で情報セキュリティイベントを組み込みます。設計、開発、取得、およびシステム変更中にセキュリティイベント要件を決定して対処します。すべてのITシステムでセキュリティイベントに焦点を当てた承認テストを実施します。                                                                                                                                                                                                                             | <ul><li>依存関係スキャンの実行</li><li>コンテナスキャンを実行中</li><li>SASTを実行中</li><li>DASTを実行中</li><li>APIセキュリティを実行中</li><li>シークレット検出を実行中</li></ul> |
| 7.1.1規制および契約条項へのコンプライアンスはどの程度確保されていますか？                                                     | 法的、規制的、または契約上の条項への不履行は、顧客および独自の組織の情報セキュリティイベントにリスクをもたらす可能性があります。したがって、これらの条項が既知であり、遵守されていることを確認することが不可欠です。情報セキュリティイベントに関連する法的、規制的、および契約上の条項（例を参照）は、一定の間隔で決定されます。                                                                                      | <ul><li>ライセンスコンプライアンスを実行中</li></ul> |
