---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Artifactory API Key'
---

## Description

The response body contains content that matches the pattern of an Artifactory API Key was identified. An Artifactory API Key enable actions like deploying artifacts, managing repositories, configuring permissions, and retrieving artifacts from JFrog Artifactory repositories. If leaked, a malicious actor could use it to exfiltrate sensitive proprietary code, inject malicious packages into the build pipeline, or delete critical artifacts that could disrupt an organization's software delivery capabilities.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.158 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
