---
stage: Security Risk Management
group: Security Insights
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: Agentic SAST Vulnerability Resolution
description: Automatic generation and resolution of SAST vulnerabilities using GitLab Duo.
---

{{< details >}}

- Tier: Ultimate
- Add-on: GitLab Duo Core, Pro, or Enterprise
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated
- Status: Beta

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/17889) in GitLab 18.9 as a [beta](../../../policy/development_stages_support.md#beta) feature [with feature flags](../../../administration/feature_flags/_index.md) named `enable_vulnerability_resolution` and `agentic_sast_vr_ui`. Enabled by default.

{{< /history >}}

GitLab Duo automatically analyzes SAST vulnerabilities and generates merge requests with
context-aware code fixes. This agentic approach uses multi-shot reasoning to resolve vulnerabilities
with minimal human intervention, reducing remediation time and improving security outcomes.

Unlike the single-shot [vulnerability resolution](_index.md#vulnerability-resolution), agentic
vulnerability resolution uses iterative reasoning to:

- Analyze vulnerability context across the codebase.
- Generate high-quality fixes that address root causes.
- Validate fixes through automated testing.
- Provide confidence scoring for proposed solutions.

Agentic SAST vulnerability resolution can run automatically, or you can run it manually.

## Automatic resolution

When a SAST security scan completes on the main branch, GitLab Duo automatically completes the
following actions:

1. Analyzes each High and Critical severity SAST vulnerability.
1. Checks if false positive detection has run.
1. If the vulnerability is not a likely or possible false positive, GitLab Duo creates a merge request with the proposed fix.
1. Runs the pipeline to validate that the fix resolves the vulnerability.

The process runs in the background with no manual triggering required. Results appear in the
vulnerability report once processing is complete.

### Manual resolution

You can manually trigger agentic vulnerability resolution for any SAST vulnerability at any time,
regardless of severity. See [manual trigger](#manual-trigger) for instructions.

## Automatic resolution conditions

Automatic agentic vulnerability resolution runs when all of the following conditions are met:

- A SAST security scan completes successfully on the main branch.
- The scan detects high or critical severity vulnerabilities.
- False positive detection has run and determined the vulnerability is a likely or possible false positive.
- GitLab Duo features are enabled for the project.
- The vulnerability is from a [supported SAST analyzer](../sast/analyzers.md).

The analysis happens in the background and results appear in the vulnerability report after
processing is complete.

## Manual trigger

To manually run agentic vulnerability resolution for any existing SAST vulnerability:

1. On the top bar, select **Search or go to** and find your project.
1. Select **Secure** > **Vulnerability report**.
1. Select the vulnerability you want to resolve.
1. In the upper-right corner, select **AI vulnerability management** > **Resolve with AI**.

GitLab Duo analyzes the vulnerability and generates a merge request if a fix can be produced. Manual
resolution works on any SAST vulnerability regardless of severity.

## Configuration

To use agentic vulnerability resolution, you must have the following requirements configured:

- A GitLab Duo Enterprise add-on subscription.
- [A default GitLab Duo namespace set](../../profile/preferences.md#set-a-default-gitlab-duo-namespace) in your user preferences.
- GitLab 18.9 or later.
- Agentic vulnerability resolution allowed for the group and turned on for the project.

### Allow foundational flow for a group

You can allow all the projects in a group to use the foundational flow. Individual projects must still turn on the feature in their project settings.

To allow agentic vulnerability resolution for all projects in a group:

1. On the left sidebar, select **Search or go to** and find your group.
1. Select **Settings** > **GitLab Duo**.
1. Under **Allow foundational flows**, select the **Agentic SAST Vulnerability Resolution** checkbox.
1. Select **Save changes**.

### Turn on for a project

To turn on the feature for a specific project:

1. On the left sidebar, select **Search or go to** and find your project.
1. Select **Settings** > **General**.
1. Expand **GitLab Duo**.
1. Turn on the **Turn on SAST vulnerability resolution** toggle.
1. Select **Save changes**.

When you allow agentic vulnerability resolution for the group and turn it on for the project, the feature works automatically with your existing SAST scanners.

## Reviewing generated merge requests

The following occurs when GitLab Duo generates a merge request for a vulnerability:

1. The merge request is created with the proposed fix.
1. The description includes the following:
   - The vulnerability details and severity
   - Explanation of the fix approach
   - Links to relevant security resources
   - Confidence score for the proposed solution
1. The pipeline runs automatically to validate the fix.
1. Reviewers review the changes and pipeline results.
1. Users with the ability to merge the merge request do so according to your workflow.

## Troubleshooting

Agentic vulnerability resolution sometimes cannot generate a suggested fix. Common causes include:

- Insufficient context: The vulnerability occurs in complex code patterns that require additional
  context or manual intervention.
- False positive detected: The AI model assesses whether the vulnerability is valid. The model may
  decide that the vulnerability is not a true vulnerability, or isn't worth fixing.
  - If you agree that the vulnerability is a false positive or is not worth fixing, you should
    [dismiss the vulnerability](_index.md#change-the-status-of-a-vulnerability) and
    [select a matching reason](_index.md#vulnerability-dismissal-reasons).
- Temporary or unexpected error: The error message may state that `an unexpected error has
  occurred`, `the upstream AI provider request timed out`, `something went wrong`, or a similar
  cause.
  - These errors may be caused by temporary problems with the AI provider or with GitLab Duo.
  - A new request may succeed, so you can try to resolve the vulnerability again.
  - If you continue to see these errors, contact GitLab for assistance.

## Providing feedback

Agentic vulnerability resolution is a beta feature and we welcome your feedback. If you encounter
issues or have suggestions for improvement, please provide feedback in
[issue 585626](https://gitlab.com/gitlab-org/gitlab/-/issues/585626).

## Related topics

- [Vulnerability Resolution](_index.md#vulnerability-resolution)
- [SAST False Positive Detection](false_positive_detection.md)
- [Vulnerability details](_index.md)
- [Vulnerability report](../vulnerability_report/_index.md)
- [SAST](../sast/_index.md)
- [GitLab Duo](../../gitlab_duo/_index.md)
