import { useCallback } from 'react';
import '../types.js';
import { getRawSqlFn } from './sql.utils.js';

function useSqlChange({ query, onQueryChange, db }) {
  const onSqlChange = useCallback(
    (sql) => {
      const toRawSql = getRawSqlFn(db);
      const rawSql = toRawSql({
        sql,
        catalog: query.catalog,
        dataset: query.dataset,
        table: query.table,
        refId: query.refId
      });
      const newQuery = { ...query, sql, rawSql };
      onQueryChange(newQuery);
    },
    [db, onQueryChange, query]
  );
  return { onSqlChange };
}

export { useSqlChange };
//# sourceMappingURL=useSqlChange.js.map
