import { jsx } from 'react/jsx-runtime';
import { useState, useEffect } from 'react';
import { Segment as Segment$1 } from '@grafana/ui';
import '@grafana/data';
import { useDebounce } from '../../hooks/useDebounce.js';

function Segment(props) {
  const { delay, onDebounce, value, options, ...rest } = props;
  const [input, setInput] = useState(value);
  const debouncedSegment = useDebounce(input, delay);
  useEffect(() => onDebounce(debouncedSegment), [debouncedSegment]);
  useEffect(() => setInput(value), [value]);
  return /* @__PURE__ */ jsx(
    Segment$1,
    {
      options,
      onChange: (ev) => setInput(ev.value),
      value: input,
      ...rest
    }
  );
}

export { Segment };
//# sourceMappingURL=Segment.js.map
