/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import com.intellij.internal.statistic.eventLog.validator.IEventContext;
import com.intellij.internal.statistic.eventLog.validator.IEventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.DataValidationRules;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.beans.EventDataField;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventGroupRules
extends DataValidationRules
implements IEventGroupRules {
    public static final EventGroupRules EMPTY = new EventGroupRules(Collections.emptySet(), Collections.emptyMap(), EventGroupContextData.EMPTY, new ValidationSimpleRuleFactory(ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER), Collections.emptyList());
    private static final Set<String> VALIDATION_TYPES = Arrays.stream(ValidationResultType.values()).map(ValidationResultType::getDescription).collect(Collectors.toSet());
    private final FUSRule[] eventIdRules;

    private EventGroupRules(@Nullable Set<String> eventIdRules, Map<String, ? extends Set<String>> eventDataRules, @NotNull EventGroupContextData contextData, @NotNull ValidationSimpleRuleFactory factory2, @NotNull List<String> excludedFields) {
        super(factory2, eventDataRules, contextData, excludedFields);
        this.eventIdRules = factory2.getRules(eventIdRules, contextData);
    }

    @Override
    public FUSRule @NotNull [] getEventIdRules() {
        return this.eventIdRules;
    }

    @Override
    public boolean areEventIdRulesDefined() {
        return this.eventIdRules.length > 0;
    }

    @Override
    @NotNull
    public ValidationResultType validateEventId(@NotNull IEventContext context) {
        ValidationResultType prevResult = null;
        if (VALIDATION_TYPES.contains(context.getEventId())) {
            return ValidationResultType.ACCEPTED;
        }
        for (FUSRule rule : this.eventIdRules) {
            ValidationResultType resultType = rule.validate(context.getEventId(), context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    @NotNull
    public static EventGroupRules create(@NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group, @NotNull GlobalRulesHolder globalRulesHolder, @NotNull ValidationSimpleRuleFactory factory2, @NotNull List<String> excludedFields, DictionaryStorage dictionaryStorage) {
        EventGroupRemoteDescriptors.GroupRemoteRule rules = group.rules;
        return rules == null ? EMPTY : new EventGroupRules(rules.event_id, rules.getEvent_data(), new EventGroupContextData(rules.getEnums(), rules.regexps, globalRulesHolder, rules.ranges, dictionaryStorage), factory2, excludedFields);
    }

    @Override
    @NotNull
    public EventDataField validateEventData(@NotNull String key, @Nullable Object data, @NotNull IEventContext context) {
        return super.validateEventData(key, data, context);
    }
}

