/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import com.android.tools.smali.util.IteratorUtils;
import com.android.tools.smali.util.StringWrapper;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class WrappedIndentingWriter
extends FilterWriter {
    private final int maxIndent;
    private final int maxWidth;
    private int currentIndent = 0;
    private final StringBuilder line = new StringBuilder();

    public WrappedIndentingWriter(Writer out, int maxIndent, int maxWidth) {
        super(out);
        this.maxIndent = maxIndent;
        this.maxWidth = maxWidth;
    }

    private void writeIndent() throws IOException {
        for (int i15 = 0; i15 < this.getIndent(); ++i15) {
            this.write(32);
        }
    }

    private int getIndent() {
        if (this.currentIndent < 0) {
            return 0;
        }
        if (this.currentIndent > this.maxIndent) {
            return this.maxIndent;
        }
        return this.currentIndent;
    }

    public void indent(int indent) {
        this.currentIndent += indent;
    }

    public void deindent(int indent) {
        this.currentIndent -= indent;
    }

    private void wrapLine() throws IOException {
        List<String> wrapped = IteratorUtils.toList(StringWrapper.wrapStringOnBreaks(this.line.toString(), this.maxWidth));
        this.out.write(wrapped.get(0), 0, wrapped.get(0).length());
        this.out.write(10);
        this.line.replace(0, this.line.length(), "");
        this.writeIndent();
        for (int i15 = 1; i15 < wrapped.size(); ++i15) {
            if (i15 > 1) {
                this.write(10);
            }
            this.write(wrapped.get(i15));
        }
    }

    @Override
    public void write(int c15) throws IOException {
        if (c15 == 10) {
            this.out.write(this.line.toString());
            this.out.write(c15);
            this.line.replace(0, this.line.length(), "");
            this.writeIndent();
        } else {
            this.line.append((char)c15);
            if (this.line.length() > this.maxWidth) {
                this.wrapLine();
            }
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i15 = 0; i15 < len; ++i15) {
            this.write(cbuf[i15 + off]);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        for (int i15 = 0; i15 < len; ++i15) {
            this.write(str.charAt(i15 + off));
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.write(this.line.toString());
        this.line.replace(0, this.line.length(), "");
    }
}

