/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatLabelUI;
import com.formdev.flatlaf.ui.FlatPanelUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;

public class FlatLineBorder
extends FlatEmptyBorder {
    private final Color lineColor;
    private final float lineThickness;
    private final int arc;

    public FlatLineBorder(Insets insets, Color lineColor) {
        this(insets, lineColor, 1.0f, -1);
    }

    public FlatLineBorder(Insets insets, Color lineColor, float lineThickness, int arc) {
        super(insets);
        this.lineColor = lineColor;
        this.lineThickness = lineThickness;
        this.arc = arc;
    }

    public FlatLineBorder(Insets insets, int arc) {
        this(insets, null, 0.0f, arc);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public float getLineThickness() {
        return this.lineThickness;
    }

    public int getArc() {
        return this.arc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c15, Graphics g15, int x15, int y15, int width, int height) {
        if (c15 instanceof JComponent && ((JComponent)c15).getClientProperty("FlatLaf.internal.FlatPopupFactory.popupUsesNativeBorder") != null) {
            return;
        }
        Color lineColor = this.getLineColor();
        float lineThickness = this.getLineThickness();
        if (lineColor == null || lineThickness <= 0.0f) {
            return;
        }
        int arc = this.getArc();
        if (arc < 0) {
            LabelUI ui4;
            ComponentUI componentUI = c15 instanceof JLabel ? ((JLabel)c15).getUI() : (ui4 = c15 instanceof JPanel ? ((JPanel)c15).getUI() : null);
            if (ui4 instanceof FlatLabelUI) {
                arc = ((FlatLabelUI)ui4).arc;
            } else if (ui4 instanceof FlatPanelUI) {
                arc = ((FlatPanelUI)((Object)ui4)).arc;
            }
            if (arc < 0) {
                arc = 0;
            }
        }
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            FlatUIUtils.setRenderingHints(g25);
            FlatUIUtils.paintOutlinedComponent(g25, x15, y15, width, height, 0.0f, 0.0f, 0.0f, UIScale.scale(lineThickness), UIScale.scale(arc), null, lineColor, null);
        }
        finally {
            g25.dispose();
        }
    }
}

