/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class FlatSliderUI
extends BasicSliderUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int trackWidth;
    @FlatStylingSupport.Styleable
    protected Dimension thumbSize;
    @FlatStylingSupport.Styleable
    protected int focusWidth;
    @FlatStylingSupport.Styleable
    protected float thumbBorderWidth;
    @FlatStylingSupport.Styleable
    protected Color trackValueColor;
    @FlatStylingSupport.Styleable
    protected Color trackColor;
    @FlatStylingSupport.Styleable
    protected Color thumbColor;
    @FlatStylingSupport.Styleable
    protected Color thumbBorderColor;
    protected Color focusBaseColor;
    @FlatStylingSupport.Styleable
    protected Color focusedColor;
    @FlatStylingSupport.Styleable
    protected Color focusedThumbBorderColor;
    @FlatStylingSupport.Styleable
    protected Color hoverThumbColor;
    @FlatStylingSupport.Styleable
    protected Color pressedThumbColor;
    @FlatStylingSupport.Styleable
    protected Color disabledTrackColor;
    @FlatStylingSupport.Styleable
    protected Color disabledThumbColor;
    @FlatStylingSupport.Styleable
    protected Color disabledThumbBorderColor;
    @FlatStylingSupport.Styleable
    protected Color tickColor;
    private Color defaultBackground;
    private Color defaultForeground;
    protected boolean thumbHover;
    protected boolean thumbPressed;
    private Object[] oldRenderingHints;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatSliderUI();
    }

    public FlatSliderUI() {
        super(null);
    }

    @Override
    public void installUI(JComponent c15) {
        super.installUI(c15);
        this.installStyle();
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        LookAndFeel.installProperty(slider, "opaque", false);
        this.trackWidth = UIManager.getInt("Slider.trackWidth");
        this.thumbSize = UIManager.getDimension("Slider.thumbSize");
        if (this.thumbSize == null) {
            int thumbWidth = UIManager.getInt("Slider.thumbWidth");
            this.thumbSize = new Dimension(thumbWidth, thumbWidth);
        }
        this.focusWidth = FlatUIUtils.getUIInt("Slider.focusWidth", 4);
        this.thumbBorderWidth = FlatUIUtils.getUIFloat("Slider.thumbBorderWidth", 1.0f);
        this.trackValueColor = FlatUIUtils.getUIColor("Slider.trackValueColor", "Slider.thumbColor");
        this.trackColor = UIManager.getColor("Slider.trackColor");
        this.thumbColor = UIManager.getColor("Slider.thumbColor");
        this.thumbBorderColor = UIManager.getColor("Slider.thumbBorderColor");
        this.focusBaseColor = UIManager.getColor("Component.focusColor");
        this.focusedColor = FlatUIUtils.getUIColor("Slider.focusedColor", this.focusBaseColor);
        this.focusedThumbBorderColor = FlatUIUtils.getUIColor("Slider.focusedThumbBorderColor", "Component.focusedBorderColor");
        this.hoverThumbColor = UIManager.getColor("Slider.hoverThumbColor");
        this.pressedThumbColor = UIManager.getColor("Slider.pressedThumbColor");
        this.disabledTrackColor = UIManager.getColor("Slider.disabledTrackColor");
        this.disabledThumbColor = UIManager.getColor("Slider.disabledThumbColor");
        this.disabledThumbBorderColor = FlatUIUtils.getUIColor("Slider.disabledThumbBorderColor", "Component.disabledBorderColor");
        this.tickColor = FlatUIUtils.getUIColor("Slider.tickColor", Color.BLACK);
        this.defaultBackground = UIManager.getColor("Slider.background");
        this.defaultForeground = UIManager.getColor("Slider.foreground");
    }

    @Override
    protected void uninstallDefaults(JSlider slider) {
        super.uninstallDefaults(slider);
        this.trackValueColor = null;
        this.trackColor = null;
        this.thumbColor = null;
        this.thumbBorderColor = null;
        this.focusBaseColor = null;
        this.focusedColor = null;
        this.focusedThumbBorderColor = null;
        this.hoverThumbColor = null;
        this.pressedThumbColor = null;
        this.disabledTrackColor = null;
        this.disabledThumbColor = null;
        this.disabledThumbBorderColor = null;
        this.tickColor = null;
        this.defaultBackground = null;
        this.defaultForeground = null;
        this.oldStyleValues = null;
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new FlatTrackListener();
    }

    @Override
    protected FocusListener createFocusListener(final JSlider slider) {
        return new BasicSliderUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent e15) {
                super.focusGained(e15);
                HiDPIUtils.repaint(slider);
            }

            @Override
            public void focusLost(FocusEvent e15) {
                super.focusLost(e15);
                HiDPIUtils.repaint(slider);
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return FlatStylingSupport.createPropertyChangeListener(slider, this::installStyle, super.createPropertyChangeListener(slider));
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.slider, "Slider"));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    protected void applyStyle(Object style) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String key, Object value) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.slider, key, value);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, key);
    }

    @Override
    public int getBaseline(JComponent c15, int width, int height) {
        if (c15 == null) {
            throw new NullPointerException();
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException();
        }
        if (this.slider.getOrientation() == 1) {
            return -1;
        }
        Font font = UIManager.getFont("defaultFont");
        if (font == null) {
            font = this.slider.getFont();
        }
        FontMetrics fm4 = this.slider.getFontMetrics(font);
        Insets insets = this.slider.getInsets();
        int thumbHeight = this.getThumbSize().height;
        int contentHeight = height - insets.top - insets.bottom - this.focusInsets.top - this.focusInsets.bottom;
        int centerSpacing = thumbHeight + (this.slider.getPaintTicks() ? this.getTickLength() : 0) + (this.slider.getPaintLabels() ? this.getHeightOfTallestLabel() : 0);
        int trackY = insets.top + this.focusInsets.top + (contentHeight - centerSpacing - 1) / 2;
        int trackHeight = thumbHeight;
        return trackY + Math.round((float)(trackHeight - fm4.getHeight()) / 2.0f) + fm4.getAscent() - 1;
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return UIScale.scale(super.getPreferredHorizontalSize());
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return UIScale.scale(super.getPreferredVerticalSize());
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return UIScale.scale(super.getMinimumHorizontalSize());
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return UIScale.scale(super.getMinimumVerticalSize());
    }

    @Override
    protected int getTickLength() {
        return UIScale.scale(super.getTickLength());
    }

    @Override
    protected Dimension getThumbSize() {
        return FlatSliderUI.calcThumbSize(this.slider, this.thumbSize, this.focusWidth);
    }

    public static Dimension calcThumbSize(JSlider slider, Dimension thumbSize, int focusWidth) {
        int fw4 = UIScale.scale(focusWidth);
        int w15 = UIScale.scale(thumbSize.width) + fw4 + fw4;
        int h15 = UIScale.scale(thumbSize.height) + fw4 + fw4;
        return slider.getOrientation() == 0 ? new Dimension(w15, h15) : new Dimension(h15, w15);
    }

    @Override
    public void paint(Graphics g15, JComponent c15) {
        this.oldRenderingHints = FlatUIUtils.setRenderingHints(g15);
        super.paint(g15, c15);
        FlatUIUtils.resetRenderingHints(g15, this.oldRenderingHints);
        this.oldRenderingHints = null;
    }

    @Override
    public void paintLabels(Graphics g15) {
        FlatUIUtils.runWithoutRenderingHints(g15, this.oldRenderingHints, () -> super.paintLabels(g15));
    }

    @Override
    public void paintFocus(Graphics g15) {
    }

    @Override
    public void paintTrack(Graphics g15) {
        RoundRectangle2D.Float track;
        float tw4;
        boolean enabled = this.slider.isEnabled();
        float arc = tw4 = UIScale.scale((float)this.trackWidth);
        RoundRectangle2D.Float coloredTrack = null;
        if (this.slider.getOrientation() == 0) {
            float y15 = (float)this.trackRect.y + ((float)this.trackRect.height - tw4) / 2.0f;
            if (enabled && this.isRoundThumb()) {
                if (this.slider.getComponentOrientation().isLeftToRight()) {
                    int cw4 = this.thumbRect.x + this.thumbRect.width / 2 - this.trackRect.x;
                    coloredTrack = new RoundRectangle2D.Float(this.trackRect.x, y15, cw4, tw4, arc, arc);
                    track = new RoundRectangle2D.Float(this.trackRect.x + cw4, y15, this.trackRect.width - cw4, tw4, arc, arc);
                } else {
                    int cw5 = this.trackRect.x + this.trackRect.width - this.thumbRect.x - this.thumbRect.width / 2;
                    coloredTrack = new RoundRectangle2D.Float(this.trackRect.x + this.trackRect.width - cw5, y15, cw5, tw4, arc, arc);
                    track = new RoundRectangle2D.Float(this.trackRect.x, y15, this.trackRect.width - cw5, tw4, arc, arc);
                }
            } else {
                track = new RoundRectangle2D.Float(this.trackRect.x, y15, this.trackRect.width, tw4, arc, arc);
            }
        } else {
            float x15 = (float)this.trackRect.x + ((float)this.trackRect.width - tw4) / 2.0f;
            if (enabled && this.isRoundThumb()) {
                int ch4 = this.thumbRect.y + this.thumbRect.height / 2 - this.trackRect.y;
                track = new RoundRectangle2D.Float(x15, this.trackRect.y, tw4, ch4, arc, arc);
                coloredTrack = new RoundRectangle2D.Float(x15, this.trackRect.y + ch4, tw4, this.trackRect.height - ch4, arc, arc);
            } else {
                track = new RoundRectangle2D.Float(x15, this.trackRect.y, tw4, this.trackRect.height, arc, arc);
            }
        }
        if (coloredTrack != null) {
            if (this.slider.getInverted()) {
                RoundRectangle2D.Float temp = track;
                track = coloredTrack;
                coloredTrack = temp;
            }
            g15.setColor(this.getTrackValueColor());
            ((Graphics2D)g15).fill(coloredTrack);
        }
        g15.setColor(enabled ? this.getTrackColor() : this.disabledTrackColor);
        ((Graphics2D)g15).fill(track);
    }

    @Override
    public void paintTicks(Graphics g15) {
        super.paintTicks(new Graphics2DProxy((Graphics2D)g15){

            @Override
            public void setColor(Color c15) {
                super.setColor(FlatSliderUI.this.tickColor);
            }
        });
    }

    @Override
    public void paintThumb(Graphics g15) {
        Color thumbColor = this.getThumbColor();
        Color color = FlatSliderUI.stateColor(this.slider, this.thumbHover, this.thumbPressed, thumbColor, this.disabledThumbColor, null, this.hoverThumbColor, this.pressedThumbColor);
        color = FlatUIUtils.deriveColor(color, thumbColor);
        Color foreground = this.slider.getForeground();
        Color borderColor = this.thumbBorderColor != null && foreground == this.defaultForeground ? FlatSliderUI.stateColor(this.slider, false, false, this.thumbBorderColor, this.disabledThumbBorderColor, this.focusedThumbBorderColor, null, null) : null;
        Color focusedColor = FlatUIUtils.deriveColor(this.focusedColor, foreground != this.defaultForeground ? foreground : this.focusBaseColor);
        FlatSliderUI.paintThumb(g15, this.slider, this.thumbRect, this.isRoundThumb(), color, borderColor, focusedColor, this.thumbBorderWidth, this.focusWidth);
    }

    public static void paintThumb(Graphics g15, JSlider slider, Rectangle thumbRect, boolean roundThumb, Color thumbColor, Color thumbBorderColor, Color focusedColor, float thumbBorderWidth, int focusWidth) {
        double systemScaleFactor = UIScale.getSystemScaleFactor((Graphics2D)g15);
        if (systemScaleFactor != (double)((int)systemScaleFactor)) {
            HiDPIUtils.paintAtScale1x((Graphics2D)g15, thumbRect.x, thumbRect.y, thumbRect.width, thumbRect.height, (g2d, x25, y25, width2, height2, scaleFactor) -> FlatSliderUI.paintThumbImpl(g15, slider, x25, y25, width2, height2, roundThumb, thumbColor, thumbBorderColor, focusedColor, (float)((double)thumbBorderWidth * scaleFactor), (float)((double)focusWidth * scaleFactor)));
            return;
        }
        FlatSliderUI.paintThumbImpl(g15, slider, thumbRect.x, thumbRect.y, thumbRect.width, thumbRect.height, roundThumb, thumbColor, thumbBorderColor, focusedColor, thumbBorderWidth, focusWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintThumbImpl(Graphics g15, JSlider slider, int x15, int y15, int width, int height, boolean roundThumb, Color thumbColor, Color thumbBorderColor, Color focusedColor, float thumbBorderWidth, float focusWidth) {
        int fw4 = Math.round(UIScale.scale(focusWidth));
        int tx4 = x15 + fw4;
        int ty4 = y15 + fw4;
        int tw4 = width - fw4 - fw4;
        int th4 = height - fw4 - fw4;
        boolean focused = FlatUIUtils.isPermanentFocusOwner(slider);
        if (roundThumb) {
            if (focused) {
                g15.setColor(focusedColor);
                ((Graphics2D)g15).fill(FlatSliderUI.createRoundThumbShape(x15, y15, width, height));
            }
            if (thumbBorderColor != null) {
                g15.setColor(thumbBorderColor);
                ((Graphics2D)g15).fill(FlatSliderUI.createRoundThumbShape(tx4, ty4, tw4, th4));
                float lw4 = UIScale.scale(thumbBorderWidth);
                g15.setColor(thumbColor);
                ((Graphics2D)g15).fill(FlatSliderUI.createRoundThumbShape((float)tx4 + lw4, (float)ty4 + lw4, (float)tw4 - lw4 - lw4, (float)th4 - lw4 - lw4));
            } else {
                g15.setColor(thumbColor);
                ((Graphics2D)g15).fill(FlatSliderUI.createRoundThumbShape(tx4, ty4, tw4, th4));
            }
        } else {
            Graphics2D g25 = (Graphics2D)g15.create();
            try {
                g25.translate(x15, y15);
                if (slider.getOrientation() == 1) {
                    if (slider.getComponentOrientation().isLeftToRight()) {
                        g25.translate(0, height);
                        g25.rotate(Math.toRadians(270.0));
                    } else {
                        g25.translate(width, 0);
                        g25.rotate(Math.toRadians(90.0));
                    }
                    int temp = tw4;
                    tw4 = th4;
                    th4 = temp;
                }
                if (focused) {
                    g25.setColor(focusedColor);
                    g25.fill(FlatSliderUI.createDirectionalThumbShape(0.0f, 0.0f, tw4 + fw4 + fw4, (float)(th4 + fw4 + fw4) + (float)fw4 * 0.4142f, fw4));
                }
                if (thumbBorderColor != null) {
                    g25.setColor(thumbBorderColor);
                    g25.fill(FlatSliderUI.createDirectionalThumbShape(fw4, fw4, tw4, th4, 0.0f));
                    float lw5 = UIScale.scale(thumbBorderWidth);
                    g25.setColor(thumbColor);
                    g25.fill(FlatSliderUI.createDirectionalThumbShape((float)fw4 + lw5, (float)fw4 + lw5, (float)tw4 - lw5 - lw5, (float)th4 - lw5 - lw5 - lw5 * 0.4142f, 0.0f));
                } else {
                    g25.setColor(thumbColor);
                    g25.fill(FlatSliderUI.createDirectionalThumbShape(fw4, fw4, tw4, th4, 0.0f));
                }
            }
            finally {
                g25.dispose();
            }
        }
    }

    public static Shape createRoundThumbShape(float x15, float y15, float w15, float h15) {
        if (w15 == h15) {
            return new Ellipse2D.Float(x15, y15, w15, h15);
        }
        float arc = Math.min(w15, h15);
        return new RoundRectangle2D.Float(x15, y15, w15, h15, arc, arc);
    }

    public static Shape createDirectionalThumbShape(float x15, float y15, float w15, float h15, float arc) {
        float wh4 = w15 / 2.0f;
        Path2D.Float path = new Path2D.Float(1, 9);
        ((Path2D)path).moveTo(x15 + wh4, y15 + h15);
        ((Path2D)path).lineTo(x15, y15 + (h15 - wh4));
        ((Path2D)path).lineTo(x15, y15 + arc);
        ((Path2D)path).quadTo(x15, y15, x15 + arc, y15);
        ((Path2D)path).lineTo(x15 + (w15 - arc), y15);
        ((Path2D)path).quadTo(x15 + w15, y15, x15 + w15, y15 + arc);
        ((Path2D)path).lineTo(x15 + w15, y15 + (h15 - wh4));
        path.closePath();
        return path;
    }

    protected Color getTrackValueColor() {
        Color foreground = this.slider.getForeground();
        return foreground != this.defaultForeground ? foreground : this.trackValueColor;
    }

    protected Color getTrackColor() {
        Color backround = this.slider.getBackground();
        return backround != this.defaultBackground ? backround : this.trackColor;
    }

    protected Color getThumbColor() {
        Color foreground = this.slider.getForeground();
        return foreground != this.defaultForeground ? foreground : this.thumbColor;
    }

    public static Color stateColor(JSlider slider, boolean hover, boolean pressed, Color enabledColor, Color disabledColor, Color focusedColor, Color hoverColor, Color pressedColor) {
        if (disabledColor != null && !slider.isEnabled()) {
            return disabledColor;
        }
        if (pressedColor != null && pressed) {
            return pressedColor;
        }
        if (hoverColor != null && hover) {
            return hoverColor;
        }
        if (focusedColor != null && FlatUIUtils.isPermanentFocusOwner(slider)) {
            return focusedColor;
        }
        return enabledColor;
    }

    protected boolean isRoundThumb() {
        return !this.slider.getPaintTicks() && !this.slider.getPaintLabels();
    }

    @Override
    public void setThumbLocation(int x15, int y15) {
        Rectangle r15 = new Rectangle(this.thumbRect);
        this.thumbRect.setLocation(x15, y15);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, r15);
        if (!this.isRoundThumb()) {
            int extra = (int)Math.ceil((float)UIScale.scale(this.focusWidth) * 0.4142f);
            if (this.slider.getOrientation() == 0) {
                r15.height += extra;
            } else {
                r15.width += extra;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    r15.x -= extra;
                }
            }
        }
        HiDPIUtils.repaint(this.slider, r15);
    }

    protected class FlatTrackListener
    extends BasicSliderUI.TrackListener {
        protected FlatTrackListener() {
            super(FlatSliderUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent e15) {
            this.setThumbHover(this.isOverThumb(e15));
            super.mouseEntered(e15);
        }

        @Override
        public void mouseExited(MouseEvent e15) {
            this.setThumbHover(false);
            super.mouseExited(e15);
        }

        @Override
        public void mouseMoved(MouseEvent e15) {
            this.setThumbHover(this.isOverThumb(e15));
            super.mouseMoved(e15);
        }

        @Override
        public void mousePressed(MouseEvent e15) {
            this.setThumbPressed(this.isOverThumb(e15));
            if (!FlatSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (UIManager.getBoolean("Slider.scrollOnTrackClick")) {
                super.mousePressed(e15);
                return;
            }
            int x15 = e15.getX();
            int y15 = e15.getY();
            FlatSliderUI.this.calculateGeometry();
            if (FlatSliderUI.this.thumbRect.contains(x15, y15)) {
                super.mousePressed(e15);
                return;
            }
            if (UIManager.getBoolean("Slider.onlyLeftMouseButtonDrag") && !SwingUtilities.isLeftMouseButton(e15)) {
                return;
            }
            int tx4 = ((FlatSliderUI)FlatSliderUI.this).thumbRect.x + ((FlatSliderUI)FlatSliderUI.this).thumbRect.width / 2 - x15;
            int ty4 = ((FlatSliderUI)FlatSliderUI.this).thumbRect.y + ((FlatSliderUI)FlatSliderUI.this).thumbRect.height / 2 - y15;
            e15.translatePoint(tx4, ty4);
            super.mousePressed(e15);
            e15.translatePoint(-tx4, -ty4);
            this.mouseDragged(e15);
            this.setThumbPressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent e15) {
            this.setThumbPressed(false);
            super.mouseReleased(e15);
        }

        @Override
        public void mouseDragged(MouseEvent e15) {
            super.mouseDragged(e15);
            if (FlatSliderUI.this.isDragging() && FlatSliderUI.this.slider.getSnapToTicks() && FlatSliderUI.this.slider.isEnabled() && !UIManager.getBoolean("Slider.snapToTicksOnReleased")) {
                FlatSliderUI.this.calculateThumbLocation();
                HiDPIUtils.repaint(FlatSliderUI.this.slider);
            }
        }

        protected void setThumbHover(boolean hover) {
            if (hover != FlatSliderUI.this.thumbHover) {
                FlatSliderUI.this.thumbHover = hover;
                HiDPIUtils.repaint(FlatSliderUI.this.slider, FlatSliderUI.this.thumbRect);
            }
        }

        protected void setThumbPressed(boolean pressed) {
            if (pressed != FlatSliderUI.this.thumbPressed) {
                FlatSliderUI.this.thumbPressed = pressed;
                HiDPIUtils.repaint(FlatSliderUI.this.slider, FlatSliderUI.this.thumbRect);
            }
        }

        protected boolean isOverThumb(MouseEvent e15) {
            return e15 != null && FlatSliderUI.this.slider.isEnabled() && FlatSliderUI.this.thumbRect.contains(e15.getX(), e15.getY());
        }
    }
}

