/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatCaret;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class FlatTextFieldUI
extends BasicTextFieldUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    private Color background;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color inactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color placeholderForeground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected int iconTextGap;
    @FlatStylingSupport.Styleable
    protected Icon leadingIcon;
    @FlatStylingSupport.Styleable
    protected Icon trailingIcon;
    protected JComponent leadingComponent;
    protected JComponent trailingComponent;
    protected JComponent clearButton;
    @FlatStylingSupport.Styleable
    protected boolean showClearButton;
    private Color oldDisabledBackground;
    private Color oldInactiveBackground;
    private Insets defaultMargin;
    private FocusListener focusListener;
    private DocumentListener documentListener;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent c15) {
        return new FlatTextFieldUI();
    }

    @Override
    public void installUI(JComponent c15) {
        if (FlatUIUtils.needsLightAWTPeer(c15)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(c15));
        } else {
            this.installUIImpl(c15);
        }
    }

    private void installUIImpl(JComponent c15) {
        super.installUI(c15);
        this.leadingIcon = FlatClientProperties.clientProperty(c15, "JTextField.leadingIcon", null, Icon.class);
        this.trailingIcon = FlatClientProperties.clientProperty(c15, "JTextField.trailingIcon", null, Icon.class);
        this.installLeadingComponent();
        this.installTrailingComponent();
        this.installClearButton();
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent c15) {
        this.uninstallLeadingComponent();
        this.uninstallTrailingComponent();
        this.uninstallClearButton();
        super.uninstallUI(c15);
        this.leadingIcon = null;
        this.trailingIcon = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.background = UIManager.getColor(prefix + ".background");
        this.disabledBackground = UIManager.getColor(prefix + ".disabledBackground");
        this.inactiveBackground = UIManager.getColor(prefix + ".inactiveBackground");
        this.placeholderForeground = UIManager.getColor(prefix + ".placeholderForeground");
        this.focusedBackground = UIManager.getColor(prefix + ".focusedBackground");
        this.iconTextGap = FlatUIUtils.getUIInt(prefix + ".iconTextGap", 4);
        this.defaultMargin = UIManager.getInsets(prefix + ".margin");
        LookAndFeel.installProperty(this.getComponent(), "opaque", false);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.background = null;
        this.disabledBackground = null;
        this.inactiveBackground = null;
        this.placeholderForeground = null;
        this.focusedBackground = null;
        this.oldDisabledBackground = null;
        this.oldInactiveBackground = null;
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent(), null);
        this.getComponent().addFocusListener(this.focusListener);
        MigLayoutVisualPadding.install(this.getComponent());
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        if (this.documentListener != null) {
            this.getComponent().getDocument().removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
        MigLayoutVisualPadding.uninstall(this.getComponent());
    }

    @Override
    protected Caret createCaret() {
        return new FlatCaret(UIManager.getString("TextComponent.selectAllOnFocusPolicy"), UIManager.getBoolean("TextComponent.selectAllOnMouseClick"));
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e15) {
        String propertyName = e15.getPropertyName();
        if ("editable".equals(propertyName) || "enabled".equals(propertyName)) {
            this.updateBackground();
        } else {
            super.propertyChange(e15);
        }
        JTextComponent c15 = this.getComponent();
        switch (e15.getPropertyName()) {
            case "JTextField.placeholderText": 
            case "JComponent.roundRect": 
            case "JComponent.outline": 
            case "JTextField.padding": {
                HiDPIUtils.repaint(c15);
                break;
            }
            case "JComponent.minimumWidth": {
                c15.revalidate();
                break;
            }
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                this.installStyle();
                c15.revalidate();
                HiDPIUtils.repaint(c15);
                break;
            }
            case "JTextField.leadingIcon": {
                this.leadingIcon = e15.getNewValue() instanceof Icon ? (Icon)e15.getNewValue() : null;
                HiDPIUtils.repaint(c15);
                break;
            }
            case "JTextField.trailingIcon": {
                this.trailingIcon = e15.getNewValue() instanceof Icon ? (Icon)e15.getNewValue() : null;
                HiDPIUtils.repaint(c15);
                break;
            }
            case "JTextField.leadingComponent": {
                this.uninstallLeadingComponent();
                this.installLeadingComponent();
                c15.revalidate();
                HiDPIUtils.repaint(c15);
                break;
            }
            case "JTextField.trailingComponent": {
                this.uninstallTrailingComponent();
                this.installTrailingComponent();
                c15.revalidate();
                HiDPIUtils.repaint(c15);
                break;
            }
            case "JTextField.showClearButton": {
                this.uninstallClearButton();
                this.installClearButton();
                c15.revalidate();
                HiDPIUtils.repaint(c15);
                break;
            }
            case "enabled": 
            case "editable": {
                this.updateClearButton();
                break;
            }
            case "document": {
                if (this.documentListener == null) break;
                if (e15.getOldValue() instanceof Document) {
                    ((Document)e15.getOldValue()).removeDocumentListener(this.documentListener);
                }
                if (e15.getNewValue() instanceof Document) {
                    ((Document)e15.getNewValue()).addDocumentListener(this.documentListener);
                }
                this.updateClearButton();
            }
        }
    }

    protected void installDocumentListener() {
        if (this.documentListener != null) {
            return;
        }
        this.documentListener = new FlatDocumentListener();
        this.getComponent().getDocument().addDocumentListener(this.documentListener);
    }

    protected void documentChanged(DocumentEvent e15) {
        if (this.clearButton != null) {
            this.updateClearButton();
        }
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.getComponent(), this.getStyleType()));
        }
        catch (RuntimeException ex4) {
            LoggingFacade.INSTANCE.logSevere(null, ex4);
        }
    }

    String getStyleType() {
        return "TextField";
    }

    protected void applyStyle(Object style) {
        this.oldDisabledBackground = this.disabledBackground;
        this.oldInactiveBackground = this.inactiveBackground;
        boolean oldShowClearButton = this.showClearButton;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, style, this::applyStyleProperty);
        this.updateBackground();
        if (this.showClearButton != oldShowClearButton) {
            this.uninstallClearButton();
            this.installClearButton();
        }
    }

    protected Object applyStyleProperty(String key, Object value) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, key, value, this.getComponent(), this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent c15) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.getComponent().getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent c15, String key) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.getComponent().getBorder(), key);
    }

    private void updateBackground() {
        FlatTextFieldUI.updateBackground(this.getComponent(), this.background, this.disabledBackground, this.inactiveBackground, this.oldDisabledBackground, this.oldInactiveBackground);
    }

    static void updateBackground(JTextComponent c15, Color background, Color disabledBackground, Color inactiveBackground, Color oldDisabledBackground, Color oldInactiveBackground) {
        Color newBackground;
        Color oldBackground = c15.getBackground();
        if (!(oldBackground instanceof UIResource)) {
            return;
        }
        if (oldBackground != background && oldBackground != disabledBackground && oldBackground != inactiveBackground && oldBackground != oldDisabledBackground && oldBackground != oldInactiveBackground) {
            return;
        }
        Color color = !c15.isEnabled() ? disabledBackground : (newBackground = !c15.isEditable() ? inactiveBackground : background);
        if (newBackground != oldBackground) {
            c15.setBackground(newBackground);
        }
    }

    @Override
    protected void paintSafely(Graphics g15) {
        FlatTextFieldUI.paintBackground(g15, this.getComponent(), this.focusedBackground);
        this.paintPlaceholder(g15);
        if (this.hasLeadingIcon() || this.hasTrailingIcon()) {
            this.paintIcons(g15, new Rectangle(this.getIconsRect()));
        }
        super.paintSafely(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)g15));
    }

    @Override
    protected void paintBackground(Graphics g15) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintBackground(Graphics g15, JTextComponent c15, Color focusedBackground) {
        if (!c15.isOpaque() && FlatUIUtils.getOutsideFlatBorder(c15) == null && FlatUIUtils.hasOpaqueBeenExplicitlySet(c15)) {
            return;
        }
        float focusWidth = FlatUIUtils.getBorderFocusWidth(c15);
        float arc = FlatUIUtils.getBorderArc(c15);
        if (c15.isOpaque() && (focusWidth > 0.0f || arc > 0.0f)) {
            FlatUIUtils.paintParentBackground(g15, c15);
        }
        Graphics2D g25 = (Graphics2D)g15.create();
        try {
            FlatUIUtils.setRenderingHints(g25);
            g25.setColor(FlatTextFieldUI.getBackground(c15, focusedBackground));
            FlatUIUtils.paintComponentBackground(g25, 0, 0, c15.getWidth(), c15.getHeight(), focusWidth, arc);
        }
        finally {
            g25.dispose();
        }
    }

    static Color getBackground(JTextComponent c15, Color focusedBackground) {
        Color background = c15.getBackground();
        if (!(background instanceof UIResource)) {
            return background;
        }
        if (focusedBackground != null && FlatUIUtils.isPermanentFocusOwner(c15)) {
            return focusedBackground;
        }
        return background;
    }

    protected void paintPlaceholder(Graphics g15) {
        int halign;
        JTextComponent c15 = this.getComponent();
        if (c15.getDocument().getLength() > 0) {
            return;
        }
        Container parent = c15.getParent();
        JComponent jc5 = parent instanceof JComboBox ? (JComboBox)parent : c15;
        String placeholder = FlatClientProperties.clientProperty(jc5, "JTextField.placeholderText", null, String.class);
        if (placeholder == null) {
            return;
        }
        Rectangle r15 = this.getVisibleEditorRect();
        FontMetrics fm4 = c15.getFontMetrics(c15.getFont());
        int x15 = r15.x;
        int y15 = r15.y + fm4.getAscent() + (r15.height - fm4.getHeight()) / 2;
        String clippedPlaceholder = JavaCompatibility.getClippedString(c15, fm4, placeholder, r15.width);
        int stringWidth = fm4.stringWidth(clippedPlaceholder);
        int n15 = halign = c15 instanceof JTextField ? ((JTextField)c15).getHorizontalAlignment() : 10;
        if (halign == 10) {
            halign = this.isLeftToRight() ? 2 : 4;
        } else if (halign == 11) {
            int n16 = halign = this.isLeftToRight() ? 4 : 2;
        }
        if (halign == 4) {
            x15 += r15.width - stringWidth;
        } else if (halign == 0) {
            x15 = Math.max(0, x15 + r15.width / 2 - stringWidth / 2);
        }
        g15.setColor(this.placeholderForeground);
        FlatUIUtils.drawString(c15, g15, clippedPlaceholder, x15, y15);
    }

    protected void paintIcons(Graphics g15, Rectangle r15) {
        Icon rightIcon;
        boolean ltr = this.isLeftToRight();
        Icon leftIcon = ltr ? this.leadingIcon : this.trailingIcon;
        Icon icon = rightIcon = ltr ? this.trailingIcon : this.leadingIcon;
        if (leftIcon != null) {
            int x15 = r15.x;
            int y15 = r15.y + Math.round((float)(r15.height - leftIcon.getIconHeight()) / 2.0f);
            leftIcon.paintIcon(this.getComponent(), g15, x15, y15);
            int w15 = leftIcon.getIconWidth() + UIScale.scale(this.iconTextGap);
            r15.x += w15;
            r15.width -= w15;
        }
        if (rightIcon != null) {
            int iconWidth = rightIcon.getIconWidth();
            int x16 = r15.x + r15.width - iconWidth;
            int y16 = r15.y + Math.round((float)(r15.height - rightIcon.getIconHeight()) / 2.0f);
            rightIcon.paintIcon(this.getComponent(), g15, x16, y16);
            r15.width -= iconWidth + UIScale.scale(this.iconTextGap);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c15) {
        return this.applyMinimumWidth(c15, this.applyExtraSize(super.getPreferredSize(c15)), this.minimumWidth);
    }

    @Override
    public Dimension getMinimumSize(JComponent c15) {
        return this.applyMinimumWidth(c15, this.applyExtraSize(super.getMinimumSize(c15)), this.minimumWidth);
    }

    private Dimension applyExtraSize(Dimension size) {
        size.width += this.getLeadingIconWidth() + this.getTrailingIconWidth();
        for (JComponent comp : this.getLeadingComponents()) {
            if (comp == null || !comp.isVisible()) continue;
            size.width += comp.getPreferredSize().width;
        }
        for (JComponent comp : this.getTrailingComponents()) {
            if (comp == null || !comp.isVisible()) continue;
            size.width += comp.getPreferredSize().width;
        }
        return size;
    }

    private Dimension applyMinimumWidth(JComponent c15, Dimension size, int minimumWidth) {
        if (c15 instanceof JTextField && ((JTextField)c15).getColumns() > 0) {
            return size;
        }
        if (!FlatTextFieldUI.hasDefaultMargins(c15, this.defaultMargin)) {
            return size;
        }
        Container parent = c15.getParent();
        if (parent instanceof JComboBox || parent instanceof JSpinner || parent != null && parent.getParent() instanceof JSpinner) {
            return size;
        }
        minimumWidth = FlatUIUtils.minimumWidth(c15, minimumWidth);
        float focusWidth = FlatUIUtils.getBorderFocusWidth(c15);
        size.width = Math.max(size.width, UIScale.scale(minimumWidth) + Math.round(focusWidth * 2.0f));
        return size;
    }

    static boolean hasDefaultMargins(JComponent c15, Insets defaultMargin) {
        Insets margin = ((JTextComponent)c15).getMargin();
        return margin instanceof UIResource && Objects.equals(margin, defaultMargin);
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Insets padding;
        Rectangle r15 = this.getIconsRect();
        if (r15 == null) {
            return null;
        }
        int leading = this.getLeadingIconWidth();
        int trailing = this.getTrailingIconWidth();
        if (leading != 0 || trailing != 0) {
            boolean ltr = this.isLeftToRight();
            int left = ltr ? leading : trailing;
            int right = ltr ? trailing : leading;
            r15.x += left;
            r15.width -= left + right;
        }
        if ((padding = this.getPadding()) != null) {
            r15 = FlatUIUtils.subtractInsets(r15, padding);
        }
        r15.width = Math.max(r15.width, 0);
        r15.height = Math.max(r15.height, 0);
        return r15;
    }

    protected Rectangle getIconsRect() {
        Insets insets;
        Rectangle r15 = super.getVisibleEditorRect();
        if (r15 == null) {
            return null;
        }
        boolean ltr = this.isLeftToRight();
        JComponent[] leftComponents = ltr ? this.getLeadingComponents() : this.getTrailingComponents();
        JComponent[] rightComponents = ltr ? this.getTrailingComponents() : this.getLeadingComponents();
        boolean leftVisible = false;
        boolean rightVisible = false;
        for (JComponent leftComponent : leftComponents) {
            if (leftComponent == null || !leftComponent.isVisible()) continue;
            int w15 = leftComponent.getPreferredSize().width;
            r15.x += w15;
            r15.width -= w15;
            leftVisible = true;
        }
        for (JComponent rightComponent : rightComponents) {
            if (rightComponent == null || !rightComponent.isVisible()) continue;
            r15.width -= rightComponent.getPreferredSize().width;
            rightVisible = true;
        }
        if (leftVisible || (ltr ? this.hasLeadingIcon() : this.hasTrailingIcon())) {
            insets = this.getComponent().getInsets();
            int newLeftInset = Math.min(insets.left, insets.top);
            if (newLeftInset < insets.left) {
                int diff = insets.left - newLeftInset;
                r15.x -= diff;
                r15.width += diff;
            }
        }
        if (rightVisible || (ltr ? this.hasTrailingIcon() : this.hasLeadingIcon())) {
            insets = this.getComponent().getInsets();
            int newRightInset = Math.min(insets.right, insets.top);
            if (newRightInset < insets.left) {
                r15.width += insets.right - newRightInset;
            }
        }
        r15.width = Math.max(r15.width, 0);
        r15.height = Math.max(r15.height, 0);
        return r15;
    }

    protected boolean hasLeadingIcon() {
        return this.leadingIcon != null;
    }

    protected boolean hasTrailingIcon() {
        return this.trailingIcon != null;
    }

    protected int getLeadingIconWidth() {
        return this.leadingIcon != null ? this.leadingIcon.getIconWidth() + UIScale.scale(this.iconTextGap) : 0;
    }

    protected int getTrailingIconWidth() {
        return this.trailingIcon != null ? this.trailingIcon.getIconWidth() + UIScale.scale(this.iconTextGap) : 0;
    }

    boolean isLeftToRight() {
        return this.getComponent().getComponentOrientation().isLeftToRight();
    }

    protected Insets getPadding() {
        return UIScale.scale(FlatClientProperties.clientProperty(this.getComponent(), "JTextField.padding", null, Insets.class));
    }

    protected void scrollCaretToVisible() {
        Caret caret = this.getComponent().getCaret();
        if (caret instanceof FlatCaret) {
            ((FlatCaret)caret).scrollCaretToVisible();
        }
    }

    protected void installLeadingComponent() {
        JTextComponent c15 = this.getComponent();
        this.leadingComponent = FlatClientProperties.clientProperty(c15, "JTextField.leadingComponent", null, JComponent.class);
        if (this.leadingComponent != null) {
            this.prepareLeadingOrTrailingComponent(this.leadingComponent);
            this.installLayout();
            c15.add(this.leadingComponent);
        }
    }

    protected void installTrailingComponent() {
        JTextComponent c15 = this.getComponent();
        this.trailingComponent = FlatClientProperties.clientProperty(c15, "JTextField.trailingComponent", null, JComponent.class);
        if (this.trailingComponent != null) {
            this.prepareLeadingOrTrailingComponent(this.trailingComponent);
            this.installLayout();
            c15.add(this.trailingComponent);
        }
    }

    protected void uninstallLeadingComponent() {
        if (this.leadingComponent != null) {
            this.getComponent().remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    protected void uninstallTrailingComponent() {
        if (this.trailingComponent != null) {
            this.getComponent().remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    protected void installClearButton() {
        JTextComponent c15 = this.getComponent();
        if (FlatClientProperties.clientPropertyBoolean(c15, "JTextField.showClearButton", this.showClearButton)) {
            this.clearButton = this.createClearButton();
            this.updateClearButton();
            this.installDocumentListener();
            this.installLayout();
            c15.add(this.clearButton);
        }
    }

    protected void uninstallClearButton() {
        if (this.clearButton != null) {
            this.getComponent().remove(this.clearButton);
            this.clearButton = null;
        }
    }

    protected JComponent createClearButton() {
        JButton button = new JButton();
        button.setName("TextField.clearButton");
        button.putClientProperty("FlatLaf.styleClass", "clearButton");
        button.putClientProperty("JButton.buttonType", "toolBarButton");
        button.setCursor(Cursor.getDefaultCursor());
        button.addActionListener(e15 -> this.clearButtonClicked());
        return button;
    }

    protected void clearButtonClicked() {
        JTextComponent c15 = this.getComponent();
        Object callback = c15.getClientProperty("JTextField.clearCallback");
        if (callback instanceof Runnable) {
            ((Runnable)callback).run();
        } else if (callback instanceof Consumer) {
            ((Consumer)callback).accept(c15);
        } else {
            c15.setText("");
        }
    }

    protected void updateClearButton() {
        boolean visible;
        if (this.clearButton == null) {
            return;
        }
        JTextComponent c15 = this.getComponent();
        boolean bl4 = visible = c15.isEnabled() && c15.isEditable() && c15.getDocument().getLength() > 0;
        if (visible != this.clearButton.isVisible()) {
            this.clearButton.setVisible(visible);
            c15.revalidate();
            HiDPIUtils.repaint(c15);
        }
    }

    protected JComponent[] getLeadingComponents() {
        return new JComponent[]{this.leadingComponent};
    }

    protected JComponent[] getTrailingComponents() {
        return new JComponent[]{this.trailingComponent, this.clearButton};
    }

    protected void prepareLeadingOrTrailingComponent(JComponent c15) {
        c15.putClientProperty("FlatLaf.styleClass", "inTextField");
        if (c15 instanceof JButton || c15 instanceof JToggleButton) {
            c15.putClientProperty("JButton.buttonType", "toolBarButton");
            if (!c15.isCursorSet()) {
                c15.setCursor(Cursor.getDefaultCursor());
            }
        } else if (c15 instanceof JToolBar) {
            for (Component child : c15.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                ((JComponent)child).putClientProperty("FlatLaf.styleClass", "inTextField");
            }
            if (!c15.isCursorSet()) {
                c15.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected void installLayout() {
        JTextComponent c15 = this.getComponent();
        LayoutManager oldLayout = c15.getLayout();
        if (!(oldLayout instanceof FlatTextFieldLayout)) {
            c15.setLayout(new FlatTextFieldLayout(oldLayout));
        }
    }

    private class FlatDocumentListener
    implements DocumentListener {
        private FlatDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e15) {
            FlatTextFieldUI.this.documentChanged(e15);
        }

        @Override
        public void removeUpdate(DocumentEvent e15) {
            FlatTextFieldUI.this.documentChanged(e15);
        }

        @Override
        public void changedUpdate(DocumentEvent e15) {
            FlatTextFieldUI.this.documentChanged(e15);
        }
    }

    private class FlatTextFieldLayout
    implements LayoutManager2,
    UIResource {
        private final LayoutManager delegate;

        FlatTextFieldLayout(LayoutManager delegate2) {
            this.delegate = delegate2;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            if (this.delegate != null) {
                this.delegate.addLayoutComponent(name, comp);
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (this.delegate != null) {
                this.delegate.removeLayoutComponent(comp);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.delegate != null ? this.delegate.preferredLayoutSize(parent) : null;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.delegate != null ? this.delegate.minimumLayoutSize(parent) : null;
        }

        @Override
        public void layoutContainer(Container parent) {
            int cw4;
            if (this.delegate != null) {
                this.delegate.layoutContainer(parent);
            }
            int ow4 = FlatUIUtils.getBorderFocusAndLineWidth(FlatTextFieldUI.this.getComponent());
            int h15 = parent.getHeight() - ow4 - ow4;
            boolean ltr = FlatTextFieldUI.this.isLeftToRight();
            JComponent[] leftComponents = ltr ? FlatTextFieldUI.this.getLeadingComponents() : FlatTextFieldUI.this.getTrailingComponents();
            JComponent[] rightComponents = ltr ? FlatTextFieldUI.this.getTrailingComponents() : FlatTextFieldUI.this.getLeadingComponents();
            int x15 = ow4;
            for (JComponent leftComponent : leftComponents) {
                if (leftComponent == null || !leftComponent.isVisible()) continue;
                cw4 = leftComponent.getPreferredSize().width;
                leftComponent.setBounds(x15, ow4, cw4, h15);
                x15 += cw4;
            }
            x15 = parent.getWidth() - ow4;
            for (JComponent rightComponent : rightComponents) {
                if (rightComponent == null || !rightComponent.isVisible()) continue;
                cw4 = rightComponent.getPreferredSize().width;
                rightComponent.setBounds(x15 -= cw4, ow4, cw4, h15);
            }
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (this.delegate instanceof LayoutManager2) {
                ((LayoutManager2)this.delegate).addLayoutComponent(comp, constraints);
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).maximumLayoutSize(target) : null;
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).getLayoutAlignmentX(target) : 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).getLayoutAlignmentY(target) : 0.5f;
        }

        @Override
        public void invalidateLayout(Container target) {
            if (this.delegate instanceof LayoutManager2) {
                ((LayoutManager2)this.delegate).invalidateLayout(target);
            }
        }
    }
}

