/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.animation.interpolation;

import com.github.weisj.jsvg.animation.Additive;
import com.github.weisj.jsvg.animation.AnimationValuesType;
import com.github.weisj.jsvg.animation.interpolation.FloatInterpolator;
import com.github.weisj.jsvg.animation.interpolation.FloatListInterpolator;
import com.github.weisj.jsvg.animation.interpolation.PaintInterpolator;
import com.github.weisj.jsvg.animation.interpolation.TransformInterpolator;
import com.github.weisj.jsvg.attributes.transform.TransformPart;
import com.github.weisj.jsvg.attributes.value.TransformValue;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.paint.SVGPaint;
import com.github.weisj.jsvg.paint.SimplePaintSVGPaint;
import com.github.weisj.jsvg.paint.impl.AwtSVGPaint;
import com.github.weisj.jsvg.paint.impl.RGBColor;
import com.github.weisj.jsvg.renderer.MeasureContext;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultInterpolator
implements FloatInterpolator,
FloatListInterpolator,
PaintInterpolator,
TransformInterpolator {
    private final Additive additive;
    private final AnimationValuesType valuesType;

    public DefaultInterpolator(AnimationValuesType valuesType, Additive additive) {
        this.valuesType = valuesType;
        this.additive = additive;
    }

    @Override
    public float interpolate(float initial, float a15, float b15, float progress) {
        switch (this.valuesType) {
            case FROM_BY: {
                return a15 + b15 * progress;
            }
            case BY: {
                return initial + b15 * progress;
            }
            case TO: {
                return initial + (b15 - initial) * progress;
            }
        }
        float result = a15 + (b15 - a15) * progress;
        if (this.additive == Additive.SUM) {
            result += initial;
        }
        return result;
    }

    private static float @NotNull [] ensureCacheCapacity(float @Nullable [] cache, int length) {
        if (cache == null || cache.length != length) {
            return new float[length];
        }
        return cache;
    }

    private static float @NotNull [] arrayLerp(float @Nullable [] cache, float @NotNull [] from, float @Nullable [] to4, float progress) {
        float t15 = progress;
        boolean isEndTime = GeometryUtil.approximatelyEqual(t15, 1.0);
        if (to4 == null || from.length != to4.length && !isEndTime) {
            t15 = 0.0f;
        }
        float[] result = cache;
        if (to4 == null || GeometryUtil.approximatelyEqual(t15, 0.0)) {
            result = DefaultInterpolator.ensureCacheCapacity(result, from.length);
            System.arraycopy(from, 0, result, 0, from.length);
        } else if (isEndTime) {
            result = DefaultInterpolator.ensureCacheCapacity(result, to4.length);
            System.arraycopy(to4, 0, result, 0, to4.length);
        } else {
            result = DefaultInterpolator.ensureCacheCapacity(result, from.length);
            for (int i15 = 0; i15 < from.length; ++i15) {
                result[i15] = GeometryUtil.lerp(t15, from[i15], to4[i15]);
            }
        }
        return result;
    }

    private static float @NotNull [] saxpy(float @Nullable [] cache, float @NotNull [] b15, float @Nullable [] x15, float a15) {
        int i15;
        float[] result = DefaultInterpolator.ensureCacheCapacity(cache, b15.length);
        System.arraycopy(b15, 0, result, 0, b15.length);
        if (x15 == null) {
            return b15;
        }
        int n15 = Math.min(result.length, x15.length);
        for (i15 = 0; i15 < n15; ++i15) {
            int n16 = i15;
            result[n16] = result[n16] + a15 * x15[i15];
        }
        for (i15 = n15; i15 < result.length; ++i15) {
            int n17 = i15;
            result[n17] = result[n17] + a15 * x15[i15 % n15];
        }
        return result;
    }

    @Override
    public float @NotNull [] interpolate(float @NotNull [] initial, float @NotNull [] a15, float @Nullable [] b15, float progress, float @Nullable [] cache) {
        switch (this.valuesType) {
            case FROM_BY: {
                return DefaultInterpolator.saxpy(cache, a15, b15, progress);
            }
            case BY: {
                return DefaultInterpolator.saxpy(cache, initial, b15, progress);
            }
            case TO: {
                return DefaultInterpolator.arrayLerp(cache, initial, b15, progress);
            }
        }
        float[] result = DefaultInterpolator.arrayLerp(cache, a15, b15, progress);
        if (this.additive == Additive.SUM) {
            result = DefaultInterpolator.saxpy(result, result, initial, 1.0f);
        }
        return result;
    }

    @Nullable
    private static RGBColor extractColor(@NotNull SVGPaint p15) {
        if (!(p15 instanceof SimplePaintSVGPaint)) {
            return null;
        }
        Paint paint = ((SimplePaintSVGPaint)p15).paint();
        if (paint instanceof Color) {
            return new RGBColor((Color)paint);
        }
        if (paint instanceof RGBColor) {
            return (RGBColor)paint;
        }
        return null;
    }

    @Override
    @NotNull
    public SVGPaint interpolate(@NotNull SVGPaint initial, @NotNull SVGPaint a15, @NotNull SVGPaint b15, float progress) {
        RGBColor colorA = DefaultInterpolator.extractColor(a15);
        RGBColor colorB = DefaultInterpolator.extractColor(b15);
        if (colorA == null || colorB == null) {
            return this.discreteAnimation(initial, a15, b15, progress);
        }
        switch (this.valuesType) {
            case FROM_BY: {
                return new AwtSVGPaint(RGBColor.saxpy(progress, colorA, colorB));
            }
            case BY: {
                RGBColor initialColor = DefaultInterpolator.extractColor(initial);
                if (initialColor == null) {
                    return initial;
                }
                return new AwtSVGPaint(RGBColor.saxpy(progress, initialColor, colorB));
            }
            case TO: {
                RGBColor initialColor = DefaultInterpolator.extractColor(initial);
                if (initialColor == null) {
                    return initial;
                }
                return new AwtSVGPaint(RGBColor.interpolate(progress, initialColor, colorB));
            }
        }
        RGBColor result = RGBColor.interpolate(progress, colorA, colorB);
        if (this.additive == Additive.SUM) {
            RGBColor initialColor = DefaultInterpolator.extractColor(initial);
            if (initialColor == null) {
                return initial;
            }
            result = RGBColor.add(initialColor, result);
        }
        return new AwtSVGPaint(result);
    }

    private SVGPaint discreteAnimation(@NotNull SVGPaint initial, @NotNull SVGPaint a15, @NotNull SVGPaint b15, float progress) {
        if (this.additive != Additive.REPLACE) {
            return initial;
        }
        return GeometryUtil.approximatelyEqual(progress, 1.0) ? b15 : a15;
    }

    @Override
    @NotNull
    public AffineTransform interpolate(@NotNull MeasureContext context, @NotNull TransformValue initial, @NotNull TransformPart a15, @NotNull TransformPart b15, float progress) {
        switch (this.valuesType) {
            case FROM_BY: {
                return b15.applyToTransform(a15.applyToTransform(new AffineTransform(), context), context, progress);
            }
            case BY: {
                return b15.applyToTransform(initial.get(context), context, progress);
            }
            case TO: {
                return GeometryUtil.interpolate(initial.get(context), b15.toTransform(context), progress);
            }
        }
        AffineTransform result = TransformPart.interpolate(a15, b15, context, progress);
        if (this.additive == Additive.SUM) {
            result.preConcatenate(initial.get(context));
        }
        return result;
    }
}

