/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.J2ktIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleUtils;
import com.google.errorprone.annotations.concurrent.LazyInit;
import org.jspecify.annotations.Nullable;

@J2ktIncompatible
@GwtIncompatible
public abstract class LinearTransformation {
    @Deprecated
    public LinearTransformation() {
    }

    public static LinearTransformationBuilder mapping(double x15, double y15) {
        Preconditions.checkArgument(DoubleUtils.isFinite(x15) && DoubleUtils.isFinite(y15));
        return new LinearTransformationBuilder(x15, y15);
    }

    public static LinearTransformation vertical(double x15) {
        Preconditions.checkArgument(DoubleUtils.isFinite(x15));
        return new VerticalLinearTransformation(x15);
    }

    public static LinearTransformation horizontal(double y15) {
        Preconditions.checkArgument(DoubleUtils.isFinite(y15));
        double slope = 0.0;
        return new RegularLinearTransformation(slope, y15);
    }

    public static LinearTransformation forNaN() {
        return NaNLinearTransformation.INSTANCE;
    }

    public abstract boolean isVertical();

    public abstract boolean isHorizontal();

    public abstract double slope();

    public abstract double transform(double var1);

    public abstract LinearTransformation inverse();

    public static final class LinearTransformationBuilder {
        private final double x1;
        private final double y1;

        private LinearTransformationBuilder(double x15, double y15) {
            this.x1 = x15;
            this.y1 = y15;
        }

        public LinearTransformation and(double x25, double y25) {
            Preconditions.checkArgument(DoubleUtils.isFinite(x25) && DoubleUtils.isFinite(y25));
            if (x25 == this.x1) {
                Preconditions.checkArgument(y25 != this.y1);
                return new VerticalLinearTransformation(this.x1);
            }
            return this.withSlope((y25 - this.y1) / (x25 - this.x1));
        }

        public LinearTransformation withSlope(double slope) {
            Preconditions.checkArgument(!Double.isNaN(slope));
            if (DoubleUtils.isFinite(slope)) {
                double yIntercept = this.y1 - this.x1 * slope;
                return new RegularLinearTransformation(slope, yIntercept);
            }
            return new VerticalLinearTransformation(this.x1);
        }
    }

    private static final class VerticalLinearTransformation
    extends LinearTransformation {
        final double x;
        @LazyInit
        @Nullable LinearTransformation inverse;

        VerticalLinearTransformation(double x15) {
            this.x = x15;
            this.inverse = null;
        }

        VerticalLinearTransformation(double x15, LinearTransformation inverse) {
            this.x = x15;
            this.inverse = inverse;
        }

        @Override
        public boolean isVertical() {
            return true;
        }

        @Override
        public boolean isHorizontal() {
            return false;
        }

        @Override
        public double slope() {
            throw new IllegalStateException();
        }

        @Override
        public double transform(double x15) {
            throw new IllegalStateException();
        }

        @Override
        public LinearTransformation inverse() {
            LinearTransformation result = this.inverse;
            return result == null ? (this.inverse = this.createInverse()) : result;
        }

        public String toString() {
            return String.format("x = %g", this.x);
        }

        private LinearTransformation createInverse() {
            return new RegularLinearTransformation(0.0, this.x, this);
        }
    }

    private static final class RegularLinearTransformation
    extends LinearTransformation {
        final double slope;
        final double yIntercept;
        @LazyInit
        @Nullable LinearTransformation inverse;

        RegularLinearTransformation(double slope, double yIntercept) {
            this.slope = slope;
            this.yIntercept = yIntercept;
            this.inverse = null;
        }

        RegularLinearTransformation(double slope, double yIntercept, LinearTransformation inverse) {
            this.slope = slope;
            this.yIntercept = yIntercept;
            this.inverse = inverse;
        }

        @Override
        public boolean isVertical() {
            return false;
        }

        @Override
        public boolean isHorizontal() {
            return this.slope == 0.0;
        }

        @Override
        public double slope() {
            return this.slope;
        }

        @Override
        public double transform(double x15) {
            return x15 * this.slope + this.yIntercept;
        }

        @Override
        public LinearTransformation inverse() {
            LinearTransformation result = this.inverse;
            return result == null ? (this.inverse = this.createInverse()) : result;
        }

        public String toString() {
            return String.format("y = %g * x + %g", this.slope, this.yIntercept);
        }

        private LinearTransformation createInverse() {
            if (this.slope != 0.0) {
                return new RegularLinearTransformation(1.0 / this.slope, -1.0 * this.yIntercept / this.slope, this);
            }
            return new VerticalLinearTransformation(this.yIntercept, this);
        }
    }

    private static final class NaNLinearTransformation
    extends LinearTransformation {
        static final NaNLinearTransformation INSTANCE = new NaNLinearTransformation();

        private NaNLinearTransformation() {
        }

        @Override
        public boolean isVertical() {
            return false;
        }

        @Override
        public boolean isHorizontal() {
            return false;
        }

        @Override
        public double slope() {
            return Double.NaN;
        }

        @Override
        public double transform(double x15) {
            return Double.NaN;
        }

        @Override
        public LinearTransformation inverse() {
            return this;
        }

        public String toString() {
            return "NaN";
        }
    }
}

