/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.image;

import com.twelvemonkeys.image.IndexImage;
import com.twelvemonkeys.image.InverseColorMap;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.awt.Image;
import java.awt.image.IndexColorModel;

public class InverseColorMapIndexColorModel
extends IndexColorModel {
    protected int[] rgbs;
    protected int mapSize;
    protected InverseColorMap inverseMap = null;
    private static final int ALPHA_THRESHOLD = 128;
    private int whiteIndex = -1;
    private static final int WHITE = 0xFFFFFF;
    private static final int RGB_MASK = 0xFFFFFF;

    public InverseColorMapIndexColorModel(IndexColorModel indexColorModel) {
        this(Validate.notNull(indexColorModel, "color model"), InverseColorMapIndexColorModel.getRGBs(indexColorModel));
    }

    private InverseColorMapIndexColorModel(IndexColorModel indexColorModel, int[] nArray) {
        super(indexColorModel.getComponentSize()[0], indexColorModel.getMapSize(), nArray, 0, indexColorModel.getTransferType(), indexColorModel.getValidPixels());
        this.rgbs = nArray;
        this.mapSize = this.rgbs.length;
        this.inverseMap = new InverseColorMap(this.rgbs);
        this.whiteIndex = this.getWhiteIndex();
    }

    private static int[] getRGBs(IndexColorModel indexColorModel) {
        int[] nArray = new int[indexColorModel.getMapSize()];
        indexColorModel.getRGBs(nArray);
        return nArray;
    }

    public InverseColorMapIndexColorModel(int n15, int n16, int[] nArray, int n17, boolean bl4, int n18, int n19) {
        super(n15, n16, nArray, n17, bl4, n18, n19);
        this.rgbs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mapSize = this.rgbs.length;
        this.inverseMap = new InverseColorMap(this.rgbs, n18);
        this.whiteIndex = this.getWhiteIndex();
    }

    public InverseColorMapIndexColorModel(int n15, int n16, byte[] byArray, byte[] byArray2, byte[] byArray3, int n17) {
        super(n15, n16, byArray, byArray2, byArray3, n17);
        this.rgbs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mapSize = this.rgbs.length;
        this.inverseMap = new InverseColorMap(this.rgbs, n17);
        this.whiteIndex = this.getWhiteIndex();
    }

    public InverseColorMapIndexColorModel(int n15, int n16, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n15, n16, byArray, byArray2, byArray3);
        this.rgbs = InverseColorMapIndexColorModel.getRGBs(this);
        this.mapSize = this.rgbs.length;
        this.inverseMap = new InverseColorMap(this.rgbs);
        this.whiteIndex = this.getWhiteIndex();
    }

    private int getWhiteIndex() {
        for (int i15 = 0; i15 < this.rgbs.length; ++i15) {
            int n15 = this.rgbs[i15];
            if ((n15 & 0xFFFFFF) != 0xFFFFFF) continue;
            return i15;
        }
        return -1;
    }

    public static IndexColorModel create(Image image, int n15, int n16) {
        IndexColorModel indexColorModel = IndexImage.getIndexColorModel(image, n15, n16);
        InverseColorMapIndexColorModel inverseColorMapIndexColorModel = indexColorModel instanceof InverseColorMapIndexColorModel ? (InverseColorMapIndexColorModel)indexColorModel : new InverseColorMapIndexColorModel(indexColorModel);
        return inverseColorMapIndexColorModel;
    }

    @Override
    public Object getDataElements(int n15, Object object) {
        int n16;
        int n17 = n15 >>> 24;
        int n18 = n17 < 128 && this.getTransparentPixel() != -1 ? this.getTransparentPixel() : ((n16 = n15 & 0xFFFFFF) == 0xFFFFFF && this.whiteIndex != -1 ? this.whiteIndex : this.inverseMap.getIndexNearest(n16));
        return this.installpixel(object, n18);
    }

    private Object installpixel(Object object, int n15) {
        switch (this.transferType) {
            case 3: {
                int[] nArray;
                if (object == null) {
                    nArray = new int[1];
                    object = nArray;
                } else {
                    nArray = (int[])object;
                }
                nArray[0] = n15;
                break;
            }
            case 0: {
                byte[] byArray;
                if (object == null) {
                    byArray = new byte[1];
                    object = byArray;
                } else {
                    byArray = (byte[])object;
                }
                byArray[0] = (byte)n15;
                break;
            }
            case 1: {
                short[] sArray;
                if (object == null) {
                    sArray = new short[1];
                    object = sArray;
                } else {
                    sArray = (short[])object;
                }
                sArray[0] = (short)n15;
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return object;
    }

    @Override
    public String toString() {
        return StringUtil.replace(super.toString(), "IndexColorModel: ", this.getClass().getName() + ": ");
    }
}

