/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.stream;

import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public final class DirectImageInputStream
extends ImageInputStreamImpl {
    private final InputStream stream;
    private final long length;

    public DirectImageInputStream(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public DirectImageInputStream(InputStream inputStream, long l15) {
        this.stream = Validate.notNull(inputStream, "stream");
        this.length = Validate.isTrue(l15 >= 0L || l15 == -1L, l15, "negative length: %d");
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        ++this.streamPos;
        return this.stream.read();
    }

    @Override
    public int read(byte[] byArray, int n15, int n16) throws IOException {
        this.bitOffset = 0;
        int n17 = this.stream.read(byArray, n15, n16);
        if (n17 > 0) {
            this.streamPos += (long)n17;
        }
        return n17;
    }

    @Override
    public void seek(long l15) throws IOException {
        long l16;
        this.checkClosed();
        if (l15 < this.streamPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos");
        }
        this.bitOffset = 0;
        while (this.streamPos < l15 && (l16 = this.stream.skip(l15 - this.streamPos)) > 0L) {
            this.streamPos += l16;
        }
    }

    @Override
    public long getFlushedPosition() {
        return this.streamPos;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public int readBit() throws IOException {
        throw new UnsupportedOperationException("Bit reading not supported");
    }

    @Override
    public long readBits(int n15) throws IOException {
        throw new UnsupportedOperationException("Bit reading not supported");
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        super.close();
    }
}

