/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class MaybeConcatArrayDelayError<T>
extends Flowable<T> {
    final MaybeSource<? extends T>[] sources;

    public MaybeConcatArrayDelayError(MaybeSource<? extends T>[] sources) {
        this.sources = sources;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        ConcatMaybeObserver<T> parent = new ConcatMaybeObserver<T>(s15, this.sources);
        s15.onSubscribe(parent);
        parent.drain();
    }

    static final class ConcatMaybeObserver<T>
    extends AtomicInteger
    implements MaybeObserver<T>,
    Subscription {
        private static final long serialVersionUID = 3520831347801429610L;
        final Subscriber<? super T> downstream;
        final AtomicLong requested;
        final AtomicReference<Object> current;
        final SequentialDisposable disposables;
        final MaybeSource<? extends T>[] sources;
        final AtomicThrowable errors;
        int index;
        long produced;

        ConcatMaybeObserver(Subscriber<? super T> actual, MaybeSource<? extends T>[] sources) {
            this.downstream = actual;
            this.sources = sources;
            this.requested = new AtomicLong();
            this.disposables = new SequentialDisposable();
            this.current = new AtomicReference<NotificationLite>(NotificationLite.COMPLETE);
            this.errors = new AtomicThrowable();
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                this.drain();
            }
        }

        @Override
        public void cancel() {
            this.disposables.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            this.disposables.replace(d15);
        }

        @Override
        public void onSuccess(T value) {
            this.current.lazySet(value);
            this.drain();
        }

        @Override
        public void onError(Throwable e15) {
            this.current.lazySet((Object)NotificationLite.COMPLETE);
            if (this.errors.tryAddThrowableOrReport(e15)) {
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.current.lazySet((Object)NotificationLite.COMPLETE);
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            AtomicReference<Object> c15 = this.current;
            Subscriber<Object> a15 = this.downstream;
            SequentialDisposable cancelled = this.disposables;
            do {
                boolean goNextSource;
                if (cancelled.isDisposed()) {
                    c15.lazySet(null);
                    return;
                }
                Object o15 = c15.get();
                if (o15 == null) continue;
                if (o15 != NotificationLite.COMPLETE) {
                    long p15 = this.produced;
                    if (p15 != this.requested.get()) {
                        this.produced = p15 + 1L;
                        c15.lazySet(null);
                        goNextSource = true;
                        a15.onNext(o15);
                    } else {
                        goNextSource = false;
                    }
                } else {
                    goNextSource = true;
                    c15.lazySet(null);
                }
                if (!goNextSource || cancelled.isDisposed()) continue;
                int i15 = this.index;
                if (i15 == this.sources.length) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                this.index = i15 + 1;
                this.sources[i15].subscribe(this);
            } while (this.decrementAndGet() != 0);
        }
    }
}

