/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.maybe;

import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.maybe.MaybeMap;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class MaybeZipArray<T, R>
extends Maybe<R> {
    final MaybeSource<? extends T>[] sources;
    final Function<? super Object[], ? extends R> zipper;

    public MaybeZipArray(MaybeSource<? extends T>[] sources, Function<? super Object[], ? extends R> zipper) {
        this.sources = sources;
        this.zipper = zipper;
    }

    @Override
    protected void subscribeActual(MaybeObserver<? super R> observer) {
        MaybeSource<? extends T>[] sources = this.sources;
        int n15 = sources.length;
        if (n15 == 1) {
            sources[0].subscribe(new MaybeMap.MapMaybeObserver(observer, new SingletonArrayFunc()));
            return;
        }
        ZipCoordinator parent = new ZipCoordinator(observer, n15, this.zipper);
        observer.onSubscribe(parent);
        for (int i15 = 0; i15 < n15; ++i15) {
            if (parent.isDisposed()) {
                return;
            }
            MaybeSource source = sources[i15];
            if (source == null) {
                parent.innerError(new NullPointerException("One of the sources is null"), i15);
                return;
            }
            source.subscribe(parent.observers[i15]);
        }
    }

    final class SingletonArrayFunc
    implements Function<T, R> {
        SingletonArrayFunc() {
        }

        @Override
        public R apply(T t15) throws Throwable {
            return Objects.requireNonNull(MaybeZipArray.this.zipper.apply((Object[])new Object[]{t15}), "The zipper returned a null value");
        }
    }

    static final class ZipMaybeObserver<T>
    extends AtomicReference<Disposable>
    implements MaybeObserver<T> {
        private static final long serialVersionUID = 3323743579927613702L;
        final ZipCoordinator<T, ?> parent;
        final int index;

        ZipMaybeObserver(ZipCoordinator<T, ?> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            DisposableHelper.setOnce(this, d15);
        }

        @Override
        public void onSuccess(T value) {
            this.parent.innerSuccess(value, this.index);
        }

        @Override
        public void onError(Throwable e15) {
            this.parent.innerError(e15, this.index);
        }

        @Override
        public void onComplete() {
            this.parent.innerComplete(this.index);
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = -5556924161382950569L;
        final MaybeObserver<? super R> downstream;
        final Function<? super Object[], ? extends R> zipper;
        final ZipMaybeObserver<T>[] observers;
        Object[] values;

        ZipCoordinator(MaybeObserver<? super R> observer, int n15, Function<? super Object[], ? extends R> zipper) {
            super(n15);
            this.downstream = observer;
            this.zipper = zipper;
            ZipMaybeObserver[] o15 = new ZipMaybeObserver[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                o15[i15] = new ZipMaybeObserver(this, i15);
            }
            this.observers = o15;
            this.values = new Object[n15];
        }

        @Override
        public boolean isDisposed() {
            return this.get() <= 0;
        }

        @Override
        public void dispose() {
            if (this.getAndSet(0) > 0) {
                for (ZipMaybeObserver<T> d15 : this.observers) {
                    d15.dispose();
                }
                this.values = null;
            }
        }

        void innerSuccess(T value, int index) {
            Object[] values2 = this.values;
            if (values2 != null) {
                values2[index] = value;
            }
            if (this.decrementAndGet() == 0) {
                R v15;
                try {
                    v15 = Objects.requireNonNull(this.zipper.apply((Object[])values2), "The zipper returned a null value");
                }
                catch (Throwable ex4) {
                    Exceptions.throwIfFatal(ex4);
                    this.values = null;
                    this.downstream.onError(ex4);
                    return;
                }
                this.values = null;
                this.downstream.onSuccess(v15);
            }
        }

        void disposeExcept(int index) {
            int i15;
            ZipMaybeObserver<T>[] observers = this.observers;
            int n15 = observers.length;
            for (i15 = 0; i15 < index; ++i15) {
                observers[i15].dispose();
            }
            for (i15 = index + 1; i15 < n15; ++i15) {
                observers[i15].dispose();
            }
        }

        void innerError(Throwable ex4, int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.values = null;
                this.downstream.onError(ex4);
            } else {
                RxJavaPlugins.onError(ex4);
            }
        }

        void innerComplete(int index) {
            if (this.getAndSet(0) > 0) {
                this.disposeExcept(index);
                this.values = null;
                this.downstream.onComplete();
            }
        }
    }
}

