/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.operators.observable.ObservableScalarXMap;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.QueueDisposable;
import io.reactivex.rxjava3.operators.SimplePlainQueue;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMap<T, U>
extends AbstractObservableWithUpstream<T, U> {
    final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;
    final int bufferSize;

    public ObservableFlatMap(ObservableSource<T> source, Function<? super T, ? extends ObservableSource<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super U> t15) {
        if (ObservableScalarXMap.tryScalarXMapSubscribe(this.source, t15, this.mapper)) {
            return;
        }
        this.source.subscribe(new MergeObserver<T, U>(t15, this.mapper, this.delayErrors, this.maxConcurrency, this.bufferSize));
    }

    static final class InnerObserver<T, U>
    extends AtomicReference<Disposable>
    implements Observer<U> {
        private static final long serialVersionUID = -4606175640614850599L;
        final long id;
        final MergeObserver<T, U> parent;
        volatile boolean done;
        volatile SimpleQueue<U> queue;
        int fusionMode;

        InnerObserver(MergeObserver<T, U> parent, long id5) {
            this.id = id5;
            this.parent = parent;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.setOnce(this, d15) && d15 instanceof QueueDisposable) {
                QueueDisposable qd5 = (QueueDisposable)d15;
                int m15 = qd5.requestFusion(7);
                if (m15 == 1) {
                    this.fusionMode = m15;
                    this.queue = qd5;
                    this.done = true;
                    this.parent.drain();
                    return;
                }
                if (m15 == 2) {
                    this.fusionMode = m15;
                    this.queue = qd5;
                }
            }
        }

        @Override
        public void onNext(U t15) {
            if (this.fusionMode == 0) {
                this.parent.tryEmit(t15, this);
            } else {
                this.parent.drain();
            }
        }

        @Override
        public void onError(Throwable t15) {
            if (this.parent.errors.tryAddThrowableOrReport(t15)) {
                if (!this.parent.delayErrors) {
                    this.parent.disposeAll();
                }
                this.done = true;
                this.parent.drain();
            }
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        public void dispose() {
            DisposableHelper.dispose(this);
        }
    }

    static final class MergeObserver<T, U>
    extends AtomicInteger
    implements Disposable,
    Observer<T> {
        private static final long serialVersionUID = -2117620485640801370L;
        final Observer<? super U> downstream;
        final Function<? super T, ? extends ObservableSource<? extends U>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final int bufferSize;
        volatile SimplePlainQueue<U> queue;
        volatile boolean done;
        final AtomicThrowable errors = new AtomicThrowable();
        volatile boolean disposed;
        final AtomicReference<InnerObserver<?, ?>[]> observers;
        static final InnerObserver<?, ?>[] EMPTY = new InnerObserver[0];
        static final InnerObserver<?, ?>[] CANCELLED = new InnerObserver[0];
        Disposable upstream;
        long uniqueId;
        int lastIndex;
        Queue<ObservableSource<? extends U>> sources;
        int wip;

        MergeObserver(Observer<? super U> actual, Function<? super T, ? extends ObservableSource<? extends U>> mapper, boolean delayErrors, int maxConcurrency, int bufferSize) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.bufferSize = bufferSize;
            if (maxConcurrency != Integer.MAX_VALUE) {
                this.sources = new ArrayDeque<ObservableSource<? extends U>>(maxConcurrency);
            }
            this.observers = new AtomicReference<InnerObserver<?, ?>[]>(EMPTY);
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t15) {
            ObservableSource<? extends U> p15;
            if (this.done) {
                return;
            }
            try {
                p15 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null ObservableSource");
            }
            catch (Throwable e15) {
                Exceptions.throwIfFatal(e15);
                this.upstream.dispose();
                this.onError(e15);
                return;
            }
            if (this.maxConcurrency != Integer.MAX_VALUE) {
                MergeObserver mergeObserver = this;
                synchronized (mergeObserver) {
                    if (this.wip == this.maxConcurrency) {
                        this.sources.offer(p15);
                        return;
                    }
                    ++this.wip;
                }
            }
            this.subscribeInner(p15);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribeInner(ObservableSource<? extends U> p15) {
            block5: {
                InnerObserver inner;
                while (p15 instanceof Supplier) {
                    if (!this.tryEmitScalar((Supplier)((Object)p15)) || this.maxConcurrency == Integer.MAX_VALUE) break block5;
                    boolean empty = false;
                    MergeObserver mergeObserver = this;
                    synchronized (mergeObserver) {
                        p15 = this.sources.poll();
                        if (p15 == null) {
                            --this.wip;
                            empty = true;
                        }
                    }
                    if (!empty) continue;
                    this.drain();
                    break block5;
                }
                if (!this.addInner(inner = new InnerObserver(this, this.uniqueId++))) break block5;
                p15.subscribe(inner);
            }
        }

        boolean addInner(InnerObserver<T, U> inner) {
            InnerObserver[] b15;
            InnerObserver<?, ?>[] a15;
            do {
                if ((a15 = this.observers.get()) == CANCELLED) {
                    inner.dispose();
                    return false;
                }
                int n15 = a15.length;
                b15 = new InnerObserver[n15 + 1];
                System.arraycopy(a15, 0, b15, 0, n15);
                b15[n15] = inner;
            } while (!this.observers.compareAndSet(a15, b15));
            return true;
        }

        void removeInner(InnerObserver<T, U> inner) {
            InnerObserver<?, ?>[] b15;
            InnerObserver<?, ?>[] a15;
            do {
                a15 = this.observers.get();
                int n15 = a15.length;
                int j15 = -1;
                for (int i15 = 0; i15 < n15; ++i15) {
                    if (a15[i15] != inner) continue;
                    j15 = i15;
                    break;
                }
                if (j15 < 0) {
                    return;
                }
                if (n15 == 1) {
                    b15 = EMPTY;
                    continue;
                }
                b15 = new InnerObserver[n15 - 1];
                System.arraycopy(a15, 0, b15, 0, j15);
                System.arraycopy(a15, j15 + 1, b15, j15, n15 - j15 - 1);
            } while (!this.observers.compareAndSet(a15, b15));
        }

        boolean tryEmitScalar(Supplier<? extends U> value) {
            U u15;
            try {
                u15 = value.get();
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.errors.tryAddThrowableOrReport(ex4);
                this.drain();
                return true;
            }
            if (u15 == null) {
                return true;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.downstream.onNext(u15);
                if (this.decrementAndGet() == 0) {
                    return true;
                }
            } else {
                SimplePlainQueue<U> q15 = this.queue;
                if (q15 == null) {
                    q15 = this.maxConcurrency == Integer.MAX_VALUE ? new SpscLinkedArrayQueue<U>(this.bufferSize) : new SpscArrayQueue<U>(this.maxConcurrency);
                    this.queue = q15;
                }
                q15.offer(u15);
                if (this.getAndIncrement() != 0) {
                    return false;
                }
            }
            this.drainLoop();
            return true;
        }

        void tryEmit(U value, InnerObserver<T, U> inner) {
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.downstream.onNext(value);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimpleQueue q15 = inner.queue;
                if (q15 == null) {
                    q15 = new SpscLinkedArrayQueue(this.bufferSize);
                    inner.queue = q15;
                }
                q15.offer(value);
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t15) {
            if (this.done) {
                RxJavaPlugins.onError(t15);
                return;
            }
            if (this.errors.tryAddThrowableOrReport(t15)) {
                this.done = true;
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            this.disposed = true;
            if (this.disposeAll()) {
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.disposed;
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void drainLoop() {
            Observer<U> child = this.downstream;
            int missed = 1;
            while (true) {
                if (this.checkTerminate()) {
                    return;
                }
                int innerCompleted = 0;
                SimplePlainQueue<U> svq = this.queue;
                if (svq != null) {
                    while (true) {
                        if (this.checkTerminate()) {
                            return;
                        }
                        U o15 = svq.poll();
                        if (o15 == null) break;
                        child.onNext(o15);
                        ++innerCompleted;
                    }
                }
                if (innerCompleted != 0) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                    this.subscribeMore(innerCompleted);
                    innerCompleted = 0;
                    continue;
                }
                boolean d15 = this.done;
                svq = this.queue;
                InnerObserver<?, ?>[] inner = this.observers.get();
                int n15 = inner.length;
                int nSources = 0;
                if (this.maxConcurrency != Integer.MAX_VALUE) {
                    MergeObserver mergeObserver = this;
                    synchronized (mergeObserver) {
                        nSources = this.sources.size();
                    }
                }
                if (d15 && (svq == null || svq.isEmpty()) && n15 == 0 && nSources == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (n15 != 0) {
                    int j15 = Math.min(n15 - 1, this.lastIndex);
                    block7: for (int i15 = 0; i15 < n15; ++i15) {
                        InnerObserver<?, ?> is4;
                        block21: {
                            if (this.checkTerminate()) {
                                return;
                            }
                            is4 = inner[j15];
                            SimpleQueue q15 = is4.queue;
                            if (q15 != null) {
                                do {
                                    Object o16;
                                    try {
                                        o16 = q15.poll();
                                    }
                                    catch (Throwable ex4) {
                                        Exceptions.throwIfFatal(ex4);
                                        is4.dispose();
                                        this.errors.tryAddThrowableOrReport(ex4);
                                        if (this.checkTerminate()) {
                                            return;
                                        }
                                        this.removeInner(is4);
                                        ++innerCompleted;
                                        if (++j15 != n15) continue block7;
                                        j15 = 0;
                                        continue block7;
                                    }
                                    if (o16 == null) break block21;
                                    child.onNext(o16);
                                } while (!this.checkTerminate());
                                return;
                            }
                        }
                        boolean innerDone = is4.done;
                        SimpleQueue innerQueue = is4.queue;
                        if (innerDone && (innerQueue == null || innerQueue.isEmpty())) {
                            this.removeInner(is4);
                            ++innerCompleted;
                        }
                        if (++j15 != n15) continue;
                        j15 = 0;
                    }
                    this.lastIndex = j15;
                }
                if (innerCompleted != 0) {
                    if (this.maxConcurrency == Integer.MAX_VALUE) continue;
                    this.subscribeMore(innerCompleted);
                    innerCompleted = 0;
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void subscribeMore(int innerCompleted) {
            while (innerCompleted-- != 0) {
                ObservableSource<? extends U> p15;
                MergeObserver mergeObserver = this;
                synchronized (mergeObserver) {
                    p15 = this.sources.poll();
                    if (p15 == null) {
                        --this.wip;
                        continue;
                    }
                }
                this.subscribeInner(p15);
            }
        }

        boolean checkTerminate() {
            if (this.disposed) {
                return true;
            }
            Throwable e15 = (Throwable)this.errors.get();
            if (!this.delayErrors && e15 != null) {
                this.disposeAll();
                this.errors.tryTerminateConsumer(this.downstream);
                return true;
            }
            return false;
        }

        boolean disposeAll() {
            this.upstream.dispose();
            InnerObserver<?, ?>[] a15 = this.observers.getAndSet(CANCELLED);
            if (a15 != CANCELLED) {
                for (InnerObserver<?, ?> inner : a15) {
                    inner.dispose();
                }
                return true;
            }
            return false;
        }
    }
}

