/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.MaybeSource;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableFlatMapMaybe<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
    final boolean delayErrors;

    public ObservableFlatMapMaybe(ObservableSource<T> source, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayError) {
        super(source);
        this.mapper = mapper;
        this.delayErrors = delayError;
    }

    @Override
    protected void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new FlatMapMaybeObserver<T, R>(observer, this.mapper, this.delayErrors));
    }

    static final class FlatMapMaybeObserver<T, R>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 8600231336733376951L;
        final Observer<? super R> downstream;
        final boolean delayErrors;
        final CompositeDisposable set;
        final AtomicInteger active;
        final AtomicThrowable errors;
        final Function<? super T, ? extends MaybeSource<? extends R>> mapper;
        final AtomicReference<SpscLinkedArrayQueue<R>> queue;
        Disposable upstream;
        volatile boolean cancelled;

        FlatMapMaybeObserver(Observer<? super R> actual, Function<? super T, ? extends MaybeSource<? extends R>> mapper, boolean delayErrors) {
            this.downstream = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.set = new CompositeDisposable();
            this.errors = new AtomicThrowable();
            this.active = new AtomicInteger(1);
            this.queue = new AtomicReference();
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            MaybeSource<R> ms4;
            try {
                ms4 = Objects.requireNonNull(this.mapper.apply(t15), "The mapper returned a null MaybeSource");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                this.upstream.dispose();
                this.onError(ex4);
                return;
            }
            this.active.getAndIncrement();
            InnerObserver inner = new InnerObserver();
            if (!this.cancelled && this.set.add(inner)) {
                ms4.subscribe(inner);
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.active.decrementAndGet();
            if (this.errors.tryAddThrowableOrReport(t15)) {
                if (!this.delayErrors) {
                    this.set.dispose();
                }
                this.drain();
            }
        }

        @Override
        public void onComplete() {
            this.active.decrementAndGet();
            this.drain();
        }

        @Override
        public void dispose() {
            this.cancelled = true;
            this.upstream.dispose();
            this.set.dispose();
            this.errors.tryTerminateAndReport();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerSuccess(InnerObserver inner, R value) {
            this.set.delete(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.downstream.onNext(value);
                boolean d15 = this.active.decrementAndGet() == 0;
                SpscLinkedArrayQueue<R> q15 = this.queue.get();
                if (d15 && (q15 == null || q15.isEmpty())) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SpscLinkedArrayQueue<R> q16;
                SpscLinkedArrayQueue<R> spscLinkedArrayQueue = q16 = this.getOrCreateQueue();
                synchronized (spscLinkedArrayQueue) {
                    q16.offer(value);
                }
                this.active.decrementAndGet();
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        SpscLinkedArrayQueue<R> getOrCreateQueue() {
            SpscLinkedArrayQueue<Object> current = this.queue.get();
            if (current != null) {
                return current;
            }
            current = new SpscLinkedArrayQueue(Observable.bufferSize());
            if (this.queue.compareAndSet(null, current)) {
                return current;
            }
            return this.queue.get();
        }

        void innerError(InnerObserver inner, Throwable e15) {
            this.set.delete(inner);
            if (this.errors.tryAddThrowableOrReport(e15)) {
                if (!this.delayErrors) {
                    this.upstream.dispose();
                    this.set.dispose();
                }
                this.active.decrementAndGet();
                this.drain();
            }
        }

        void innerComplete(InnerObserver inner) {
            this.set.delete(inner);
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                boolean d15 = this.active.decrementAndGet() == 0;
                SpscLinkedArrayQueue<R> q15 = this.queue.get();
                if (d15 && (q15 == null || q15.isEmpty())) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    return;
                }
                if (this.decrementAndGet() == 0) {
                    return;
                }
                this.drainLoop();
            } else {
                this.active.decrementAndGet();
                this.drain();
            }
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void clear() {
            SpscLinkedArrayQueue<R> q15 = this.queue.get();
            if (q15 != null) {
                q15.clear();
            }
        }

        void drainLoop() {
            int missed = 1;
            Observer<R> a15 = this.downstream;
            AtomicInteger n15 = this.active;
            AtomicReference<SpscLinkedArrayQueue<R>> qr4 = this.queue;
            while (true) {
                boolean empty;
                Throwable ex4;
                if (this.cancelled) {
                    this.clear();
                    return;
                }
                if (!this.delayErrors && (ex4 = (Throwable)this.errors.get()) != null) {
                    this.clear();
                    this.errors.tryTerminateConsumer(a15);
                    return;
                }
                boolean d15 = n15.get() == 0;
                SpscLinkedArrayQueue<R> q15 = qr4.get();
                Object v15 = q15 != null ? (Object)q15.poll() : null;
                boolean bl4 = empty = v15 == null;
                if (d15 && empty) {
                    this.errors.tryTerminateConsumer(a15);
                    return;
                }
                if (!empty) {
                    a15.onNext(v15);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        final class InnerObserver
        extends AtomicReference<Disposable>
        implements MaybeObserver<R>,
        Disposable {
            private static final long serialVersionUID = -502562646270949838L;

            InnerObserver() {
            }

            @Override
            public void onSubscribe(Disposable d15) {
                DisposableHelper.setOnce(this, d15);
            }

            @Override
            public void onSuccess(R value) {
                FlatMapMaybeObserver.this.innerSuccess(this, value);
            }

            @Override
            public void onError(Throwable e15) {
                FlatMapMaybeObserver.this.innerError(this, e15);
            }

            @Override
            public void onComplete() {
                FlatMapMaybeObserver.this.innerComplete(this);
            }

            @Override
            public boolean isDisposed() {
                return DisposableHelper.isDisposed((Disposable)this.get());
            }

            @Override
            public void dispose() {
                DisposableHelper.dispose(this);
            }
        }
    }
}

