/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;
import io.reactivex.rxjava3.internal.util.ExceptionHelper;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ObservableFromFuture<T>
extends Observable<T> {
    final Future<? extends T> future;
    final long timeout;
    final TimeUnit unit;

    public ObservableFromFuture(Future<? extends T> future, long timeout, TimeUnit unit) {
        this.future = future;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        DeferredScalarDisposable<T> d15 = new DeferredScalarDisposable<T>(observer);
        observer.onSubscribe(d15);
        if (!d15.isDisposed()) {
            T v15;
            try {
                v15 = ExceptionHelper.nullCheck(this.unit != null ? this.future.get(this.timeout, this.unit) : this.future.get(), "Future returned a null value.");
            }
            catch (Throwable ex4) {
                Exceptions.throwIfFatal(ex4);
                if (!d15.isDisposed()) {
                    observer.onError(ex4);
                }
                return;
            }
            d15.complete(v15);
        }
    }
}

