/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.operators.SpscLinkedArrayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableSkipLastTimed<T>
extends AbstractObservableWithUpstream<T, T> {
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public ObservableSkipLastTimed(ObservableSource<T> source, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super T> t15) {
        this.source.subscribe(new SkipLastTimedObserver<T>(t15, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class SkipLastTimedObserver<T>
    extends AtomicInteger
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -5677354903406201275L;
        final Observer<? super T> downstream;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Disposable upstream;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        SkipLastTimedObserver(Observer<? super T> actual, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.downstream = actual;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t15) {
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            long now = this.scheduler.now(this.unit);
            q15.offer(now, t15);
            this.drain();
        }

        @Override
        public void onError(Throwable t15) {
            this.error = t15;
            this.done = true;
            this.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.upstream.dispose();
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Observer<Object> a15 = this.downstream;
            SpscLinkedArrayQueue<Object> q15 = this.queue;
            boolean delayError = this.delayError;
            TimeUnit unit = this.unit;
            Scheduler scheduler = this.scheduler;
            long time = this.time;
            while (true) {
                if (this.cancelled) {
                    this.queue.clear();
                    return;
                }
                boolean d15 = this.done;
                Long ts4 = (Long)q15.peek();
                boolean empty = ts4 == null;
                long now = scheduler.now(unit);
                if (!empty && ts4 > now - time) {
                    empty = true;
                }
                if (d15) {
                    Throwable e15;
                    if (delayError) {
                        if (empty) {
                            e15 = this.error;
                            if (e15 != null) {
                                a15.onError(e15);
                            } else {
                                a15.onComplete();
                            }
                            return;
                        }
                    } else {
                        e15 = this.error;
                        if (e15 != null) {
                            this.queue.clear();
                            a15.onError(e15);
                            return;
                        }
                        if (empty) {
                            a15.onComplete();
                            return;
                        }
                    }
                }
                if (!empty) {
                    q15.poll();
                    Object v15 = q15.poll();
                    a15.onNext(v15);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

