/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.rxjava3.observers.SerializedObserver;

public final class ObservableSkipUntil<T, U>
extends AbstractObservableWithUpstream<T, T> {
    final ObservableSource<U> other;

    public ObservableSkipUntil(ObservableSource<T> source, ObservableSource<U> other) {
        super(source);
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super T> child) {
        SerializedObserver<T> serial = new SerializedObserver<T>(child);
        ArrayCompositeDisposable frc = new ArrayCompositeDisposable(2);
        serial.onSubscribe(frc);
        SkipUntilObserver<? super T> sus = new SkipUntilObserver<T>(serial, frc);
        this.other.subscribe(new SkipUntil(frc, sus, serial));
        this.source.subscribe(sus);
    }

    final class SkipUntil
    implements Observer<U> {
        final ArrayCompositeDisposable frc;
        final SkipUntilObserver<T> sus;
        final SerializedObserver<T> serial;
        Disposable upstream;

        SkipUntil(ArrayCompositeDisposable frc, SkipUntilObserver<T> sus, SerializedObserver<T> serial) {
            this.frc = frc;
            this.sus = sus;
            this.serial = serial;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.frc.setResource(1, d15);
            }
        }

        @Override
        public void onNext(U t15) {
            this.upstream.dispose();
            this.sus.notSkipping = true;
        }

        @Override
        public void onError(Throwable t15) {
            this.frc.dispose();
            this.serial.onError(t15);
        }

        @Override
        public void onComplete() {
            this.sus.notSkipping = true;
        }
    }

    static final class SkipUntilObserver<T>
    implements Observer<T> {
        final Observer<? super T> downstream;
        final ArrayCompositeDisposable frc;
        Disposable upstream;
        volatile boolean notSkipping;
        boolean notSkippingLocal;

        SkipUntilObserver(Observer<? super T> actual, ArrayCompositeDisposable frc) {
            this.downstream = actual;
            this.frc = frc;
        }

        @Override
        public void onSubscribe(Disposable d15) {
            if (DisposableHelper.validate(this.upstream, d15)) {
                this.upstream = d15;
                this.frc.setResource(0, d15);
            }
        }

        @Override
        public void onNext(T t15) {
            if (this.notSkippingLocal) {
                this.downstream.onNext(t15);
            } else if (this.notSkipping) {
                this.notSkippingLocal = true;
                this.downstream.onNext(t15);
            }
        }

        @Override
        public void onError(Throwable t15) {
            this.frc.dispose();
            this.downstream.onError(t15);
        }

        @Override
        public void onComplete() {
            this.frc.dispose();
            this.downstream.onComplete();
        }
    }
}

