/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.parallel;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.BackpressureHelper;
import io.reactivex.rxjava3.parallel.ParallelFlowable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelSortedJoin<T>
extends Flowable<T> {
    final ParallelFlowable<List<T>> source;
    final Comparator<? super T> comparator;

    public ParallelSortedJoin(ParallelFlowable<List<T>> source, Comparator<? super T> comparator) {
        this.source = source;
        this.comparator = comparator;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s15) {
        SortedJoinSubscription<? super T> parent = new SortedJoinSubscription<T>(s15, this.source.parallelism(), this.comparator);
        s15.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class SortedJoinInnerSubscriber<T>
    extends AtomicReference<Subscription>
    implements FlowableSubscriber<List<T>> {
        private static final long serialVersionUID = 6751017204873808094L;
        final SortedJoinSubscription<T> parent;
        final int index;

        SortedJoinInnerSubscriber(SortedJoinSubscription<T> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        @Override
        public void onSubscribe(Subscription s15) {
            SubscriptionHelper.setOnce(this, s15, Long.MAX_VALUE);
        }

        @Override
        public void onNext(List<T> t15) {
            this.parent.innerNext(t15, this.index);
        }

        @Override
        public void onError(Throwable t15) {
            this.parent.innerError(t15);
        }

        @Override
        public void onComplete() {
        }

        void cancel() {
            SubscriptionHelper.cancel(this);
        }
    }

    static final class SortedJoinSubscription<T>
    extends AtomicInteger
    implements Subscription {
        private static final long serialVersionUID = 3481980673745556697L;
        final Subscriber<? super T> downstream;
        final SortedJoinInnerSubscriber<T>[] subscribers;
        final List<T>[] lists;
        final int[] indexes;
        final Comparator<? super T> comparator;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        final AtomicInteger remaining = new AtomicInteger();
        final AtomicReference<Throwable> error = new AtomicReference();

        SortedJoinSubscription(Subscriber<? super T> actual, int n15, Comparator<? super T> comparator) {
            this.downstream = actual;
            this.comparator = comparator;
            SortedJoinInnerSubscriber[] s15 = new SortedJoinInnerSubscriber[n15];
            for (int i15 = 0; i15 < n15; ++i15) {
                s15[i15] = new SortedJoinInnerSubscriber(this, i15);
            }
            this.subscribers = s15;
            this.lists = new List[n15];
            this.indexes = new int[n15];
            this.remaining.lazySet(n15);
        }

        @Override
        public void request(long n15) {
            if (SubscriptionHelper.validate(n15)) {
                BackpressureHelper.add(this.requested, n15);
                if (this.remaining.get() == 0) {
                    this.drain();
                }
            }
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (this.getAndIncrement() == 0) {
                    Arrays.fill(this.lists, null);
                }
            }
        }

        void cancelAll() {
            for (SortedJoinInnerSubscriber<T> s15 : this.subscribers) {
                s15.cancel();
            }
        }

        void innerNext(List<T> value, int index) {
            this.lists[index] = value;
            if (this.remaining.decrementAndGet() == 0) {
                this.drain();
            }
        }

        void innerError(Throwable e15) {
            if (this.error.compareAndSet(null, e15)) {
                this.drain();
            } else if (e15 != this.error.get()) {
                RxJavaPlugins.onError(e15);
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<T> a15 = this.downstream;
            Object[] lists = this.lists;
            int[] indexes = this.indexes;
            int n15 = indexes.length;
            do {
                Throwable ex4;
                long e15;
                long r15 = this.requested.get();
                for (e15 = 0L; e15 != r15; ++e15) {
                    if (this.cancelled) {
                        Arrays.fill(lists, null);
                        return;
                    }
                    ex4 = this.error.get();
                    if (ex4 != null) {
                        this.cancelAll();
                        Arrays.fill(lists, null);
                        a15.onError(ex4);
                        return;
                    }
                    Object min = null;
                    int minIndex = -1;
                    for (int i15 = 0; i15 < n15; ++i15) {
                        boolean smaller;
                        Object list2 = lists[i15];
                        int index = indexes[i15];
                        if (list2.size() == index) continue;
                        if (min == null) {
                            min = list2.get(index);
                            minIndex = i15;
                            continue;
                        }
                        Object b15 = list2.get(index);
                        try {
                            smaller = this.comparator.compare(min, b15) > 0;
                        }
                        catch (Throwable exc) {
                            Exceptions.throwIfFatal(exc);
                            this.cancelAll();
                            Arrays.fill(lists, null);
                            if (!this.error.compareAndSet(null, exc)) {
                                RxJavaPlugins.onError(exc);
                            }
                            a15.onError(this.error.get());
                            return;
                        }
                        if (!smaller) continue;
                        min = b15;
                        minIndex = i15;
                    }
                    if (min == null) {
                        Arrays.fill(lists, null);
                        a15.onComplete();
                        return;
                    }
                    a15.onNext(min);
                    int n16 = minIndex;
                    indexes[n16] = indexes[n16] + 1;
                }
                if (this.cancelled) {
                    Arrays.fill(lists, null);
                    return;
                }
                ex4 = this.error.get();
                if (ex4 != null) {
                    this.cancelAll();
                    Arrays.fill(lists, null);
                    a15.onError(ex4);
                    return;
                }
                boolean empty = true;
                for (int i16 = 0; i16 < n15; ++i16) {
                    if (indexes[i16] == lists[i16].size()) continue;
                    empty = false;
                    break;
                }
                if (empty) {
                    Arrays.fill(lists, null);
                    a15.onComplete();
                    return;
                }
                if (e15 == 0L) continue;
                BackpressureHelper.produced(this.requested, e15);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }
    }
}

