/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.util;

import io.reactivex.rxjava3.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.atomic.AtomicInteger;

public final class VolatileSizeArrayList<T>
extends AtomicInteger
implements List<T>,
RandomAccess {
    private static final long serialVersionUID = 3972397474470203923L;
    final ArrayList<T> list;

    public VolatileSizeArrayList() {
        this.list = new ArrayList();
    }

    public VolatileSizeArrayList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    @Override
    public int size() {
        return this.get();
    }

    @Override
    public boolean isEmpty() {
        return this.get() == 0;
    }

    @Override
    public boolean contains(Object o15) {
        return this.list.contains(o15);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <E> E[] toArray(@NonNull E[] a15) {
        return this.list.toArray(a15);
    }

    @Override
    public boolean add(T e15) {
        boolean b15 = this.list.add(e15);
        this.lazySet(this.list.size());
        return b15;
    }

    @Override
    public boolean remove(Object o15) {
        boolean b15 = this.list.remove(o15);
        this.lazySet(this.list.size());
        return b15;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c15) {
        return this.list.containsAll(c15);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends T> c15) {
        boolean b15 = this.list.addAll(c15);
        this.lazySet(this.list.size());
        return b15;
    }

    @Override
    public boolean addAll(int index, @NonNull Collection<? extends T> c15) {
        boolean b15 = this.list.addAll(index, c15);
        this.lazySet(this.list.size());
        return b15;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c15) {
        boolean b15 = this.list.removeAll(c15);
        this.lazySet(this.list.size());
        return b15;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c15) {
        boolean b15 = this.list.retainAll(c15);
        this.lazySet(this.list.size());
        return b15;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.lazySet(0);
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.list.add(index, element);
        this.lazySet(this.list.size());
    }

    @Override
    public T remove(int index) {
        T v15 = this.list.remove(index);
        this.lazySet(this.list.size());
        return v15;
    }

    @Override
    public int indexOf(Object o15) {
        return this.list.indexOf(o15);
    }

    @Override
    public int lastIndexOf(Object o15) {
        return this.list.lastIndexOf(o15);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof VolatileSizeArrayList) {
            return this.list.equals(((VolatileSizeArrayList)obj).list);
        }
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }
}

