/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.subscribers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.observers.BaseTestConsumer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class TestSubscriber<T>
extends BaseTestConsumer<T, TestSubscriber<T>>
implements FlowableSubscriber<T>,
Subscription {
    private final Subscriber<? super T> downstream;
    private volatile boolean cancelled;
    private final AtomicReference<Subscription> upstream;
    private final AtomicLong missedRequested;

    @NonNull
    public static <T> TestSubscriber<T> create() {
        return new TestSubscriber<T>();
    }

    @NonNull
    public static <T> TestSubscriber<T> create(long initialRequested) {
        return new TestSubscriber<T>(initialRequested);
    }

    public static <T> TestSubscriber<T> create(@NonNull Subscriber<? super T> delegate2) {
        return new TestSubscriber<T>(delegate2);
    }

    public TestSubscriber() {
        this(EmptySubscriber.INSTANCE, Long.MAX_VALUE);
    }

    public TestSubscriber(long initialRequest) {
        this(EmptySubscriber.INSTANCE, initialRequest);
    }

    public TestSubscriber(@NonNull Subscriber<? super T> downstream) {
        this(downstream, Long.MAX_VALUE);
    }

    public TestSubscriber(@NonNull Subscriber<? super T> actual, long initialRequest) {
        if (initialRequest < 0L) {
            throw new IllegalArgumentException("Negative initial request not allowed");
        }
        this.downstream = actual;
        this.upstream = new AtomicReference();
        this.missedRequested = new AtomicLong(initialRequest);
    }

    @Override
    public void onSubscribe(@NonNull Subscription s15) {
        this.lastThread = Thread.currentThread();
        if (s15 == null) {
            this.errors.add(new NullPointerException("onSubscribe received a null Subscription"));
            return;
        }
        if (!this.upstream.compareAndSet(null, s15)) {
            s15.cancel();
            if (this.upstream.get() != SubscriptionHelper.CANCELLED) {
                this.errors.add(new IllegalStateException("onSubscribe received multiple subscriptions: " + s15));
            }
            return;
        }
        this.downstream.onSubscribe(s15);
        long mr4 = this.missedRequested.getAndSet(0L);
        if (mr4 != 0L) {
            s15.request(mr4);
        }
        this.onStart();
    }

    protected void onStart() {
    }

    @Override
    public void onNext(@NonNull T t15) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        this.lastThread = Thread.currentThread();
        this.values.add(t15);
        if (t15 == null) {
            this.errors.add(new NullPointerException("onNext received a null value"));
        }
        this.downstream.onNext(t15);
    }

    @Override
    public void onError(@NonNull Throwable t15) {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            if (t15 == null) {
                this.errors.add(new NullPointerException("onError received a null Throwable"));
            } else {
                this.errors.add(t15);
            }
            this.downstream.onError(t15);
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public void onComplete() {
        if (!this.checkSubscriptionOnce) {
            this.checkSubscriptionOnce = true;
            if (this.upstream.get() == null) {
                this.errors.add(new IllegalStateException("onSubscribe not called in proper order"));
            }
        }
        try {
            this.lastThread = Thread.currentThread();
            ++this.completions;
            this.downstream.onComplete();
        }
        finally {
            this.done.countDown();
        }
    }

    @Override
    public final void request(long n15) {
        SubscriptionHelper.deferredRequest(this.upstream, this.missedRequested, n15);
    }

    @Override
    public final void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.upstream);
        }
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    protected final void dispose() {
        this.cancel();
    }

    @Override
    protected final boolean isDisposed() {
        return this.cancelled;
    }

    public final boolean hasSubscription() {
        return this.upstream.get() != null;
    }

    @Override
    protected final TestSubscriber<T> assertSubscribed() {
        if (this.upstream.get() == null) {
            throw this.fail("Not subscribed!");
        }
        return this;
    }

    public final TestSubscriber<T> requestMore(long n15) {
        this.request(n15);
        return this;
    }

    static enum EmptySubscriber implements FlowableSubscriber<Object>
    {
        INSTANCE;


        @Override
        public void onSubscribe(Subscription s15) {
        }

        @Override
        public void onNext(Object t15) {
        }

        @Override
        public void onError(Throwable t15) {
        }

        @Override
        public void onComplete() {
        }
    }
}

