/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeInfo;
import jadx.api.JadxDecompiler;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.JavaPackage;
import jadx.api.metadata.ICodeAnnotation;
import jadx.api.metadata.ICodeNodeRef;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.AnonymousClassAttr;
import jadx.core.dex.attributes.nodes.InlinedAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.ListUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaClass
implements JavaNode {
    private static final Logger LOG = LoggerFactory.getLogger(JavaClass.class);
    private final JadxDecompiler decompiler;
    private final ClassNode cls;
    private final JavaClass parent;
    private List<JavaClass> innerClasses = Collections.emptyList();
    private List<JavaClass> inlinedClasses = Collections.emptyList();
    private List<JavaField> fields = Collections.emptyList();
    private List<JavaMethod> methods = Collections.emptyList();
    private boolean listsLoaded;

    JavaClass(ClassNode classNode, JadxDecompiler decompiler) {
        this.decompiler = decompiler;
        this.cls = classNode;
        this.parent = null;
    }

    JavaClass(ClassNode classNode, JavaClass parent) {
        this.decompiler = null;
        this.cls = classNode;
        this.parent = parent;
    }

    public String getCode() {
        return this.getCodeInfo().getCodeStr();
    }

    @NotNull
    public ICodeInfo getCodeInfo() {
        ICodeInfo code = this.load();
        if (code != null) {
            return code;
        }
        return this.cls.decompile();
    }

    public void decompile() {
        this.load();
    }

    public synchronized ICodeInfo reload() {
        this.listsLoaded = false;
        return this.cls.reloadCode();
    }

    public void unload() {
        this.listsLoaded = false;
        this.cls.unloadCode();
    }

    public boolean isNoCode() {
        return this.cls.contains(AFlag.DONT_GENERATE);
    }

    public boolean isInner() {
        return this.cls.isInner();
    }

    public synchronized String getSmali() {
        return this.cls.getDisassembledCode();
    }

    @Override
    public boolean isOwnCodeAnnotation(ICodeAnnotation ann) {
        if (ann.getAnnType() == ICodeAnnotation.AnnType.CLASS) {
            return ann.equals(this.cls);
        }
        return false;
    }

    @Override
    public ICodeNodeRef getCodeNodeRef() {
        return this.cls;
    }

    @ApiStatus.Internal
    public ClassNode getClassNode() {
        return this.cls;
    }

    @Nullable
    private synchronized ICodeInfo load() {
        if (this.listsLoaded) {
            return null;
        }
        ICodeInfo code = this.cls.getState().isProcessComplete() ? null : this.cls.decompile();
        this.loadLists();
        return code;
    }

    private void loadLists() {
        int n15;
        int fieldsCount;
        int inlinedClsCount;
        this.listsLoaded = true;
        JadxDecompiler rootDecompiler = this.getRootDecompiler();
        int inClsCount = this.cls.getInnerClasses().size();
        if (inClsCount != 0) {
            ArrayList<JavaClass> list2 = new ArrayList<JavaClass>(inClsCount);
            for (ClassNode classNode : this.cls.getInnerClasses()) {
                if (classNode.contains(AFlag.DONT_GENERATE)) continue;
                JavaClass javaClass = rootDecompiler.convertClassNode(classNode);
                javaClass.loadLists();
                list2.add(javaClass);
            }
            this.innerClasses = Collections.unmodifiableList(list2);
        }
        if ((inlinedClsCount = this.cls.getInlinedClasses().size()) != 0) {
            ArrayList<JavaClass> list3 = new ArrayList<JavaClass>(inlinedClsCount);
            for (ClassNode classNode : this.cls.getInlinedClasses()) {
                JavaClass javaClass = rootDecompiler.convertClassNode(classNode);
                javaClass.loadLists();
                list3.add(javaClass);
            }
            this.inlinedClasses = Collections.unmodifiableList(list3);
        }
        if ((fieldsCount = this.cls.getFields().size()) != 0) {
            ArrayList<JavaField> arrayList = new ArrayList<JavaField>(fieldsCount);
            for (FieldNode f15 : this.cls.getFields()) {
                if (f15.contains(AFlag.DONT_GENERATE)) continue;
                arrayList.add(rootDecompiler.convertFieldNode(f15));
            }
            this.fields = Collections.unmodifiableList(arrayList);
        }
        if ((n15 = this.cls.getMethods().size()) != 0) {
            ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>(n15);
            for (MethodNode m15 : this.cls.getMethods()) {
                if (m15.contains(AFlag.DONT_GENERATE)) continue;
                arrayList.add(rootDecompiler.convertMethodNode(m15));
            }
            arrayList.sort(Comparator.comparing(JavaMethod::getName));
            this.methods = Collections.unmodifiableList(arrayList);
        }
    }

    JadxDecompiler getRootDecompiler() {
        if (this.parent != null) {
            return this.parent.getRootDecompiler();
        }
        return this.decompiler;
    }

    public ICodeAnnotation getAnnotationAt(int pos) {
        return this.getCodeInfo().getCodeMetadata().getAt(pos);
    }

    public Map<Integer, JavaNode> getUsageMap() {
        Map<Integer, ICodeAnnotation> map = this.getCodeInfo().getCodeMetadata().getAsMap();
        if (map.isEmpty() || this.decompiler == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, JavaNode> resultMap = new HashMap<Integer, JavaNode>(map.size());
        for (Map.Entry<Integer, ICodeAnnotation> entry : map.entrySet()) {
            JavaNode node;
            int codePosition = entry.getKey();
            ICodeAnnotation obj = entry.getValue();
            if (!(obj instanceof ICodeNodeRef) || (node = this.getRootDecompiler().getJavaNodeByRef((ICodeNodeRef)obj)) == null) continue;
            resultMap.put(codePosition, node);
        }
        return resultMap;
    }

    public List<Integer> getUsePlacesFor(ICodeInfo codeInfo, JavaNode javaNode) {
        if (!codeInfo.hasMetadata()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        codeInfo.getCodeMetadata().searchDown(0, (pos, ann) -> {
            if (javaNode.isOwnCodeAnnotation((ICodeAnnotation)ann)) {
                result.add((Integer)pos);
            }
            return null;
        });
        return result;
    }

    @Override
    public List<JavaNode> getUseIn() {
        return this.getRootDecompiler().convertNodes(this.cls.getUseIn());
    }

    public Integer getSourceLine(int decompiledLine) {
        return this.getCodeInfo().getCodeMetadata().getLineMapping().get(decompiledLine);
    }

    @Override
    public String getName() {
        return this.cls.getShortName();
    }

    @Override
    public String getFullName() {
        return this.cls.getFullName();
    }

    public String getRawName() {
        return this.cls.getRawName();
    }

    public String getPackage() {
        return this.cls.getPackage();
    }

    public JavaPackage getJavaPackage() {
        return this.cls.getPackageNode().getJavaNode();
    }

    @Override
    public JavaClass getDeclaringClass() {
        return this.parent;
    }

    public JavaClass getOriginalTopParentClass() {
        return this.parent == null ? this : this.parent.getOriginalTopParentClass();
    }

    @Override
    public JavaClass getTopParentClass() {
        JavaClass codeParent = this.getCodeParent();
        return codeParent == null ? this : codeParent.getTopParentClass();
    }

    @Nullable
    public JavaClass getCodeParent() {
        AnonymousClassAttr anonymousClsAttr = this.cls.get(AType.ANONYMOUS_CLASS);
        if (anonymousClsAttr != null) {
            return this.getRootDecompiler().convertClassNode(anonymousClsAttr.getOuterCls());
        }
        InlinedAttr inlinedAttr = this.cls.get(AType.INLINED);
        if (inlinedAttr != null) {
            return this.getRootDecompiler().convertClassNode(inlinedAttr.getInlineCls());
        }
        return this.parent;
    }

    public AccessInfo getAccessInfo() {
        return this.cls.getAccessFlags();
    }

    public List<JavaClass> getInnerClasses() {
        this.load();
        return this.innerClasses;
    }

    public List<JavaClass> getInlinedClasses() {
        this.load();
        return this.inlinedClasses;
    }

    public List<JavaField> getFields() {
        this.load();
        return this.fields;
    }

    public List<JavaMethod> getMethods() {
        this.load();
        return this.methods;
    }

    @Nullable
    public JavaMethod searchMethodByShortId(String shortId) {
        MethodNode methodNode = this.cls.searchMethodByShortId(shortId);
        if (methodNode == null) {
            return null;
        }
        return this.getRootDecompiler().convertMethodNode(methodNode);
    }

    public List<JavaClass> getDependencies() {
        JadxDecompiler d15 = this.getRootDecompiler();
        return ListUtils.map(this.cls.getDependencies(), d15::convertClassNode);
    }

    public int getTotalDepsCount() {
        return this.cls.getTotalDepsCount();
    }

    @Override
    public void removeAlias() {
        this.cls.removeAlias();
    }

    @Override
    public int getDefPos() {
        return this.cls.getDefPosition();
    }

    public boolean equals(Object o15) {
        return this == o15 || o15 instanceof JavaClass && this.cls.equals(((JavaClass)o15).cls);
    }

    public int hashCode() {
        return this.cls.hashCode();
    }

    public String toString() {
        return this.getFullName();
    }
}

