/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.instructions.ConstStringNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import org.jetbrains.annotations.NotNull;

public final class InsnWrapArg
extends InsnArg {
    private final InsnNode wrappedInsn;

    InsnWrapArg(@NotNull InsnNode insn) {
        RegisterArg result = insn.getResult();
        this.type = result != null ? result.getType() : ArgType.UNKNOWN;
        this.wrappedInsn = insn;
    }

    public InsnNode getWrapInsn() {
        return this.wrappedInsn;
    }

    public InsnNode unWrapWithCopy() {
        Object copy = this.wrappedInsn.copyWithoutResult();
        ((AttrNode)copy).remove(AFlag.WRAPPED);
        return copy;
    }

    @Override
    public void setParentInsn(InsnNode parentInsn) {
        if (parentInsn == this.wrappedInsn) {
            throw new JadxRuntimeException("Can't wrap instruction info itself: " + String.valueOf(parentInsn));
        }
        this.parentInsn = parentInsn;
    }

    @Override
    public InsnArg duplicate() {
        InsnWrapArg copy = new InsnWrapArg((InsnNode)this.wrappedInsn.copyWithoutResult());
        copy.setType(this.type);
        return this.copyCommonParams(copy);
    }

    @Override
    public boolean isInsnWrap() {
        return true;
    }

    public int hashCode() {
        return this.wrappedInsn.hashCode();
    }

    public boolean equals(Object o15) {
        if (this == o15) {
            return true;
        }
        if (!(o15 instanceof InsnWrapArg)) {
            return false;
        }
        InsnWrapArg that = (InsnWrapArg)o15;
        InsnNode thisInsn = this.wrappedInsn;
        InsnNode thatInsn = that.wrappedInsn;
        if (!thisInsn.isSame(thatInsn)) {
            return false;
        }
        int count = thisInsn.getArgsCount();
        for (int i15 = 0; i15 < count; ++i15) {
            if (thisInsn.getArg(i15).equals(thatInsn.getArg(i15))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toShortString() {
        if (this.wrappedInsn.getType() == InsnType.CONST_STR) {
            return "(\"" + ((ConstStringNode)this.wrappedInsn).getString() + "\")";
        }
        return "(wrap:" + String.valueOf(this.type) + ":" + String.valueOf((Object)this.wrappedInsn.getType()) + ")";
    }

    public String toString() {
        if (this.wrappedInsn.getType() == InsnType.CONST_STR) {
            return "(\"" + ((ConstStringNode)this.wrappedInsn).getString() + "\")";
        }
        return "(wrap:" + String.valueOf(this.type) + ":" + String.valueOf(this.wrappedInsn) + ")";
    }
}

