/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.ssa;

import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.MethodNode;
import java.util.Arrays;

final class RenameState {
    private final MethodNode mth;
    private final BlockNode block;
    private final SSAVar[] vars;
    private final int[] versions;

    public static RenameState init(MethodNode mth) {
        int regsCount = mth.getRegsCount();
        RenameState state = new RenameState(mth, mth.getEnterBlock(), new SSAVar[regsCount], new int[regsCount]);
        RegisterArg thisArg = mth.getThisArg();
        if (thisArg != null) {
            state.startVar(thisArg);
        }
        for (RegisterArg arg : mth.getArgRegs()) {
            state.startVar(arg);
        }
        return state;
    }

    public static RenameState copyFrom(RenameState state, BlockNode block) {
        return new RenameState(state.mth, block, Arrays.copyOf(state.vars, state.vars.length), state.versions);
    }

    private RenameState(MethodNode mth, BlockNode block, SSAVar[] vars, int[] versions) {
        this.mth = mth;
        this.block = block;
        this.vars = vars;
        this.versions = versions;
    }

    public BlockNode getBlock() {
        return this.block;
    }

    public SSAVar getVar(int regNum) {
        return this.vars[regNum];
    }

    public SSAVar startVar(RegisterArg regArg) {
        SSAVar ssaVar;
        int regNum;
        int n15 = regNum = regArg.getRegNum();
        int n16 = this.versions[n15];
        this.versions[n15] = n16 + 1;
        int version = n16;
        this.vars[regNum] = ssaVar = this.mth.makeNewSVar(regNum, version, regArg);
        return ssaVar;
    }
}

