/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.ui.SimpleMenuItem;
import java.nio.file.Path;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class JInputFile
extends JNode {
    private final Path filePath;

    public JInputFile(Path filePath) {
        this.filePath = Objects.requireNonNull(filePath);
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return JInputFile.buildInputFilePopupMenu(mainWindow, this.filePath);
    }

    public static JPopupMenu buildInputFilePopupMenu(MainWindow mainWindow, Path filePath) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new SimpleMenuItem(NLS.str("popup.add_files"), mainWindow::addFiles));
        menu.add(new SimpleMenuItem(NLS.str("popup.remove"), () -> mainWindow.removeInput(filePath)));
        menu.add(new SimpleMenuItem(NLS.str("popup.rename"), () -> mainWindow.renameInput(filePath)));
        return menu;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return Icons.FILE;
    }

    @Override
    public String makeString() {
        return this.filePath.getFileName().toString();
    }

    @Override
    public String getTooltip() {
        return this.filePath.normalize().toAbsolutePath().toString();
    }

    public int hashCode() {
        return this.filePath.hashCode();
    }

    public boolean equals(Object o15) {
        if (o15 == null || this.getClass() != o15.getClass()) {
            return false;
        }
        return ((JInputFile)o15).filePath.equals(this.filePath);
    }

    @Override
    public String toString() {
        return "JInputFile{" + String.valueOf(this.filePath) + "}";
    }
}

