/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.core.utils.files.FileUtils;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JInputFiles;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.plugins.TreeInputsHelper;
import java.nio.file.Path;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JInputs
extends JNode {
    private static final ImageIcon INPUTS_ICON = UiUtils.openSvgIcon("nodes/projectStructure");

    public JInputs(MainWindow mainWindow) {
        JadxProject project = mainWindow.getProject();
        List<Path> inputs = project.getFilePaths();
        List<Path> files = FileUtils.expandDirs(inputs);
        TreeInputsHelper inputsHelper = new TreeInputsHelper(mainWindow);
        inputsHelper.processInputs(files);
        this.add(new JInputFiles(inputsHelper.getSimpleFiles()));
        inputsHelper.getCustomNodes().forEach(this::add);
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public Icon getIcon() {
        return INPUTS_ICON;
    }

    @Override
    public String getID() {
        return "JInputs";
    }

    @Override
    public String makeString() {
        return NLS.str("tree.inputs_title");
    }
}

