/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.JavaNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.codearea.CodeLinkGenerator;
import jadx.gui.utils.JNodeCache;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MouseHoverHighlighter
extends MouseMotionAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MouseHoverHighlighter.class);
    private final CodeArea codeArea;
    private final CodeLinkGenerator codeLinkGenerator;
    private final SmartHighlightPainter highlighter;
    private Object tag;
    private int highlightedTokenOffset = -1;

    public MouseHoverHighlighter(CodeArea codeArea, CodeLinkGenerator codeLinkGenerator) {
        this.codeArea = codeArea;
        this.codeLinkGenerator = codeLinkGenerator;
        this.highlighter = new SmartHighlightPainter();
        this.loadSettings();
    }

    public void loadSettings() {
        this.highlighter.setPaint(this.codeArea.getMarkOccurrencesColor());
    }

    @Override
    public void mouseMoved(MouseEvent e15) {
        if (!this.addHighlight(e15)) {
            this.removeHighlight();
        }
    }

    private boolean addHighlight(MouseEvent e15) {
        if (e15.getModifiersEx() != 0) {
            return false;
        }
        Caret caret = this.codeArea.getCaret();
        if (caret.getDot() != caret.getMark()) {
            return false;
        }
        try {
            Token token = this.codeArea.viewToToken(e15.getPoint());
            if (token == null) {
                return false;
            }
            int tokenOffset = token.getOffset();
            if (tokenOffset == this.highlightedTokenOffset) {
                return true;
            }
            JavaNode nodeAtOffset = this.codeLinkGenerator.getNodeAtOffset(tokenOffset);
            if (nodeAtOffset == null) {
                return false;
            }
            this.removeHighlight();
            this.tag = this.codeArea.getHighlighter().addHighlight(tokenOffset, token.getEndOffset(), this.highlighter);
            this.highlightedTokenOffset = tokenOffset;
            this.updateToolTip(nodeAtOffset);
            return true;
        }
        catch (Exception exc) {
            LOG.error("Mouse hover highlight error", exc);
            return false;
        }
    }

    private void removeHighlight() {
        if (this.tag != null) {
            this.codeArea.getHighlighter().removeHighlight(this.tag);
            this.tag = null;
            this.highlightedTokenOffset = -1;
            this.updateToolTip(null);
        }
    }

    private void updateToolTip(JavaNode node) {
        MainWindow mainWindow = this.codeArea.getMainWindow();
        if (node == null || mainWindow.getSettings().isDisableTooltipOnHover()) {
            this.codeArea.setToolTipText(null);
            return;
        }
        JNodeCache nodeCache = mainWindow.getCacheObject().getNodeCache();
        JNode jNode = nodeCache.makeFrom(node);
        this.codeArea.setToolTipText(jNode.getTooltip());
    }
}

