/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.utils.CodeUtils;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.visitors.prepare.CollectConstValues;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.CodeNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.CommonSearchDialog;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.NodeLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class UsageDialog
extends CommonSearchDialog {
    private static final long serialVersionUID = -5105405789969134105L;
    private final transient JNode node;
    private transient List<CodeNode> usageList;

    public static void open(MainWindow mainWindow, JNode node) {
        UsageDialog usageDialog = new UsageDialog(mainWindow, node);
        mainWindow.addLoadListener(loaded -> {
            if (!loaded) {
                usageDialog.dispose();
                return true;
            }
            return false;
        });
        usageDialog.setVisible(true);
    }

    private UsageDialog(MainWindow mainWindow, JNode node) {
        super(mainWindow, NLS.str("usage_dialog.title"));
        this.node = node;
        this.initUI();
        this.registerInitOnOpen();
        this.loadWindowPos();
    }

    @Override
    protected void openInit() {
        this.progressStartCommon();
        this.prepareUsageData();
        this.mainWindow.getBackgroundExecutor().execute(NLS.str("progress.load"), this::collectUsageData, status -> {
            if (status == TaskStatus.CANCEL_BY_MEMORY) {
                this.mainWindow.showHeapUsageBar();
                UiUtils.errorMessage(this, NLS.str("message.memoryLow"));
            }
            this.progressFinishedCommon();
            this.loadFinished();
        });
    }

    private void prepareUsageData() {
        if (this.mainWindow.getSettings().isReplaceConsts() && this.node instanceof JField) {
            boolean constField;
            FieldNode fld = ((JField)this.node).getJavaField().getFieldNode();
            boolean bl4 = constField = CollectConstValues.getFieldConstValue(fld) != null;
            if (constField && !fld.getAccessFlags().isPrivate()) {
                this.mainWindow.requestFullDecompilation();
            }
        }
    }

    private void collectUsageData() {
        this.usageList = new ArrayList<CodeNode>();
        this.buildUsageQuery().forEach((searchNode, useNodes) -> useNodes.stream().map(JavaNode::getTopParentClass).distinct().forEach(u15 -> this.processUsage((JavaNode)searchNode, (JavaClass)u15)));
    }

    private Map<JavaNode, List<? extends JavaNode>> buildUsageQuery() {
        HashMap<JavaNode, List<? extends JavaNode>> map = new HashMap<JavaNode, List<? extends JavaNode>>();
        if (this.node instanceof JMethod) {
            JavaMethod javaMethod = ((JMethod)this.node).getJavaMethod();
            for (JavaMethod mth : this.getMethodWithOverrides(javaMethod)) {
                map.put(mth, mth.getUseIn());
            }
            return map;
        }
        if (this.node instanceof JClass) {
            JavaClass javaCls = ((JClass)this.node).getCls();
            map.put(javaCls, javaCls.getUseIn());
            for (JavaMethod javaMth : javaCls.getMethods()) {
                if (!javaMth.isConstructor()) continue;
                map.put(javaMth, javaMth.getUseIn());
            }
            return map;
        }
        if (this.node instanceof JField && this.mainWindow.getSettings().isReplaceConsts()) {
            boolean constField;
            FieldNode fld = ((JField)this.node).getJavaField().getFieldNode();
            boolean bl4 = constField = CollectConstValues.getFieldConstValue(fld) != null;
            if (constField && !fld.getAccessFlags().isPrivate()) {
                map.put(fld.getJavaNode(), this.mainWindow.getWrapper().getIncludedClasses());
                return map;
            }
        }
        JavaNode javaNode = this.node.getJavaNode();
        map.put(javaNode, javaNode.getUseIn());
        return map;
    }

    private List<JavaMethod> getMethodWithOverrides(JavaMethod javaMethod) {
        List<JavaMethod> relatedMethods = javaMethod.getOverrideRelatedMethods();
        if (!relatedMethods.isEmpty()) {
            return relatedMethods;
        }
        return Collections.singletonList(javaMethod);
    }

    private void processUsage(JavaNode searchNode, JavaClass topUseClass) {
        ICodeInfo codeInfo = topUseClass.getCodeInfo();
        List<Integer> usePositions = topUseClass.getUsePlacesFor(codeInfo, searchNode);
        if (usePositions.isEmpty()) {
            return;
        }
        String code = codeInfo.getCodeStr();
        JadxWrapper wrapper = this.mainWindow.getWrapper();
        for (int pos : usePositions) {
            String line = CodeUtils.getLineForPos(code, pos);
            if (line.startsWith("import ")) continue;
            JNodeCache nodeCache = this.getNodeCache();
            JavaNode enclosingNode = wrapper.getEnclosingNode(codeInfo, pos);
            JClass rootJCls = nodeCache.makeFrom(topUseClass);
            JClass usageJNode = enclosingNode == null ? rootJCls : nodeCache.makeFrom(enclosingNode);
            this.usageList.add(new CodeNode(rootJCls, usageJNode, line.trim(), pos));
        }
    }

    @Override
    protected void loadFinished() {
        this.resultsTable.setEnabled(true);
        this.resultsModel.clear();
        Collections.sort(this.usageList);
        this.resultsModel.addAll(this.usageList);
        this.updateHighlightContext(this.node.getName(), true, false, true);
        this.resultsTable.initColumnWidth();
        this.resultsTable.updateTable();
        this.updateProgressLabel(true);
    }

    @Override
    protected void loadStart() {
        this.resultsTable.setEnabled(false);
    }

    private void initUI() {
        JadxSettings settings = this.mainWindow.getSettings();
        Font codeFont = settings.getCodeFont();
        JLabel lbl = new JLabel(NLS.str("usage_dialog.label"));
        lbl.setFont(codeFont);
        NodeLabel nodeLabel = NodeLabel.longName(this.node);
        nodeLabel.setFont(codeFont);
        lbl.setLabelFor(nodeLabel);
        JPanel searchPane = new JPanel();
        searchPane.setLayout(new FlowLayout(0));
        searchPane.add(lbl);
        searchPane.add(nodeLabel);
        searchPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.initCommon();
        JPanel resultsPanel = this.initResultsTable();
        JPanel buttonPane = this.initButtonsPanel();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)searchPane, "First");
        contentPanel.add((Component)resultsPanel, "Center");
        contentPanel.add((Component)buttonPane, "Last");
        this.getContentPane().add(contentPanel);
        this.pack();
        this.setSize(800, 500);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }
}

