/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.panel;

import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.ui.ZoomActions;
import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

public final class HtmlPanel
extends ContentPanel {
    private static final long serialVersionUID = -6251262855835426245L;
    private final JHtmlPane textArea;

    public HtmlPanel(TabbedPane panel, JNode jnode) {
        super(panel, jnode);
        this.setLayout(new BorderLayout());
        this.textArea = new JHtmlPane();
        this.loadSettings();
        this.loadContent(jnode);
        this.textArea.setEditable(false);
        JScrollPane sp4 = new JScrollPane(this.textArea);
        this.add(sp4);
        ZoomActions.register(this.textArea, panel.getMainWindow().getSettings(), this::loadSettings);
    }

    @Override
    public void loadSettings() {
        JadxSettings settings = this.getMainWindow().getSettings();
        this.textArea.setFont(settings.getUiFont());
    }

    public void loadContent(JNode jnode) {
        this.textArea.setText(jnode.getCodeInfo().getCodeStr());
        this.textArea.setCaretPosition(0);
    }

    public JEditorPane getHtmlArea() {
        return this.textArea;
    }

    private static final class JHtmlPane
    extends JEditorPane {
        private static final long serialVersionUID = 6886040384052136157L;

        public JHtmlPane() {
            this.setContentType("text/html");
        }

        @Override
        public void paint(Graphics g15) {
            Graphics2D g2d = (Graphics2D)g15.create();
            try {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paint(g2d);
            }
            finally {
                g2d.dispose();
            }
        }
    }
}

