/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.tab.QuickTabsBaseNode;
import jadx.gui.ui.tab.QuickTabsBookmarkParentNode;
import jadx.gui.ui.tab.QuickTabsPinParentNode;
import jadx.gui.utils.NLS;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class QuickTabsChildNode
extends QuickTabsBaseNode {
    private final JNode node;

    public QuickTabsChildNode(JNode node) {
        this.node = node;
    }

    @Override
    public String toString() {
        return this.node.toString();
    }

    public JNode getJNode() {
        return this.node;
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        JPopupMenu menu = this.node.onTreePopupMenu(mainWindow);
        if (this.node.supportsQuickTabs()) {
            if (this.getParent() instanceof QuickTabsPinParentNode) {
                if (menu == null) {
                    menu = new JPopupMenu();
                }
                JMenuItem closeAction = new JMenuItem(NLS.str("tabs.close"));
                closeAction.addActionListener(e15 -> mainWindow.getTabsController().closeTab(this.node, true));
                menu.add((Component)closeAction, 0);
                menu.add((Component)new JPopupMenu.Separator(), 1);
            }
            if (this.getParent() instanceof QuickTabsPinParentNode) {
                if (menu == null) {
                    menu = new JPopupMenu();
                }
                JMenuItem unpinAction = new JMenuItem(NLS.str("tabs.unpin"));
                unpinAction.addActionListener(e15 -> mainWindow.getTabsController().setTabPinned(this.node, false));
                menu.add((Component)unpinAction, 0);
                menu.add((Component)new JPopupMenu.Separator(), 1);
            }
            if (this.getParent() instanceof QuickTabsBookmarkParentNode) {
                if (menu == null) {
                    menu = new JPopupMenu();
                }
                JMenuItem unbookmarkAction = new JMenuItem(NLS.str("tabs.unbookmark"));
                unbookmarkAction.addActionListener(e15 -> mainWindow.getTabsController().setTabBookmarked(this.node, false));
                menu.add((Component)unbookmarkAction, 0);
                menu.add((Component)new JPopupMenu.Separator(), 1);
            }
        }
        return menu;
    }

    @Override
    Icon getIcon() {
        return this.node.getIcon();
    }
}

