/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.dex.sections;

import jadx.api.plugins.input.data.ICodeReader;
import jadx.api.plugins.input.data.IMethodData;
import jadx.api.plugins.input.data.annotations.IAnnotation;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.types.AnnotationMethodParamsAttr;
import jadx.api.plugins.utils.Utils;
import jadx.plugins.input.dex.sections.DexAnnotationsConvert;
import jadx.plugins.input.dex.sections.DexCodeReader;
import jadx.plugins.input.dex.sections.DexMethodRef;
import jadx.plugins.input.dex.sections.annotations.AnnotationsParser;
import jadx.plugins.input.dex.smali.SmaliPrinter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DexMethodData
implements IMethodData {
    @Nullable
    private final AnnotationsParser annotationsParser;
    private DexMethodRef methodRef;
    private int accessFlags;
    private int annotationsOffset;
    private int paramAnnotationsOffset;
    @Nullable
    private DexCodeReader codeReader;

    public DexMethodData(@Nullable AnnotationsParser annotationsParser) {
        this.annotationsParser = annotationsParser;
    }

    @Override
    public DexMethodRef getMethodRef() {
        return this.methodRef;
    }

    public void setMethodRef(DexMethodRef methodRef) {
        this.methodRef = methodRef;
    }

    @Override
    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    @Override
    @Nullable
    public ICodeReader getCodeReader() {
        return this.codeReader;
    }

    public void setCodeReader(@Nullable DexCodeReader codeReader) {
        this.codeReader = codeReader;
    }

    @Override
    public String disassembleMethod() {
        return SmaliPrinter.printMethod(this);
    }

    public void setAnnotationsOffset(int annotationsOffset) {
        this.annotationsOffset = annotationsOffset;
    }

    public void setParamAnnotationsOffset(int paramAnnotationsOffset) {
        this.paramAnnotationsOffset = paramAnnotationsOffset;
    }

    private List<IAnnotation> getAnnotations() {
        return this.getAnnotationsParser().readAnnotationList(this.annotationsOffset);
    }

    private List<List<IAnnotation>> getParamsAnnotations() {
        return this.getAnnotationsParser().readAnnotationRefList(this.paramAnnotationsOffset);
    }

    @Override
    public List<IJadxAttribute> getAttributes() {
        ArrayList<IJadxAttribute> list2 = new ArrayList<IJadxAttribute>();
        DexAnnotationsConvert.forMethod(list2, this.getAnnotations());
        Utils.addToList(list2, AnnotationMethodParamsAttr.pack(this.getParamsAnnotations()));
        return list2;
    }

    private AnnotationsParser getAnnotationsParser() {
        if (this.annotationsParser == null) {
            throw new NullPointerException("Annotation parser not initialized");
        }
        return this.annotationsParser;
    }

    public String toString() {
        return this.getMethodRef().toString();
    }
}

