/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.attributes.debuginfo;

import jadx.plugins.input.java.data.ConstPoolReader;
import jadx.plugins.input.java.data.attributes.IJavaAttribute;
import jadx.plugins.input.java.data.attributes.IJavaAttributeReader;
import jadx.plugins.input.java.data.attributes.debuginfo.JavaLocalVar;
import java.util.ArrayList;
import java.util.List;

public class LocalVarTypesAttr
implements IJavaAttribute {
    private final List<JavaLocalVar> vars;

    public LocalVarTypesAttr(List<JavaLocalVar> vars) {
        this.vars = vars;
    }

    public List<JavaLocalVar> getVars() {
        return this.vars;
    }

    public static IJavaAttributeReader reader() {
        return (clsData, reader) -> {
            ConstPoolReader constPool = clsData.getConstPoolReader();
            int len = reader.readU2();
            ArrayList<JavaLocalVar> varsList = new ArrayList<JavaLocalVar>(len);
            for (int i15 = 0; i15 < len; ++i15) {
                int startOffset = reader.readU2();
                int endOffset = startOffset + reader.readU2() - 1;
                int nameIdx = reader.readU2();
                int typeIdx = reader.readU2();
                int varNum = reader.readU2();
                varsList.add(new JavaLocalVar(varNum, constPool.getUtf8(nameIdx), null, constPool.getUtf8(typeIdx), startOffset, endOffset));
            }
            return new LocalVarTypesAttr(varsList);
        };
    }
}

