/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data.code;

import jadx.api.plugins.input.data.ICallSite;
import jadx.api.plugins.input.data.IFieldRef;
import jadx.api.plugins.input.data.IMethodHandle;
import jadx.api.plugins.input.data.IMethodProto;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.input.insns.InsnData;
import jadx.api.plugins.input.insns.InsnIndexType;
import jadx.api.plugins.input.insns.Opcode;
import jadx.api.plugins.input.insns.custom.ICustomPayload;
import jadx.plugins.input.java.data.ConstPoolReader;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.code.ArrayType;
import jadx.plugins.input.java.data.code.CodeDecodeState;
import jadx.plugins.input.java.data.code.JavaInsnInfo;
import jadx.plugins.input.java.data.code.decoders.IJavaInsnDecoder;
import org.jetbrains.annotations.Nullable;

public class JavaInsnData
implements InsnData {
    private final CodeDecodeState state;
    private JavaInsnInfo insnInfo;
    private Opcode opcode;
    private boolean decoded;
    private int opcodeUnit;
    private int payloadSize;
    private int insnStart;
    private int offset;
    private int regsCount;
    private int[] argsReg = new int[16];
    private int resultReg;
    private long literal;
    private int target;
    private int index;
    @Nullable
    private ICustomPayload payload;

    public JavaInsnData(CodeDecodeState state) {
        this.state = state;
    }

    @Override
    public void decode() {
        IJavaInsnDecoder decoder = this.insnInfo.getDecoder();
        if (decoder != null) {
            decoder.decode(this.state);
            this.state.decoded();
        }
        this.decoded = true;
    }

    public void skip() {
        IJavaInsnDecoder decoder = this.insnInfo.getDecoder();
        if (decoder != null) {
            decoder.skip(this.state);
        }
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getFileOffset() {
        return this.insnStart;
    }

    @Override
    public Opcode getOpcode() {
        return this.opcode;
    }

    public void setOpcode(Opcode opcode) {
        this.opcode = opcode;
    }

    @Override
    public String getOpcodeMnemonic() {
        return this.insnInfo.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getByteCode() {
        DataReader reader = this.state.reader();
        int startOffset = reader.getOffset();
        try {
            reader.absPos(this.insnStart);
            byte[] byArray = reader.readBytes(1 + this.payloadSize);
            return byArray;
        }
        finally {
            reader.absPos(startOffset);
        }
    }

    @Override
    public InsnIndexType getIndexType() {
        return this.insnInfo.getIndexType();
    }

    @Override
    public int getRawOpcodeUnit() {
        return this.opcodeUnit;
    }

    @Override
    public int getRegsCount() {
        return this.regsCount;
    }

    @Override
    public int getReg(int argNum) {
        return this.argsReg[argNum];
    }

    @Override
    public int getResultReg() {
        return this.resultReg;
    }

    public void setResultReg(int resultReg) {
        this.resultReg = resultReg;
    }

    @Override
    public long getLiteral() {
        return this.literal;
    }

    @Override
    public int getTarget() {
        return this.target;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public int getPayloadSize() {
        return this.payloadSize;
    }

    @Override
    public String getIndexAsString() {
        return this.constPoolReader().getUtf8(this.index);
    }

    @Override
    public String getIndexAsType() {
        if (this.insnInfo.getOpcode() == 188) {
            return ArrayType.byValue(this.index);
        }
        return this.constPoolReader().getClass(this.index);
    }

    @Override
    public IFieldRef getIndexAsField() {
        return this.constPoolReader().getFieldRef(this.index);
    }

    @Override
    public IMethodRef getIndexAsMethod() {
        return this.constPoolReader().getMethodRef(this.index);
    }

    @Override
    public ICallSite getIndexAsCallSite() {
        return this.constPoolReader().getCallSite(this.index);
    }

    @Override
    public IMethodProto getIndexAsProto(int protoIndex) {
        return null;
    }

    @Override
    public IMethodHandle getIndexAsMethodHandle() {
        return null;
    }

    @Override
    @Nullable
    public ICustomPayload getPayload() {
        return this.payload;
    }

    public void setInsnInfo(JavaInsnInfo insnInfo) {
        this.insnInfo = insnInfo;
    }

    public boolean isDecoded() {
        return this.decoded;
    }

    public void setDecoded(boolean decoded) {
        this.decoded = decoded;
    }

    public void setOpcodeUnit(int opcodeUnit) {
        this.opcodeUnit = opcodeUnit;
    }

    public void setPayloadSize(int payloadSize) {
        this.payloadSize = payloadSize;
    }

    public void setInsnStart(int insnStart) {
        this.insnStart = insnStart;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setArgReg(int arg, int reg) {
        this.argsReg[arg] = reg;
    }

    public void setRegsCount(int regsCount) {
        this.regsCount = regsCount;
        if (this.argsReg.length < regsCount) {
            this.argsReg = new int[regsCount];
        }
    }

    public int[] getRegsArray() {
        return this.argsReg;
    }

    public void setLiteral(long literal) {
        this.literal = literal;
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setPayload(ICustomPayload payload) {
        this.payload = payload;
    }

    public ConstPoolReader constPoolReader() {
        return this.state.clsData().getConstPoolReader();
    }

    public String toString() {
        StringBuilder sb5 = new StringBuilder();
        sb5.append(String.format("0x%04X", this.offset));
        sb5.append(": ").append((Object)this.getOpcode());
        if (this.insnInfo == null) {
            sb5.append(String.format("(0x%04X)", this.opcodeUnit));
        } else {
            int regsCount = this.getRegsCount();
            if (this.isDecoded()) {
                sb5.append(' ');
                for (int i15 = 0; i15 < regsCount; ++i15) {
                    if (i15 != 0) {
                        sb5.append(", ");
                    }
                    sb5.append("r").append(this.argsReg[i15]);
                }
            }
        }
        return sb5.toString();
    }
}

