/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.diff;

import org.apache.commons.text.diff.DeleteCommand;
import org.apache.commons.text.diff.EditScript;
import org.apache.commons.text.diff.InsertCommand;
import org.apache.commons.text.diff.KeepCommand;

public class StringsComparator {
    private final String left;
    private final String right;
    private final int[] vDown;
    private final int[] vUp;

    public StringsComparator(String left, String right) {
        this.left = left;
        this.right = right;
        int size = left.length() + right.length() + 2;
        this.vDown = new int[size];
        this.vUp = new int[size];
    }

    private void buildScript(int start1, int end1, int start2, int end2, EditScript<Character> script) {
        Snake middle = this.getMiddleSnake(start1, end1, start2, end2);
        if (middle == null || middle.getStart() == end1 && middle.getDiag() == end1 - end2 || middle.getEnd() == start1 && middle.getDiag() == start1 - start2) {
            int i15 = start1;
            int j15 = start2;
            while (i15 < end1 || j15 < end2) {
                if (i15 < end1 && j15 < end2 && this.left.charAt(i15) == this.right.charAt(j15)) {
                    script.append(new KeepCommand<Character>(Character.valueOf(this.left.charAt(i15))));
                    ++i15;
                    ++j15;
                    continue;
                }
                if (end1 - start1 > end2 - start2) {
                    script.append(new DeleteCommand<Character>(Character.valueOf(this.left.charAt(i15))));
                    ++i15;
                    continue;
                }
                script.append(new InsertCommand<Character>(Character.valueOf(this.right.charAt(j15))));
                ++j15;
            }
        } else {
            this.buildScript(start1, middle.getStart(), start2, middle.getStart() - middle.getDiag(), script);
            for (int i16 = middle.getStart(); i16 < middle.getEnd(); ++i16) {
                script.append(new KeepCommand<Character>(Character.valueOf(this.left.charAt(i16))));
            }
            this.buildScript(middle.getEnd(), end1, middle.getEnd() - middle.getDiag(), end2, script);
        }
    }

    private Snake buildSnake(int start, int diag, int end1, int end2) {
        int end;
        for (end = start; end - diag < end2 && end < end1 && this.left.charAt(end) == this.right.charAt(end - diag); ++end) {
        }
        return new Snake(start, end, diag);
    }

    private Snake getMiddleSnake(int start1, int end1, int start2, int end2) {
        int m15 = end1 - start1;
        int n15 = end2 - start2;
        if (m15 == 0 || n15 == 0) {
            return null;
        }
        int delta = m15 - n15;
        int sum = n15 + m15;
        int offset = (sum % 2 == 0 ? sum : sum + 1) / 2;
        this.vDown[1 + offset] = start1;
        this.vUp[1 + offset] = end1 + 1;
        for (int d15 = 0; d15 <= offset; ++d15) {
            int y15;
            int x15;
            int i15;
            int k15;
            for (k15 = -d15; k15 <= d15; k15 += 2) {
                i15 = k15 + offset;
                this.vDown[i15] = k15 == -d15 || k15 != d15 && this.vDown[i15 - 1] < this.vDown[i15 + 1] ? this.vDown[i15 + 1] : this.vDown[i15 - 1] + 1;
                x15 = this.vDown[i15];
                for (y15 = x15 - start1 + start2 - k15; x15 < end1 && y15 < end2 && this.left.charAt(x15) == this.right.charAt(y15); ++y15) {
                    this.vDown[i15] = ++x15;
                }
                if (delta % 2 == 0 || delta - d15 > k15 || k15 > delta + d15 || this.vUp[i15 - delta] > this.vDown[i15]) continue;
                return this.buildSnake(this.vUp[i15 - delta], k15 + start1 - start2, end1, end2);
            }
            for (k15 = delta - d15; k15 <= delta + d15; k15 += 2) {
                i15 = k15 + offset - delta;
                this.vUp[i15] = k15 == delta - d15 || k15 != delta + d15 && this.vUp[i15 + 1] <= this.vUp[i15 - 1] ? this.vUp[i15 + 1] - 1 : this.vUp[i15 - 1];
                x15 = this.vUp[i15] - 1;
                for (y15 = x15 - start1 + start2 - k15; x15 >= start1 && y15 >= start2 && this.left.charAt(x15) == this.right.charAt(y15); --y15) {
                    this.vUp[i15] = x15--;
                }
                if (delta % 2 != 0 || -d15 > k15 || k15 > d15 || this.vUp[i15] > this.vDown[i15 + delta]) continue;
                return this.buildSnake(this.vUp[i15], k15 + start1 - start2, end1, end2);
            }
        }
        throw new IllegalStateException("Internal Error");
    }

    public EditScript<Character> getScript() {
        EditScript<Character> script = new EditScript<Character>();
        this.buildScript(0, this.left.length(), 0, this.right.length(), script);
        return script;
    }

    private static final class Snake {
        private final int start;
        private final int end;
        private final int diag;

        Snake(int start, int end, int diag) {
            this.start = start;
            this.end = end;
            this.diag = diag;
        }

        public int getDiag() {
            return this.diag;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }
    }
}

