/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Perform a cyclic spatial shift of image intensities on the image grid.


This filter supports arbitrary cyclic shifts of pixel values on the
image grid. If the Shift is set to [xOff, yOff], the value of the
pixel at [0, 0] in the input image will be the value of the pixel in
the output image at index [xOff modulo xSize, yOff modulo ySize] where
xSize and ySize are the sizes of the image in the x and y dimensions,
respectively. If a pixel value is moved across a boundary, the pixel
value is wrapped around that boundary. For example, if the image is
40-by-40 and the Shift is [13, 47], then the value of the pixel at [0,
0] in the input image will be the value of the pixel in the output
image at index [13, 7].

Negative Shifts are supported. This filter also works with images
whose largest possible region starts at a non-zero index.
See:
 itk::simple::CyclicShift for the procedural interface

 itk::CyclicShiftImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkCyclicShiftImageFilter.h
*/
public class CyclicShiftImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected CyclicShiftImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.CyclicShiftImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CyclicShiftImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(CyclicShiftImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::CyclicShiftImageFilter::~CyclicShiftImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_CyclicShiftImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::CyclicShiftImageFilter::CyclicShiftImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  CyclicShiftImageFilter() {
    this(SimpleITKJNI.new_CyclicShiftImageFilter(), true);
  }

  /**
Self&amp; itk::simple::CyclicShiftImageFilter::SetShift(std::vector&lt; int &gt; Shift)

Set/get the shift. Shifts may be positive or negative.

*/
public  void setShift(VectorInt32 Shift) {
    SimpleITKJNI.CyclicShiftImageFilter_setShift__SWIG_0(swigCPtr, this, VectorInt32.getCPtr(Shift), Shift);
  }

  /**
Self&amp; itk::simple::CyclicShiftImageFilter::SetShift(std::vector&lt; int &gt; Shift)

Set/get the shift. Shifts may be positive or negative.

*/
public  void setShift(int value) {
    SimpleITKJNI.CyclicShiftImageFilter_setShift__SWIG_1(swigCPtr, this, value);
  }

  /**
std::vector&lt;int&gt; itk::simple::CyclicShiftImageFilter::GetShift() const

Set/get the shift. Shifts may be positive or negative.

*/
public  VectorInt32 getShift() {
    return new VectorInt32(SimpleITKJNI.CyclicShiftImageFilter_getShift(swigCPtr, this), true);
  }

  /**
std::string itk::simple::CyclicShiftImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.CyclicShiftImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::CyclicShiftImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.CyclicShiftImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::CyclicShiftImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.CyclicShiftImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
