/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.PeakInfo;
import jspecview.common.Spectrum;
import jspecview.source.JDXSource;
import org.jmol.util.Logger;

public class SyncManager {
    private static String testScript = "<PeakData  index=\"1\" title=\"\" model=\"~1.1\" type=\"1HNMR\" xMin=\"3.2915\" xMax=\"3.2965\" atoms=\"15,16,17,18,19,20\" multiplicity=\"\" integral=\"1\"> src=\"JPECVIEW\" file=\"http://SIMULATION/$caffeine\"";

    static void syncToJmol(JSViewer vwr, PeakInfo pi) {
        vwr.peakInfoModelSentToJmol = pi.getModel();
        vwr.si.syncToJmol(SyncManager.jmolSelect(vwr.pd(), pi));
    }

    public static void syncFromJmol(JSViewer vwr, String peakScript) {
        String atomKey;
        String type;
        String jmolSource;
        String model;
        String index;
        String file;
        if (peakScript.equals("TEST")) {
            peakScript = testScript;
        }
        if (peakScript.indexOf("<PeakData") < 0) {
            if (peakScript.startsWith("JSVSTR:")) {
                vwr.si.syncToJmol(peakScript);
                return;
            }
            vwr.runScriptNow(peakScript);
            if (peakScript.indexOf("#SYNC_PEAKS") >= 0) {
                SyncManager.syncToJmolPeaksAfterSyncScript(vwr);
            }
            return;
        }
        String sourceID = PT.getQuotedAttribute(peakScript, "sourceID");
        if (sourceID == null) {
            String modelSent;
            file = PT.getQuotedAttribute(peakScript, "file");
            index = PT.getQuotedAttribute(peakScript, "index");
            if (file == null || index == null) {
                return;
            }
            file = PT.rep(file, "#molfile", "");
            model = PT.getQuotedAttribute(peakScript, "model");
            jmolSource = PT.getQuotedAttribute(peakScript, "src");
            String string = modelSent = jmolSource != null && jmolSource.startsWith("Jmol") ? null : vwr.peakInfoModelSentToJmol;
            if (model != null && modelSent != null && !model.equals(modelSent)) {
                Logger.info("JSV ignoring model " + model + "; should be " + modelSent);
                return;
            }
            vwr.peakInfoModelSentToJmol = null;
            if (vwr.panelNodes.size() == 0 || !vwr.checkFileAlreadyLoaded(file)) {
                Logger.info("file " + file + " not found -- JSViewer closing all and reopening");
                vwr.si.siSyncLoad(file);
            }
            type = PT.getQuotedAttribute(peakScript, "type");
            atomKey = null;
        } else {
            file = null;
            index = model = sourceID;
            atomKey = "," + PT.getQuotedAttribute(peakScript, "atom") + ",";
            type = "ID";
            jmolSource = sourceID;
        }
        PeakInfo pi = SyncManager.selectPanelByPeak(vwr, file, index, atomKey);
        PanelData pd = vwr.pd();
        pd.selectSpectrum(file, type, model, true);
        vwr.si.siSendPanelChange();
        pd.addPeakHighlight(pi);
        vwr.repaint(true);
        if (jmolSource == null || pi != null && pi.getAtoms() != null) {
            vwr.si.syncToJmol(SyncManager.jmolSelect(vwr.pd(), pi));
        }
    }

    private static void syncToJmolPeaksAfterSyncScript(JSViewer vwr) {
        JDXSource source = vwr.currentSource;
        if (source == null) {
            return;
        }
        try {
            String file = "file=" + PT.esc(source.getFilePath());
            Lst<Spectrum> spectra = source.getSpectra();
            Lst<PeakInfo> peaks = ((Spectrum)spectra.get(spectra.size() - 1)).getPeakList();
            SB sb = new SB();
            sb.append("[");
            int n = peaks.size();
            for (int i = 0; i < n; ++i) {
                String s = ((PeakInfo)peaks.get(i)).toString();
                s = s + " " + file;
                sb.append(PT.esc(s));
                if (i <= 0) continue;
                sb.append(",");
            }
            sb.append("]");
            vwr.si.syncToJmol("Peaks: " + sb);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static PeakInfo selectPanelByPeak(JSViewer vwr, String file, String index, String atomKey) {
        Lst<PanelNode> panelNodes = vwr.panelNodes;
        if (panelNodes == null) {
            return null;
        }
        PeakInfo pi = null;
        int i = panelNodes.size();
        while (--i >= 0) {
            ((PanelNode)panelNodes.get(i)).pd().addPeakHighlight(null);
        }
        pi = vwr.pd().selectPeakByFileIndex(file, index, atomKey);
        if (pi != null) {
            vwr.setNode(PanelNode.findNode(vwr.selectedPanel, panelNodes));
        } else {
            i = panelNodes.size();
            while (--i >= 0) {
                PanelNode node = (PanelNode)panelNodes.get(i);
                pi = node.pd().selectPeakByFileIndex(file, index, atomKey);
                if (pi == null) continue;
                vwr.setNode(node);
                break;
            }
        }
        return pi;
    }

    private static String jmolSelect(PanelData pd, PeakInfo pi) {
        String script = "IR".equals(pi.getType()) || "RAMAN".equals(pi.getType()) ? "vibration ON; selectionHalos OFF;" : "vibration OFF; selectionhalos " + (pi.getAtoms() == null ? "OFF" : "ON");
        return "Select: " + pi + " script=\"" + script + " \" sourceID=\"" + pd.getSpectrum().sourceID + "\"";
    }
}

