/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.UIManager;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.data.preferences.sources.MapPaintPrefHelper;
import org.openstreetmap.josm.data.preferences.sources.PresetPrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.bugreport.DebugTextDisplay;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformHookUnixoid;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportSender;

public final class ShowStatusReportAction
extends JosmAction {
    public static final String ACTION_DESCRIPTION = I18n.tr("Show status report with useful information that can be attached to bugs", new Object[0]);

    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report", new Object[0]), "misc/statusreport", ACTION_DESCRIPTION, Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report", new Object[0])), 65535, 5000), true, "help/showstatusreport", false);
        this.setHelpId(HelpUtil.ht("/Action/ShowStatusReport"));
    }

    public static String getReportHeader() {
        DataSet dataset;
        StringWriter stringWriter = new StringWriter(256);
        PrintWriter text = new PrintWriter(stringWriter);
        String runtimeVersion = Utils.getSystemProperty("java.runtime.version");
        text.println(Version.getInstance().getReleaseAttributes());
        text.format("Identification: %s%n", Version.getInstance().getAgentString());
        String buildNumber = PlatformManager.getPlatform().getOSBuildNumber();
        if (!buildNumber.isEmpty()) {
            text.format("OS Build number: %s%n", buildNumber);
        }
        text.format(Locale.ROOT, "Memory Usage: %d MB / %d MB (%d MB allocated, but free)%n", Runtime.getRuntime().totalMemory() / 1024L / 1024L, Runtime.getRuntime().maxMemory() / 1024L / 1024L, Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        text.format("Java version: %s, %s, %s%n", runtimeVersion != null ? runtimeVersion : Utils.getSystemProperty("java.version"), Utils.getSystemProperty("java.vendor"), Utils.getSystemProperty("java.vm.name"));
        text.format("Look and Feel: %s%n", Optional.ofNullable(UIManager.getLookAndFeel()).map(laf -> laf.getClass().getName()).orElse("null"));
        if (!GraphicsEnvironment.isHeadless()) {
            text.append("Screen:");
            for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                text.append(" ").append(graphicsDevice.getIDstring());
                DisplayMode dm = graphicsDevice.getDisplayMode();
                if (dm == null) continue;
                AffineTransform transform = graphicsDevice.getDefaultConfiguration().getDefaultTransform();
                text.format(Locale.ROOT, " %s (scaling %.2f\u00d7%.2f)", dm, transform.getScaleX(), transform.getScaleY());
            }
            text.println();
        }
        text.format("Maximum Screen Size: %s%n", ShowStatusReportAction.toString(GuiHelper.getMaximumScreenSize()));
        if (!GraphicsEnvironment.isHeadless()) {
            Iterator<String> bestCursorSize16 = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
            Dimension bestCursorSize32 = Toolkit.getDefaultToolkit().getBestCursorSize(32, 32);
            text.format("Best cursor sizes: %s\u2192%s, %s\u2192%s%n", ShowStatusReportAction.toString(new Dimension(16, 16)), ShowStatusReportAction.toString((Dimension)((Object)bestCursorSize16)), ShowStatusReportAction.toString(new Dimension(32, 32)), ShowStatusReportAction.toString(bestCursorSize32));
        }
        for (String name : Arrays.asList("LANG", "LC_ALL")) {
            String value = Utils.getSystemEnv(name);
            if (value == null) continue;
            text.format("Environment variable %s: %s%n", name, value);
        }
        for (String name : Arrays.asList("file.encoding", "sun.jnu.encoding")) {
            String value = Utils.getSystemProperty(name);
            if (value == null) continue;
            text.format("System property %s: %s%n", name, value);
        }
        text.format("Locale info: %s%n", Locale.getDefault().toString());
        text.format("Numbers with default locale: %s -> %d%n", Integer.toString(1234567890), 1234567890);
        if (PlatformManager.isPlatformUnixoid()) {
            String atkWrapperDetails;
            String webStartDetails;
            PlatformHookUnixoid platform = (PlatformHookUnixoid)PlatformManager.getPlatform();
            platform.getDesktopEnvironment().ifPresent(desktop -> text.format("Desktop environment: %s%n", desktop));
            String packageDetails = platform.getJavaPackageDetails();
            if (packageDetails != null) {
                text.format("Java package: %s%n", packageDetails);
            }
            if (Utils.isRunningWebStart() && (webStartDetails = platform.getWebStartPackageDetails()) != null) {
                text.format("WebStart package: %s%n", webStartDetails);
            }
            if ((atkWrapperDetails = platform.getAtkWrapperPackageDetails()) != null) {
                text.format("Java ATK Wrapper package: %s%n", atkWrapperDetails);
            }
            for (String p : new String[]{"apache-commons-compress", "libcommons-compress-java", "apache-commons-jcs-core", "apache-commons-logging", "libcommons-logging-java", "fonts-noto", "jsonp", "metadata-extractor2", "signpost-core", "liboauth-signpost-java", "svgsalamander"}) {
                String details = PlatformHookUnixoid.getPackageDetails(p);
                if (details == null) continue;
                text.format("%s: %s%n", p, details);
            }
        }
        try {
            ArrayList<String> vmArguments = new ArrayList<String>(ManagementFactory.getRuntimeMXBean().getInputArguments());
            ListIterator<CallSite> it = vmArguments.listIterator();
            while (it.hasNext()) {
                String value = (String)it.next();
                if (value.contains("=")) {
                    String[] stringArray = value.split("=", 2);
                    if (stringArray[0].toLowerCase(Locale.ENGLISH).startsWith("-dproxy")) {
                        it.set((CallSite)((Object)(stringArray[0] + "=xxx")));
                        continue;
                    }
                    if ("-Djnlpx.vmargs".equals(stringArray[0])) {
                        it.remove();
                        continue;
                    }
                    String val = ShowStatusReportAction.paramCleanup(stringArray[1]);
                    if (val.equals(stringArray[1])) continue;
                    it.set((CallSite)((Object)(stringArray[0] + "=" + val)));
                    continue;
                }
                if (!value.startsWith("-X")) continue;
                it.remove();
            }
            if (!vmArguments.isEmpty()) {
                text.format("VM arguments: %s%n", ShowStatusReportAction.paramCleanup(vmArguments).toString().replace("\\\\", "\\"));
            }
        }
        catch (SecurityException e) {
            Logging.trace(e);
        }
        List<String> commandLineArgs = MainApplication.getCommandLineArgs();
        if (!commandLineArgs.isEmpty()) {
            text.format("Program arguments: %s%n", Arrays.toString(ShowStatusReportAction.paramCleanup(commandLineArgs).toArray()));
        }
        if ((dataset = MainApplication.getLayerManager().getActiveDataSet()) != null) {
            String result = DatasetConsistencyTest.runTests(dataset);
            if (result.isEmpty()) {
                text.println("Dataset consistency test: No problems found");
            } else {
                text.println();
                text.println("Dataset consistency test:");
                text.println(result);
            }
        }
        text.println();
        ShowStatusReportAction.appendCollection(text, "Plugins", Utils.transform(PluginHandler.getBugReportInformation(), i -> "+ " + i));
        ShowStatusReportAction.appendCollection(text, "Tagging presets", ShowStatusReportAction.getCustomUrls(PresetPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(text, "Map paint styles", ShowStatusReportAction.getCustomUrls(MapPaintPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(text, "Validator rules", ShowStatusReportAction.getCustomUrls(ValidatorPrefHelper.INSTANCE));
        ShowStatusReportAction.appendCollection(text, "Last errors/warnings", Utils.transform(Logging.getLastErrorAndWarnings(), i -> "- " + i));
        String osmApi = OsmApi.getOsmApi().getServerUrl();
        if (!Config.getUrls().getDefaultOsmApiUrl().equals(osmApi.trim())) {
            text.format("OSM API: %s%n", osmApi);
        }
        text.println();
        return stringWriter.toString();
    }

    private static String toString(Dimension dimension) {
        return dimension.width + "\u00d7" + dimension.height;
    }

    private static Collection<String> getCustomUrls(SourcePrefHelper helper) {
        Set defaultUrls = helper.getDefault().stream().map(i -> i.url).collect(Collectors.toSet());
        return helper.get().stream().filter(i -> !defaultUrls.contains(i.url)).map(i -> (i.active ? "+ " : "- ") + i.url).collect(Collectors.toList());
    }

    private static List<String> paramCleanup(Collection<String> params) {
        return params.stream().map(ShowStatusReportAction::paramCleanup).collect(Collectors.toList());
    }

    static Map<String, String> getAnonimicDirectorySymbolMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(PlatformManager.isPlatformWindows() ? "%JAVA_HOME%" : "${JAVA_HOME}", Utils.getSystemEnv("JAVA_HOME"));
        map.put("<java.home>", Utils.getSystemProperty("java.home"));
        map.put("<josm.pref>", Config.getDirs().getPreferencesDirectory(false).toString());
        map.put("<josm.userdata>", Config.getDirs().getUserDataDirectory(false).toString());
        map.put("<josm.cache>", Config.getDirs().getCacheDirectory(false).toString());
        map.put(PlatformManager.isPlatformWindows() ? "%UserProfile%" : "${HOME}", Utils.getSystemProperty("user.home"));
        return map;
    }

    static String paramCleanup(String param) {
        String userName = Utils.getSystemProperty("user.name");
        String userNameAlt = "<user.name>";
        String val = param;
        for (Map.Entry<String, String> entry : ShowStatusReportAction.getAnonimicDirectorySymbolMap().entrySet()) {
            val = ShowStatusReportAction.paramReplace(val, entry.getValue(), entry.getKey());
        }
        if (userName != null && userName.length() >= 3) {
            val = ShowStatusReportAction.paramReplace(val, userName, "<user.name>");
        }
        return val;
    }

    private static String paramReplace(String str, String target, String replacement) {
        return target == null ? str : str.replace(target, replacement);
    }

    private static void appendCollection(PrintWriter text, String label, Collection<String> col) {
        if (!col.isEmpty()) {
            text.append(col.stream().map(o -> ShowStatusReportAction.paramCleanup(o) + "\n").collect(Collectors.joining("", label + ":\n", "\n")));
        }
    }

    private static String valueCleanup(Object value) {
        String valueString = value.toString();
        if (valueString.length() > 512 && value instanceof Collection) {
            valueString = ((Collection)value).stream().map(v -> {
                if (v instanceof Map) {
                    LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>((Map)v);
                    map.computeIfPresent("icon", (k, icon) -> Utils.shortenString(icon.toString(), 32));
                    return map.toString();
                }
                return String.valueOf(v);
            }).collect(Collectors.joining(",\n  ", "[", "\n]"));
        }
        return ShowStatusReportAction.paramCleanup(valueString);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StringBuilder text = new StringBuilder();
        String reportHeader = ShowStatusReportAction.getReportHeader();
        text.append(reportHeader);
        Preferences.main().getAllSettings().forEach((key, setting) -> {
            if ("file-open.history".equals(key) || "download.overpass.query".equals(key) || "download.overpass.queries".equals(key) || "iodb.stored.offsets".equals(key) || key.contains("username") || key.contains("password") || key.contains("access-token")) {
                return;
            }
            text.append(ShowStatusReportAction.paramCleanup(key)).append('=').append(ShowStatusReportAction.valueCleanup(setting.getValue())).append('\n');
        });
        DebugTextDisplay ta = new DebugTextDisplay(text.toString());
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Status Report", new Object[0]), I18n.tr("Copy to clipboard and close", new Object[0]), I18n.tr("Report bug", new Object[0]), I18n.tr("Close", new Object[0]));
        ed.setButtonIcons("copy", "bug", "cancel");
        ed.configureContextsensitiveHelp("/Action/ShowStatusReport", true);
        ed.setContent(ta, false);
        ed.setMinimumSize(new Dimension(380, 200));
        ed.setPreferredSize(new Dimension(700, MainApplication.getMainFrame().getHeight() - 50));
        switch (ed.showDialog().getValue()) {
            case 1: {
                ta.copyToClipboard();
                break;
            }
            case 2: {
                BugReportSender.reportBug(reportHeader);
                break;
            }
        }
        GuiHelper.destroyComponents(ed, false);
    }
}

