/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox;

import java.util.Arrays;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.Command;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.InvalidMapboxVectorTileException;

public class CommandInteger {
    private final Command type;
    private final short[] parameters;
    private int added;

    public CommandInteger(int command) {
        long unsigned = Integer.toUnsignedLong(command);
        Command rType = null;
        for (Command tType : Command.getAllValues()) {
            if ((long)tType.getId() != (unsigned & 7L)) continue;
            rType = tType;
            break;
        }
        this.type = rType;
        if (this.type == null) {
            throw new InvalidMapboxVectorTileException();
        }
        int operationsInt = (int)(unsigned >> 3);
        this.parameters = new short[operationsInt * this.type.getParameterNumber()];
    }

    public void addParameter(Number parameterInteger) {
        this.parameters[this.added++] = parameterInteger.shortValue();
    }

    public void addParameter(long parameterInteger) {
        this.parameters[this.added++] = (short)parameterInteger;
    }

    public short[] getOperations() {
        return this.parameters;
    }

    public Command getType() {
        return this.type;
    }

    public boolean hasAllExpectedParameters() {
        return this.added >= this.parameters.length;
    }

    public String toString() {
        return "CommandInteger [type=" + String.valueOf((Object)this.type) + ", parameters=" + Arrays.toString(this.parameters) + "]";
    }
}

