/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.MultikeyShortcutAction;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public final class ActivateLayerAction
extends AbstractAction
implements IEnabledStateUpdating,
MainLayerManager.ActiveLayerChangeListener,
MultikeyShortcutAction,
Destroyable {
    private transient Layer layer;
    private final transient Shortcut multikeyShortcut;
    private final LayerListDialog.LayerListModel model;

    public ActivateLayerAction(Layer layer, LayerListDialog.LayerListModel model) {
        this(model);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.putValue("Name", I18n.tr("Activate", new Object[0]));
        this.updateEnabledState();
    }

    public ActivateLayerAction(LayerListDialog.LayerListModel model) {
        this.model = model;
        this.putValue("Name", I18n.tr("Activate", new Object[0]));
        new ImageProvider("dialogs", "activate").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Activate the selected layer", new Object[0]));
        this.multikeyShortcut = Shortcut.registerShortcut("core_multikey:activateLayer", I18n.tr("Multikey: {0}", I18n.tr("Activate layer", new Object[0])), 65, 5005);
        this.multikeyShortcut.setAccelerator(this);
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#ActivateLayer"));
    }

    @Override
    public Shortcut getMultikeyShortcut() {
        return this.multikeyShortcut;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Layer toActivate;
        if (this.layer != null) {
            toActivate = this.layer;
        } else {
            List<Layer> layers = this.model.getSelectedLayers();
            if (layers.isEmpty()) {
                return;
            }
            toActivate = layers.get(0);
        }
        this.execute(toActivate);
    }

    private void execute(Layer layer) {
        this.model.getLayerManager().setActiveLayer(layer);
        layer.setVisible(true);
    }

    boolean isActiveLayer(Layer layer) {
        return this.model.getLayerManager().getActiveLayer() == layer;
    }

    @Override
    public void updateEnabledState() {
        GuiHelper.runInEDTAndWait(() -> {
            if (this.layer == null) {
                if (this.model.getSelectedLayers().size() != 1) {
                    this.setEnabled(false);
                    return;
                }
                this.setEnabled(!this.isActiveLayer(this.model.getSelectedLayers().get(0)));
            } else {
                this.setEnabled(!this.isActiveLayer(this.layer));
            }
        });
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.updateEnabledState();
    }

    @Override
    public void executeMultikeyAction(int index, boolean repeat) {
        Layer l = LayerListDialog.getLayerForIndex(index);
        if (l != null) {
            this.execute(l);
        }
    }

    @Override
    public List<MultikeyShortcutAction.MultikeyInfo> getMultikeyCombinations() {
        return LayerListDialog.getLayerInfoByClass(Layer.class);
    }

    @Override
    public MultikeyShortcutAction.MultikeyInfo getLastMultikeyAction() {
        return null;
    }

    @Override
    public void destroy() {
        this.layer = null;
    }
}

