/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoaderJob;
import org.openstreetmap.josm.gui.preferences.imagery.HeadersTable;
import org.openstreetmap.josm.gui.util.DocumentAdapter;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public abstract class AddImageryPanel
extends JPanel {
    protected final JosmTextArea rawUrl = new JosmTextArea(3, 40).transferFocusOnTab();
    protected final JosmTextField name = new JosmTextField();
    protected final transient Collection<ContentValidationListener> listeners = new ArrayList<ContentValidationListener>();
    private final JCheckBox validGeoreference = new JCheckBox(I18n.tr("Is layer properly georeferenced?", new Object[0]));
    private HeadersTable headersTable;
    private JSpinner minimumCacheExpiry;
    private JComboBox<String> minimumCacheExpiryUnit;
    private TimeUnit currentUnit;

    protected AddImageryPanel() {
        this(new GridBagLayout());
        this.headersTable = new HeadersTable();
        this.minimumCacheExpiry = new JSpinner(new SpinnerNumberModel((Number)TimeUnit.MILLISECONDS.toSeconds(TMSCachedTileLoaderJob.MINIMUM_EXPIRES.get()), Long.valueOf(0L), Long.valueOf(Integer.MAX_VALUE), (Number)1));
        List<String> units = Arrays.asList(I18n.tr("seconds", new Object[0]), I18n.tr("minutes", new Object[0]), I18n.tr("hours", new Object[0]), I18n.tr("days", new Object[0]));
        this.minimumCacheExpiryUnit = new JComboBox<String>(units.toArray(new String[0]));
        this.currentUnit = TimeUnit.SECONDS;
        this.minimumCacheExpiryUnit.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                long newValue = 0L;
                switch (units.indexOf(e.getItem())) {
                    case 0: {
                        newValue = this.currentUnit.toSeconds((Long)this.minimumCacheExpiry.getValue());
                        this.currentUnit = TimeUnit.SECONDS;
                        break;
                    }
                    case 1: {
                        newValue = this.currentUnit.toMinutes((Long)this.minimumCacheExpiry.getValue());
                        this.currentUnit = TimeUnit.MINUTES;
                        break;
                    }
                    case 2: {
                        newValue = this.currentUnit.toHours((Long)this.minimumCacheExpiry.getValue());
                        this.currentUnit = TimeUnit.HOURS;
                        break;
                    }
                    case 3: {
                        newValue = this.currentUnit.toDays((Long)this.minimumCacheExpiry.getValue());
                        this.currentUnit = TimeUnit.DAYS;
                        break;
                    }
                    default: {
                        Logging.warn("Unknown unit: " + units.indexOf(e.getItem()));
                    }
                }
                this.minimumCacheExpiry.setValue(newValue);
            }
        });
    }

    protected void addCommonSettings() {
        if (ExpertToggleAction.isExpert()) {
            this.add(new JLabel(I18n.tr("Minimum cache expiry: ", new Object[0])));
            this.add(this.minimumCacheExpiry);
            this.add(this.minimumCacheExpiryUnit, GBC.eol());
            this.add((Component)new JLabel(I18n.tr("Set custom HTTP headers (if needed):", new Object[0])), GBC.eop());
            this.add((Component)this.headersTable, GBC.eol().fill());
            this.add((Component)this.validGeoreference, GBC.eop().fill(2));
        }
    }

    protected Map<String, String> getCommonHeaders() {
        return this.headersTable.getHeaders();
    }

    protected boolean getCommonIsValidGeoreference() {
        return this.validGeoreference.isSelected();
    }

    protected AddImageryPanel(LayoutManager layout) {
        super(layout);
        this.registerValidableComponent(this.name);
    }

    protected final void registerValidableComponent(AbstractButton component) {
        component.addChangeListener(e -> this.notifyListeners());
    }

    protected final void registerValidableComponent(JTextComponent component) {
        component.getDocument().addDocumentListener(DocumentAdapter.create(ignore -> this.notifyListeners()));
    }

    protected abstract ImageryInfo getImageryInfo();

    protected static String sanitize(String s) {
        return s.replaceAll("[\r\n]+", "").trim();
    }

    protected static String sanitize(String s, ImageryInfo.ImageryType type) {
        String ret = s;
        String imageryType = type.getTypeString() + ":";
        if (ret.startsWith(imageryType)) {
            ret = ret.substring(imageryType.length());
        }
        return AddImageryPanel.sanitize(ret);
    }

    protected final String getImageryName() {
        return AddImageryPanel.sanitize(this.name.getText());
    }

    protected final String getImageryRawUrl() {
        return AddImageryPanel.sanitize(this.rawUrl.getText());
    }

    protected abstract boolean isImageryValid();

    public final void addContentValidationListener(ContentValidationListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    private void notifyListeners() {
        for (ContentValidationListener l : this.listeners) {
            l.contentChanged(this.isImageryValid());
        }
    }

    @FunctionalInterface
    public static interface ContentValidationListener {
        public void contentChanged(boolean var1);
    }
}

