/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.spi.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.spi.preferences.AbstractSetting;
import org.openstreetmap.josm.spi.preferences.SettingVisitor;
import org.openstreetmap.josm.tools.StreamUtils;
import org.openstreetmap.josm.tools.Utils;

public class ListListSetting
extends AbstractSetting<List<List<String>>> {
    public ListListSetting(List<List<String>> value) {
        super(value);
        this.consistencyTest();
    }

    public static ListListSetting create(Collection<Collection<String>> value) {
        if (value != null) {
            List<List<String>> valueList = value.stream().map(ArrayList::new).collect(Collectors.toList());
            return new ListListSetting(valueList);
        }
        return new ListListSetting(null);
    }

    public ListListSetting copy() {
        if (this.value == null) {
            return new ListListSetting(null);
        }
        List<List<String>> copy = ((List)this.value).stream().map(Utils::toUnmodifiableList).collect(StreamUtils.toUnmodifiableList());
        return new ListListSetting(copy);
    }

    private void consistencyTest() {
        if (this.value != null) {
            if (((List)this.value).contains(null)) {
                throw new IllegalArgumentException("Error: Null as list element in preference setting");
            }
            for (Collection lst : (List)this.value) {
                if (!lst.contains(null)) continue;
                throw new IllegalArgumentException("Error: Null as inner list element in preference setting");
            }
        }
    }

    @Override
    public void visit(SettingVisitor visitor) {
        visitor.visit(this);
    }

    public ListListSetting getNullInstance() {
        return new ListListSetting(null);
    }
}

