/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.tools.Logging;

public final class FontsManager {
    private static final Collection<String> INCLUDED_FONTS = Arrays.asList("DroidSans.ttf", "DroidSans-Bold.ttf");

    private FontsManager() {
    }

    public static void initialize() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String fontFile : INCLUDED_FONTS) {
            String url = "resource://data/fonts/" + fontFile;
            try (CachedFile cf = new CachedFile(url);){
                InputStream i = cf.getInputStream();
                try {
                    ge.registerFont(Font.createFont(0, i));
                }
                finally {
                    if (i == null) continue;
                    i.close();
                }
            }
            catch (FontFormatException | IOException ex) {
                Logging.error("Unable to register font {0}", fontFile);
                Logging.error(ex);
            }
        }
    }
}

