/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.math.BigInteger;
import java.util.Arrays;

public class FDBigInteger {
    static final int[] SMALL_5_POW;
    static final long[] LONG_5_POW;
    private static final int MAX_FIVE_POW = 340;
    private static final FDBigInteger[] POW_5_CACHE;
    public static final FDBigInteger ZERO;
    private static final long LONG_MASK = 0xFFFFFFFFL;
    private int[] data;
    private int offset;
    private int nWords;
    private boolean isImmutable = false;

    private FDBigInteger(int[] nArray, int n) {
        this.data = nArray;
        this.offset = n;
        this.nWords = nArray.length;
        this.trimLeadingZeros();
    }

    public FDBigInteger(long l, char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = Math.max((n2 + 8) / 9, 2);
        this.data = new int[n5];
        this.data[0] = (int)l;
        this.data[1] = (int)(l >>> 32);
        this.offset = 0;
        this.nWords = 2;
        int n6 = n;
        int n7 = n2 - 5;
        while (n6 < n7) {
            n4 = n6 + 5;
            n3 = cArray[n6++] - 48;
            while (n6 < n4) {
                n3 = 10 * n3 + cArray[n6++] - 48;
            }
            this.multAddMe(100000, n3);
        }
        n4 = 1;
        n3 = 0;
        while (n6 < n2) {
            n3 = 10 * n3 + cArray[n6++] - 48;
            n4 *= 10;
        }
        if (n4 != 1) {
            this.multAddMe(n4, n3);
        }
        this.trimLeadingZeros();
    }

    public static FDBigInteger valueOfPow52(int n, int n2) {
        if (n != 0) {
            if (n2 == 0) {
                return FDBigInteger.big5pow(n);
            }
            if (n < SMALL_5_POW.length) {
                int n3 = SMALL_5_POW[n];
                int n4 = n2 >> 5;
                int n5 = n2 & 0x1F;
                if (n5 == 0) {
                    return new FDBigInteger(new int[]{n3}, n4);
                }
                return new FDBigInteger(new int[]{n3 << n5, n3 >>> 32 - n5}, n4);
            }
            return FDBigInteger.big5pow(n).leftShift(n2);
        }
        return FDBigInteger.valueOfPow2(n2);
    }

    public static FDBigInteger valueOfMulPow52(long l, int n, int n2) {
        assert (n >= 0) : n;
        assert (n2 >= 0) : n2;
        int n3 = (int)l;
        int n4 = (int)(l >>> 32);
        int n5 = n2 >> 5;
        int n6 = n2 & 0x1F;
        if (n != 0) {
            int[] nArray;
            if (n < SMALL_5_POW.length) {
                long l2 = (long)SMALL_5_POW[n] & 0xFFFFFFFFL;
                long l3 = ((long)n3 & 0xFFFFFFFFL) * l2;
                n3 = (int)l3;
                l3 >>>= 32;
                l3 = ((long)n4 & 0xFFFFFFFFL) * l2 + l3;
                n4 = (int)l3;
                int n7 = (int)(l3 >>> 32);
                if (n6 == 0) {
                    return new FDBigInteger(new int[]{n3, n4, n7}, n5);
                }
                return new FDBigInteger(new int[]{n3 << n6, n4 << n6 | n3 >>> 32 - n6, n7 << n6 | n4 >>> 32 - n6, n7 >>> 32 - n6}, n5);
            }
            FDBigInteger fDBigInteger = FDBigInteger.big5pow(n);
            if (n4 == 0) {
                nArray = new int[fDBigInteger.nWords + 1 + (n2 != 0 ? 1 : 0)];
                FDBigInteger.mult(fDBigInteger.data, fDBigInteger.nWords, n3, nArray);
            } else {
                nArray = new int[fDBigInteger.nWords + 2 + (n2 != 0 ? 1 : 0)];
                FDBigInteger.mult(fDBigInteger.data, fDBigInteger.nWords, n3, n4, nArray);
            }
            return new FDBigInteger(nArray, fDBigInteger.offset).leftShift(n2);
        }
        if (n2 != 0) {
            if (n6 == 0) {
                return new FDBigInteger(new int[]{n3, n4}, n5);
            }
            return new FDBigInteger(new int[]{n3 << n6, n4 << n6 | n3 >>> 32 - n6, n4 >>> 32 - n6}, n5);
        }
        return new FDBigInteger(new int[]{n3, n4}, 0);
    }

    private static FDBigInteger valueOfPow2(int n) {
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        return new FDBigInteger(new int[]{1 << n3}, n2);
    }

    private void trimLeadingZeros() {
        int n = this.nWords;
        if (n > 0 && this.data[--n] == 0) {
            while (n > 0 && this.data[n - 1] == 0) {
                --n;
            }
            this.nWords = n;
            if (n == 0) {
                this.offset = 0;
            }
        }
    }

    public int getNormalizationBias() {
        if (this.nWords == 0) {
            throw new IllegalArgumentException("Zero value cannot be normalized");
        }
        int n = Integer.numberOfLeadingZeros(this.data[this.nWords - 1]);
        return n < 4 ? 28 + n : n - 4;
    }

    private static void leftShift(int[] nArray, int n, int[] nArray2, int n2, int n3, int n4) {
        int n5;
        while (n > 0) {
            n5 = n4 << n2;
            n4 = nArray[n - 1];
            nArray2[n] = n5 |= n4 >>> n3;
            --n;
        }
        nArray2[0] = n5 = n4 << n2;
    }

    public FDBigInteger leftShift(int n) {
        if (n == 0 || this.nWords == 0) {
            return this;
        }
        int n2 = n >> 5;
        int n3 = n & 0x1F;
        if (this.isImmutable) {
            int[] nArray;
            if (n3 == 0) {
                return new FDBigInteger(Arrays.copyOf(this.data, this.nWords), this.offset + n2);
            }
            int n4 = this.nWords - 1;
            int n5 = this.data[n4];
            int n6 = 32 - n3;
            int n7 = n5 >>> n6;
            if (n7 != 0) {
                nArray = new int[this.nWords + 1];
                nArray[this.nWords] = n7;
            } else {
                nArray = new int[this.nWords];
            }
            FDBigInteger.leftShift(this.data, n4, nArray, n3, n6, n5);
            return new FDBigInteger(nArray, this.offset + n2);
        }
        if (n3 != 0) {
            int n8 = 32 - n3;
            if (this.data[0] << n3 == 0) {
                int n9;
                int n10;
                int n11 = this.data[n10];
                for (n10 = 0; n10 < this.nWords - 1; ++n10) {
                    n9 = n11 >>> n8;
                    n11 = this.data[n10 + 1];
                    this.data[n10] = n9 |= n11 << n3;
                }
                this.data[n10] = n9 = n11 >>> n8;
                if (n9 == 0) {
                    --this.nWords;
                }
                ++this.offset;
            } else {
                int n12 = this.nWords - 1;
                int n13 = this.data[n12];
                int n14 = n13 >>> n8;
                int[] nArray = this.data;
                int[] nArray2 = this.data;
                if (n14 != 0) {
                    if (this.nWords == this.data.length) {
                        this.data = nArray = new int[this.nWords + 1];
                    }
                    nArray[this.nWords++] = n14;
                }
                FDBigInteger.leftShift(nArray2, n12, nArray, n3, n8, n13);
            }
        }
        this.offset += n2;
        return this;
    }

    private int size() {
        return this.nWords + this.offset;
    }

    public int quoRemIteration(FDBigInteger fDBigInteger) throws IllegalArgumentException {
        int n;
        assert (!this.isImmutable) : "cannot modify immutable value";
        int n2 = this.size();
        if (n2 < (n = fDBigInteger.size())) {
            int n3 = FDBigInteger.multAndCarryBy10(this.data, this.nWords, this.data);
            if (n3 != 0) {
                this.data[this.nWords++] = n3;
            } else {
                this.trimLeadingZeros();
            }
            return 0;
        }
        if (n2 > n) {
            throw new IllegalArgumentException("disparate values");
        }
        long l = ((long)this.data[this.nWords - 1] & 0xFFFFFFFFL) / ((long)fDBigInteger.data[fDBigInteger.nWords - 1] & 0xFFFFFFFFL);
        long l2 = this.multDiffMe(l, fDBigInteger);
        if (l2 != 0L) {
            long l3 = 0L;
            int n4 = fDBigInteger.offset - this.offset;
            int[] nArray = fDBigInteger.data;
            int[] nArray2 = this.data;
            while (l3 == 0L) {
                int n5 = 0;
                for (int i = n4; i < this.nWords; ++i) {
                    nArray2[i] = (int)(l3 += ((long)nArray2[i] & 0xFFFFFFFFL) + ((long)nArray[n5] & 0xFFFFFFFFL));
                    l3 >>>= 32;
                    ++n5;
                }
                assert (l3 == 0L || l3 == 1L) : l3;
                --l;
            }
        }
        int n6 = FDBigInteger.multAndCarryBy10(this.data, this.nWords, this.data);
        assert (n6 == 0) : n6;
        this.trimLeadingZeros();
        return (int)l;
    }

    public FDBigInteger multBy10() {
        if (this.nWords == 0) {
            return this;
        }
        if (this.isImmutable) {
            int[] nArray = new int[this.nWords + 1];
            nArray[this.nWords] = FDBigInteger.multAndCarryBy10(this.data, this.nWords, nArray);
            return new FDBigInteger(nArray, this.offset);
        }
        int n = FDBigInteger.multAndCarryBy10(this.data, this.nWords, this.data);
        if (n != 0) {
            if (this.nWords == this.data.length) {
                if (this.data[0] == 0) {
                    System.arraycopy(this.data, 1, this.data, 0, --this.nWords);
                    ++this.offset;
                } else {
                    this.data = Arrays.copyOf(this.data, this.data.length + 1);
                }
            }
            this.data[this.nWords++] = n;
        } else {
            this.trimLeadingZeros();
        }
        return this;
    }

    public FDBigInteger multByPow52(int n, int n2) {
        if (this.nWords == 0) {
            return this;
        }
        FDBigInteger fDBigInteger = this;
        if (n != 0) {
            int n3;
            int n4 = n3 = n2 != 0 ? 1 : 0;
            if (n < SMALL_5_POW.length) {
                int[] nArray = new int[this.nWords + 1 + n3];
                FDBigInteger.mult(this.data, this.nWords, SMALL_5_POW[n], nArray);
                fDBigInteger = new FDBigInteger(nArray, this.offset);
            } else {
                FDBigInteger fDBigInteger2 = FDBigInteger.big5pow(n);
                int[] nArray = new int[this.nWords + fDBigInteger2.size() + n3];
                FDBigInteger.mult(this.data, this.nWords, fDBigInteger2.data, fDBigInteger2.nWords, nArray);
                fDBigInteger = new FDBigInteger(nArray, this.offset + fDBigInteger2.offset);
            }
        }
        return fDBigInteger.leftShift(n2);
    }

    private static void mult(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3) {
        for (int i = 0; i < n; ++i) {
            long l = (long)nArray[i] & 0xFFFFFFFFL;
            long l2 = 0L;
            for (int j = 0; j < n2; ++j) {
                nArray3[i + j] = (int)(l2 += ((long)nArray3[i + j] & 0xFFFFFFFFL) + l * ((long)nArray2[j] & 0xFFFFFFFFL));
                l2 >>>= 32;
            }
            nArray3[i + n2] = (int)l2;
        }
    }

    public FDBigInteger leftInplaceSub(FDBigInteger fDBigInteger) {
        assert (this.size() >= fDBigInteger.size()) : "result should be positive";
        FDBigInteger fDBigInteger2 = this.isImmutable ? new FDBigInteger((int[])this.data.clone(), this.offset) : this;
        int n = fDBigInteger.offset - fDBigInteger2.offset;
        int[] nArray = fDBigInteger.data;
        int[] nArray2 = fDBigInteger2.data;
        int n2 = fDBigInteger.nWords;
        int n3 = fDBigInteger2.nWords;
        if (n < 0) {
            int n4 = n3 - n;
            if (n4 < nArray2.length) {
                System.arraycopy(nArray2, 0, nArray2, -n, n3);
                Arrays.fill(nArray2, 0, -n, 0);
            } else {
                int[] nArray3 = new int[n4];
                System.arraycopy(nArray2, 0, nArray3, -n, n3);
                nArray2 = nArray3;
                fDBigInteger2.data = nArray3;
            }
            fDBigInteger2.offset = fDBigInteger.offset;
            fDBigInteger2.nWords = n3 = n4;
            n = 0;
        }
        long l = 0L;
        int n5 = n;
        for (int i = 0; i < n2 && n5 < n3; ++i, ++n5) {
            long l2 = ((long)nArray2[n5] & 0xFFFFFFFFL) - ((long)nArray[i] & 0xFFFFFFFFL) + l;
            nArray2[n5] = (int)l2;
            l = l2 >> 32;
        }
        while (l != 0L && n5 < n3) {
            long l3 = ((long)nArray2[n5] & 0xFFFFFFFFL) + l;
            nArray2[n5] = (int)l3;
            l = l3 >> 32;
            ++n5;
        }
        assert (l == 0L) : l;
        fDBigInteger2.trimLeadingZeros();
        return fDBigInteger2;
    }

    public FDBigInteger rightInplaceSub(FDBigInteger fDBigInteger) {
        int n;
        assert (this.size() >= fDBigInteger.size()) : "result should be positive";
        FDBigInteger fDBigInteger2 = this;
        if (fDBigInteger.isImmutable) {
            fDBigInteger = new FDBigInteger((int[])fDBigInteger.data.clone(), fDBigInteger.offset);
        }
        int n2 = fDBigInteger2.offset - fDBigInteger.offset;
        int[] nArray = fDBigInteger.data;
        int[] nArray2 = fDBigInteger2.data;
        int n3 = fDBigInteger.nWords;
        int n4 = fDBigInteger2.nWords;
        if (n2 < 0) {
            n = n4;
            if (n < nArray.length) {
                System.arraycopy(nArray, 0, nArray, -n2, n3);
                Arrays.fill(nArray, 0, -n2, 0);
            } else {
                int[] nArray3 = new int[n];
                System.arraycopy(nArray, 0, nArray3, -n2, n3);
                nArray = nArray3;
                fDBigInteger.data = nArray3;
            }
            fDBigInteger.offset = fDBigInteger2.offset;
            n3 -= n2;
            n2 = 0;
        } else {
            n = n4 + n2;
            if (n >= nArray.length) {
                fDBigInteger.data = nArray = Arrays.copyOf(nArray, n);
            }
        }
        long l = 0L;
        for (n = 0; n < n2; ++n) {
            long l2 = 0L - ((long)nArray[n] & 0xFFFFFFFFL) + l;
            nArray[n] = (int)l2;
            l = l2 >> 32;
        }
        for (int i = 0; i < n4; ++i) {
            long l3 = ((long)nArray2[i] & 0xFFFFFFFFL) - ((long)nArray[n] & 0xFFFFFFFFL) + l;
            nArray[n] = (int)l3;
            l = l3 >> 32;
            ++n;
        }
        assert (l == 0L) : l;
        fDBigInteger.nWords = n;
        fDBigInteger.trimLeadingZeros();
        return fDBigInteger;
    }

    private static int checkZeroTail(int[] nArray, int n) {
        while (n > 0) {
            if (nArray[--n] == 0) continue;
            return 1;
        }
        return 0;
    }

    public int cmp(FDBigInteger fDBigInteger) {
        int n = this.nWords + this.offset;
        int n2 = fDBigInteger.nWords + fDBigInteger.offset;
        if (n > n2) {
            return 1;
        }
        if (n < n2) {
            return -1;
        }
        int n3 = this.nWords;
        int n4 = fDBigInteger.nWords;
        while (n3 > 0 && n4 > 0) {
            int n5;
            int n6;
            if ((n6 = this.data[--n3]) == (n5 = fDBigInteger.data[--n4])) continue;
            return ((long)n6 & 0xFFFFFFFFL) < ((long)n5 & 0xFFFFFFFFL) ? -1 : 1;
        }
        if (n3 > 0) {
            return FDBigInteger.checkZeroTail(this.data, n3);
        }
        if (n4 > 0) {
            return -FDBigInteger.checkZeroTail(fDBigInteger.data, n4);
        }
        return 0;
    }

    public int cmpPow52(int n, int n2) {
        if (n == 0) {
            int n3 = n2 >> 5;
            int n4 = n2 & 0x1F;
            int n5 = this.nWords + this.offset;
            if (n5 > n3 + 1) {
                return 1;
            }
            if (n5 < n3 + 1) {
                return -1;
            }
            int n6 = this.data[this.nWords - 1];
            int n7 = 1 << n4;
            if (n6 != n7) {
                return ((long)n6 & 0xFFFFFFFFL) < ((long)n7 & 0xFFFFFFFFL) ? -1 : 1;
            }
            return FDBigInteger.checkZeroTail(this.data, this.nWords - 1);
        }
        return this.cmp(FDBigInteger.big5pow(n).leftShift(n2));
    }

    public int addAndCmp(FDBigInteger fDBigInteger, FDBigInteger fDBigInteger2) {
        int n;
        int n2;
        FDBigInteger fDBigInteger3;
        FDBigInteger fDBigInteger4;
        int n3;
        int n4 = fDBigInteger.size();
        if (n4 >= (n3 = fDBigInteger2.size())) {
            fDBigInteger4 = fDBigInteger;
            fDBigInteger3 = fDBigInteger2;
            n2 = n4;
            n = n3;
        } else {
            fDBigInteger4 = fDBigInteger2;
            fDBigInteger3 = fDBigInteger;
            n2 = n3;
            n = n4;
        }
        int n5 = this.size();
        if (n2 == 0) {
            return n5 == 0 ? 0 : 1;
        }
        if (n == 0) {
            return this.cmp(fDBigInteger4);
        }
        if (n2 > n5) {
            return -1;
        }
        if (n2 + 1 < n5) {
            return 1;
        }
        long l = (long)fDBigInteger4.data[fDBigInteger4.nWords - 1] & 0xFFFFFFFFL;
        if (n == n2) {
            l += (long)fDBigInteger3.data[fDBigInteger3.nWords - 1] & 0xFFFFFFFFL;
        }
        if (l >>> 32 == 0L) {
            if (l + 1L >>> 32 == 0L) {
                if (n2 < n5) {
                    return 1;
                }
                long l2 = (long)this.data[this.nWords - 1] & 0xFFFFFFFFL;
                if (l2 < l) {
                    return -1;
                }
                if (l2 > l + 1L) {
                    return 1;
                }
            }
        } else {
            if (n2 + 1 > n5) {
                return -1;
            }
            long l3 = (long)this.data[this.nWords - 1] & 0xFFFFFFFFL;
            if (l3 < (l >>>= 32)) {
                return -1;
            }
            if (l3 > l + 1L) {
                return 1;
            }
        }
        return this.cmp(fDBigInteger4.add(fDBigInteger3));
    }

    public void makeImmutable() {
        this.isImmutable = true;
    }

    private FDBigInteger mult(int n) {
        if (this.nWords == 0) {
            return this;
        }
        int[] nArray = new int[this.nWords + 1];
        FDBigInteger.mult(this.data, this.nWords, n, nArray);
        return new FDBigInteger(nArray, this.offset);
    }

    private FDBigInteger mult(FDBigInteger fDBigInteger) {
        if (this.nWords == 0) {
            return this;
        }
        if (this.size() == 1) {
            return fDBigInteger.mult(this.data[0]);
        }
        if (fDBigInteger.nWords == 0) {
            return fDBigInteger;
        }
        if (fDBigInteger.size() == 1) {
            return this.mult(fDBigInteger.data[0]);
        }
        int[] nArray = new int[this.nWords + fDBigInteger.nWords];
        FDBigInteger.mult(this.data, this.nWords, fDBigInteger.data, fDBigInteger.nWords, nArray);
        return new FDBigInteger(nArray, this.offset + fDBigInteger.offset);
    }

    private FDBigInteger add(FDBigInteger fDBigInteger) {
        int n;
        int n2;
        FDBigInteger fDBigInteger2;
        int n3;
        FDBigInteger fDBigInteger3;
        int n4;
        int n5 = this.size();
        if (n5 >= (n4 = fDBigInteger.size())) {
            fDBigInteger3 = this;
            n3 = n5;
            fDBigInteger2 = fDBigInteger;
            n2 = n4;
        } else {
            fDBigInteger3 = fDBigInteger;
            n3 = n4;
            fDBigInteger2 = this;
            n2 = n5;
        }
        int[] nArray = new int[n3 + 1];
        long l = 0L;
        for (n = 0; n < n2; ++n) {
            nArray[n] = (int)(l += (n < fDBigInteger3.offset ? 0L : (long)fDBigInteger3.data[n - fDBigInteger3.offset] & 0xFFFFFFFFL) + (n < fDBigInteger2.offset ? 0L : (long)fDBigInteger2.data[n - fDBigInteger2.offset] & 0xFFFFFFFFL));
            l >>= 32;
        }
        while (n < n3) {
            nArray[n] = (int)(l += n < fDBigInteger3.offset ? 0L : (long)fDBigInteger3.data[n - fDBigInteger3.offset] & 0xFFFFFFFFL);
            l >>= 32;
            ++n;
        }
        nArray[n3] = (int)l;
        return new FDBigInteger(nArray, 0);
    }

    private void multAddMe(int n, int n2) {
        long l = (long)n & 0xFFFFFFFFL;
        long l2 = l * ((long)this.data[0] & 0xFFFFFFFFL) + ((long)n2 & 0xFFFFFFFFL);
        this.data[0] = (int)l2;
        l2 >>>= 32;
        for (int i = 1; i < this.nWords; ++i) {
            this.data[i] = (int)(l2 += l * ((long)this.data[i] & 0xFFFFFFFFL));
            l2 >>>= 32;
        }
        if (l2 != 0L) {
            this.data[this.nWords++] = (int)l2;
        }
    }

    private long multDiffMe(long l, FDBigInteger fDBigInteger) {
        long l2 = 0L;
        if (l != 0L) {
            int n = fDBigInteger.offset - this.offset;
            if (n >= 0) {
                int[] nArray = fDBigInteger.data;
                int[] nArray2 = this.data;
                int n2 = 0;
                int n3 = n;
                while (n2 < fDBigInteger.nWords) {
                    nArray2[n3] = (int)(l2 += ((long)nArray2[n3] & 0xFFFFFFFFL) - l * ((long)nArray[n2] & 0xFFFFFFFFL));
                    l2 >>= 32;
                    ++n2;
                    ++n3;
                }
            } else {
                int n4;
                n = -n;
                int[] nArray = new int[this.nWords + n];
                int n5 = 0;
                int[] nArray3 = fDBigInteger.data;
                for (n4 = 0; n4 < n && n5 < fDBigInteger.nWords; ++n5, ++n4) {
                    nArray[n4] = (int)(l2 -= l * ((long)nArray3[n5] & 0xFFFFFFFFL));
                    l2 >>= 32;
                }
                int n6 = 0;
                int[] nArray4 = this.data;
                while (n5 < fDBigInteger.nWords) {
                    nArray[n4] = (int)(l2 += ((long)nArray4[n6] & 0xFFFFFFFFL) - l * ((long)nArray3[n5] & 0xFFFFFFFFL));
                    l2 >>= 32;
                    ++n5;
                    ++n6;
                    ++n4;
                }
                this.nWords += n;
                this.offset -= n;
                this.data = nArray;
            }
        }
        return l2;
    }

    private static int multAndCarryBy10(int[] nArray, int n, int[] nArray2) {
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            long l2 = ((long)nArray[i] & 0xFFFFFFFFL) * 10L + l;
            nArray2[i] = (int)l2;
            l = l2 >>> 32;
        }
        return (int)l;
    }

    private static void mult(int[] nArray, int n, int n2, int[] nArray2) {
        long l = (long)n2 & 0xFFFFFFFFL;
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            long l3 = ((long)nArray[i] & 0xFFFFFFFFL) * l + l2;
            nArray2[i] = (int)l3;
            l2 = l3 >>> 32;
        }
        nArray2[n] = (int)l2;
    }

    private static void mult(int[] nArray, int n, int n2, int n3, int[] nArray2) {
        long l;
        int n4;
        long l2 = (long)n2 & 0xFFFFFFFFL;
        long l3 = 0L;
        for (n4 = 0; n4 < n; ++n4) {
            l = l2 * ((long)nArray[n4] & 0xFFFFFFFFL) + l3;
            nArray2[n4] = (int)l;
            l3 = l >>> 32;
        }
        nArray2[n] = (int)l3;
        l2 = (long)n3 & 0xFFFFFFFFL;
        l3 = 0L;
        for (n4 = 0; n4 < n; ++n4) {
            l = ((long)nArray2[n4 + 1] & 0xFFFFFFFFL) + l2 * ((long)nArray[n4] & 0xFFFFFFFFL) + l3;
            nArray2[n4 + 1] = (int)l;
            l3 = l >>> 32;
        }
        nArray2[n + 1] = (int)l3;
    }

    private static FDBigInteger big5pow(int n) {
        assert (n >= 0) : n;
        if (n < 340) {
            return POW_5_CACHE[n];
        }
        return FDBigInteger.big5powRec(n);
    }

    private static FDBigInteger big5powRec(int n) {
        if (n < 340) {
            return POW_5_CACHE[n];
        }
        int n2 = n >> 1;
        int n3 = n - n2;
        FDBigInteger fDBigInteger = FDBigInteger.big5powRec(n2);
        if (n3 < SMALL_5_POW.length) {
            return fDBigInteger.mult(SMALL_5_POW[n3]);
        }
        return fDBigInteger.mult(FDBigInteger.big5powRec(n3));
    }

    public String toHexString() {
        int n;
        if (this.nWords == 0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder((this.nWords + this.offset) * 8);
        for (n = this.nWords - 1; n >= 0; --n) {
            String string = Integer.toHexString(this.data[n]);
            for (int i = string.length(); i < 8; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        for (n = this.offset; n > 0; --n) {
            stringBuilder.append("00000000");
        }
        return stringBuilder.toString();
    }

    public BigInteger toBigInteger() {
        byte[] byArray = new byte[this.nWords * 4 + 1];
        for (int i = 0; i < this.nWords; ++i) {
            int n = this.data[i];
            byArray[byArray.length - 4 * i - 1] = (byte)n;
            byArray[byArray.length - 4 * i - 2] = (byte)(n >> 8);
            byArray[byArray.length - 4 * i - 3] = (byte)(n >> 16);
            byArray[byArray.length - 4 * i - 4] = (byte)(n >> 24);
        }
        return new BigInteger(byArray).shiftLeft(this.offset * 32);
    }

    public String toString() {
        return this.toBigInteger().toString();
    }

    static {
        FDBigInteger fDBigInteger;
        int n;
        SMALL_5_POW = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        LONG_5_POW = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        POW_5_CACHE = new FDBigInteger[340];
        for (n = 0; n < SMALL_5_POW.length; ++n) {
            fDBigInteger = new FDBigInteger(new int[]{SMALL_5_POW[n]}, 0);
            fDBigInteger.makeImmutable();
            FDBigInteger.POW_5_CACHE[n] = fDBigInteger;
        }
        fDBigInteger = POW_5_CACHE[n - 1];
        while (n < 340) {
            FDBigInteger.POW_5_CACHE[n] = fDBigInteger = fDBigInteger.mult(5);
            fDBigInteger.makeImmutable();
            ++n;
        }
        ZERO = new FDBigInteger(new int[0], 0);
        ZERO.makeImmutable();
    }
}

