/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.ClearElrRecord;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.image.LocalReplicaChanges;
import org.apache.kafka.image.TopicDelta;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.Replicas;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.immutable.ImmutableMap;

public final class TopicsDelta {
    private final TopicsImage image;
    private final Map<Uuid, TopicDelta> changedTopics = new HashMap<Uuid, TopicDelta>();
    private final Set<Uuid> deletedTopicIds = new HashSet<Uuid>();
    private final Map<String, Uuid> createdTopics = new HashMap<String, Uuid>();

    public TopicsDelta(TopicsImage image) {
        this.image = image;
    }

    public TopicsImage image() {
        return this.image;
    }

    public Map<Uuid, TopicDelta> changedTopics() {
        return this.changedTopics;
    }

    public void replay(TopicRecord record) {
        TopicDelta delta = new TopicDelta(new TopicImage(record.name(), record.topicId(), Map.of()));
        this.changedTopics.put(record.topicId(), delta);
        this.createdTopics.put(record.name(), record.topicId());
    }

    TopicDelta getOrCreateTopicDelta(Uuid id) {
        TopicDelta topicDelta = this.changedTopics.get(id);
        if (topicDelta == null) {
            topicDelta = new TopicDelta(this.image.getTopic(id));
            this.changedTopics.put(id, topicDelta);
        }
        return topicDelta;
    }

    public void replay(PartitionRecord record) {
        TopicDelta topicDelta = this.getOrCreateTopicDelta(record.topicId());
        topicDelta.replay(record);
    }

    public void replay(PartitionChangeRecord record) {
        TopicDelta topicDelta = this.getOrCreateTopicDelta(record.topicId());
        topicDelta.replay(record);
    }

    private void maybeReplayClearElrRecord(Uuid topicId) {
        if (!this.deletedTopicIds.contains(topicId)) {
            TopicDelta topicDelta = this.getOrCreateTopicDelta(topicId);
            topicDelta.replay();
        }
    }

    public void replay(ClearElrRecord record) {
        if (!record.topicName().isEmpty()) {
            Uuid topicId2 = null;
            if (this.createdTopics.containsKey(record.topicName())) {
                topicId2 = this.createdTopics.get(record.topicName());
            } else if (this.image.getTopic(record.topicName()) != null) {
                topicId2 = this.image.getTopic(record.topicName()).id();
            }
            if (topicId2 == null) {
                throw new RuntimeException("Unable to clear elr for topic with name " + record.topicName() + ": no such topic found.");
            }
            this.maybeReplayClearElrRecord(topicId2);
        } else {
            this.image.topicsById().forEach((topicId, image) -> this.maybeReplayClearElrRecord((Uuid)topicId));
            this.createdTopicIds().forEach(this::maybeReplayClearElrRecord);
        }
    }

    public String replay(RemoveTopicRecord record) {
        String topicName;
        TopicDelta topicDelta = this.changedTopics.remove(record.topicId());
        if (topicDelta != null) {
            topicName = topicDelta.image().name();
            this.createdTopics.remove(topicName);
            if (this.image.topicsById().containsKey((Object)record.topicId())) {
                this.deletedTopicIds.add(record.topicId());
            }
        } else {
            TopicImage topicImage = this.image.getTopic(record.topicId());
            if (topicImage == null) {
                throw new RuntimeException("Unable to delete topic with id " + String.valueOf(record.topicId()) + ": no such topic found.");
            }
            topicName = topicImage.name();
            this.deletedTopicIds.add(record.topicId());
        }
        return topicName;
    }

    public void finishSnapshot() {
        for (Uuid topicId : this.image.topicsById().keySet()) {
            if (this.changedTopics.containsKey(topicId)) continue;
            this.deletedTopicIds.add(topicId);
        }
    }

    public void handleMetadataVersionChange(MetadataVersion newVersion) {
    }

    public TopicsImage apply() {
        ImmutableMap newTopicsById = this.image.topicsById();
        ImmutableMap newTopicsByName = this.image.topicsByName();
        for (Uuid uuid : this.deletedTopicIds) {
            TopicImage originalTopicToBeDeleted = (TopicImage)this.image.topicsById().get((Object)uuid);
            if (originalTopicToBeDeleted == null) {
                throw new IllegalStateException("Missing topic id " + String.valueOf(uuid));
            }
            newTopicsById = newTopicsById.removed((Object)uuid);
            newTopicsByName = newTopicsByName.removed((Object)originalTopicToBeDeleted.name());
        }
        for (Map.Entry entry : this.changedTopics.entrySet()) {
            Uuid topicId = (Uuid)entry.getKey();
            TopicImage newTopicToBeAddedOrUpdated = ((TopicDelta)entry.getValue()).apply();
            String topicName = newTopicToBeAddedOrUpdated.name();
            newTopicsById = newTopicsById.updated((Object)topicId, (Object)newTopicToBeAddedOrUpdated);
            newTopicsByName = newTopicsByName.updated((Object)topicName, (Object)newTopicToBeAddedOrUpdated);
        }
        return new TopicsImage(newTopicsById, newTopicsByName);
    }

    public TopicDelta changedTopic(Uuid topicId) {
        return this.changedTopics.get(topicId);
    }

    public boolean topicWasDeleted(String topicName) {
        TopicImage topicImage = this.image.getTopic(topicName);
        if (topicImage == null) {
            return false;
        }
        return this.deletedTopicIds.contains(topicImage.id());
    }

    public Set<Uuid> deletedTopicIds() {
        return this.deletedTopicIds;
    }

    public Collection<Uuid> createdTopicIds() {
        return this.createdTopics.values();
    }

    public LocalReplicaChanges localChanges(int brokerId) {
        HashSet<TopicPartition> deletes = new HashSet<TopicPartition>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> electedLeaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> leaders = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo> followers = new HashMap<TopicPartition, LocalReplicaChanges.PartitionInfo>();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        HashMap<TopicIdPartition, Uuid> directoryIds = new HashMap<TopicIdPartition, Uuid>();
        for (TopicDelta delta : this.changedTopics.values()) {
            LocalReplicaChanges changes = delta.localChanges(brokerId);
            deletes.addAll(changes.deletes());
            electedLeaders.putAll(changes.electedLeaders());
            leaders.putAll(changes.leaders());
            followers.putAll(changes.followers());
            topicIds.putAll(changes.topicIds());
            directoryIds.putAll(changes.directoryIds());
        }
        this.deletedTopicIds().forEach(topicId -> {
            TopicImage topicImage = this.image().getTopic((Uuid)topicId);
            topicImage.partitions().forEach((partitionId, prevPartition) -> {
                if (Replicas.contains(prevPartition.replicas, brokerId)) {
                    deletes.add(new TopicPartition(topicImage.name(), partitionId.intValue()));
                }
            });
        });
        return new LocalReplicaChanges(deletes, electedLeaders, leaders, followers, topicIds, directoryIds);
    }

    public String toString() {
        return "TopicsDelta(changedTopics=" + String.valueOf(this.changedTopics) + ", deletedTopicIds=" + String.valueOf(this.deletedTopicIds) + ", createdTopics=" + String.valueOf(this.createdTopics) + ")";
    }
}

